/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.util;

import com.mojang.logging.LogUtils;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import xland.mcmod.enchlevellangpatch.api.EnchantmentLevelLangPatch;
import xland.mcmod.neospeedzero.util.neoforge.DurationLocalizerImpl;

@OnlyIn(value=Dist.CLIENT)
public final class DurationLocalizer {
    private static final String PREFIX = "message.neospeedzero.duration.";
    private static final String TEMPLATE_KEY = "message.neospeedzero.duration.template";
    private static final String MAX_UNITS_KEY = "message.neospeedzero.duration.max_units";
    private static final String SHOW_ZERO_KEY = "message.neospeedzero.duration.show_zero_values";
    private static final String SEPARATOR_KEY = "message.neospeedzero.duration.separator";
    private static final String FINAL_SEPARATOR_KEY = "message.neospeedzero.duration.final_separator";
    @NotNull
    private final Map<String, String> translations;
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void bootstrap() {
        if (DurationLocalizer.isLangPatchAvailable()) {
            LOGGER.debug("Found LangPatch. Applying patch.");
            EnchantmentLevelLangPatch.registerPatch(Predicate.isEqual("message.neospeedzero.duration.placeholder"), (EnchantmentLevelLangPatch)EnchantmentLevelLangPatch.withFallback((translations, key, fallback) -> {
                if (!Boolean.parseBoolean((String)translations.get("message.neospeedzero.duration.apply_localizer"))) {
                    return null;
                }
                try {
                    Duration duration = Duration.ofMillis(Long.parseUnsignedLong(fallback));
                    return new DurationLocalizer(translations).localize(duration);
                }
                catch (Exception e) {
                    LOGGER.warn("Duration localization failed, using fallback", (Throwable)e);
                    return null;
                }
            }));
        } else {
            LOGGER.debug("LangPatch is not available. Use fallback settings.");
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static boolean isLangPatchAvailable() {
        return DurationLocalizerImpl.isLangPatchAvailable();
    }

    private DurationLocalizer(@NotNull Map<String, String> translations) {
        Objects.requireNonNull(translations, "translations");
        this.translations = translations;
    }

    @NotNull
    String localize(@NotNull Duration duration) {
        Objects.requireNonNull(duration, "duration");
        int maxUnits = this.getIntConfig(MAX_UNITS_KEY, Integer.MAX_VALUE);
        boolean showZeroValues = this.getBooleanConfig(SHOW_ZERO_KEY, false);
        String separator = this.getStringConfig(SEPARATOR_KEY, ", ");
        String finalSeparator = this.getStringConfig(FINAL_SEPARATOR_KEY, " and ");
        List<TimeUnitValue> units = this.decomposeDuration(duration, showZeroValues);
        if (units.size() > maxUnits) {
            units = units.subList(0, maxUnits);
        }
        List<String> localizedUnits = units.stream().map(this::localizeUnit).toList();
        return this.joinUnits(localizedUnits, separator, finalSeparator);
    }

    private List<TimeUnitValue> decomposeDuration(Duration duration, boolean showZeroValues) {
        ArrayList<TimeUnitValue> units = new ArrayList<TimeUnitValue>(5);
        long seconds = duration.getSeconds();
        long days = seconds / 86400L;
        long hours = seconds % 86400L / 3600L;
        long minutes = seconds % 3600L / 60L;
        long secs = seconds % 60L;
        long millis = duration.getNano() / 1000000;
        if (days > 0L || showZeroValues) {
            units.add(new TimeUnitValue("days", days));
        }
        if (hours > 0L || showZeroValues) {
            units.add(new TimeUnitValue("hours", hours));
        }
        if (minutes > 0L || showZeroValues) {
            units.add(new TimeUnitValue("minutes", minutes));
        }
        if (secs > 0L || showZeroValues) {
            units.add(new TimeUnitValue("seconds", secs));
        }
        if (millis > 0L || showZeroValues) {
            units.add(new TimeUnitValue("millis", millis));
        }
        return units;
    }

    private String localizeUnit(TimeUnitValue unit) {
        try {
            String singular;
            String plural;
            String template = this.getStringConfig(TEMPLATE_KEY, "{value} {unit}");
            String unitKey = PREFIX + unit.name();
            String unitNames = this.translations.getOrDefault(unitKey, unit.name());
            String[] nameVariants = unitNames.split(",", 2);
            if (nameVariants.length == 1) {
                singular = plural = nameVariants[0];
            } else {
                singular = nameVariants[0];
                plural = nameVariants[1];
            }
            String unitName = unit.value() == 1L ? singular : plural;
            return template.replace("{value}", String.valueOf(unit.value())).replace("{unit}", unitName);
        }
        catch (Exception e) {
            return unit.value() + " " + unit.name();
        }
    }

    private String joinUnits(List<String> units, String separator, String finalSeparator) {
        if (units.isEmpty()) {
            return this.getStringConfig("message.neospeedzero.duration.zero", "0");
        }
        if (units.size() == 1) {
            return units.getFirst();
        }
        if (units.size() == 2) {
            return units.get(0) + finalSeparator + units.get(1);
        }
        String joined = String.join((CharSequence)separator, units.subList(0, units.size() - 1));
        return joined + finalSeparator + units.getLast();
    }

    public int getIntConfig(String key, int defaultValue) {
        try {
            return Integer.parseInt(this.translations.getOrDefault(key, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public boolean getBooleanConfig(String key, boolean defaultValue) {
        try {
            return Boolean.parseBoolean(this.translations.getOrDefault(key, String.valueOf(defaultValue)));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private String getStringConfig(String key, String defaultValue) {
        return this.translations.getOrDefault(key, defaultValue);
    }

    private record TimeUnitValue(String name, long value) {
    }
}

