/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.RegistryOps;
import org.jetbrains.annotations.Nullable;

public final class StreamIoUtil {
    private static final Gson GSON = new Gson();
    private static final StreamCodec<ByteBuf, String> INF_UTF8 = StreamCodec.of((buf, s) -> {
        byte[] bytes = s.getBytes(StandardCharsets.UTF_8);
        VarInt.write((ByteBuf)buf, (int)bytes.length);
        buf.writeBytes(bytes);
    }, buf -> {
        int length = VarInt.read((ByteBuf)buf);
        return buf.readBytes(length).toString(StandardCharsets.UTF_8);
    });

    private StreamIoUtil() {
    }

    public static <B extends ByteBuf, K, V> StreamCodec<B, Map<K, V>> ofMap(StreamCodec<? super B, K> keyCodec, StreamCodec<? super B, V> valueCodec) {
        return StreamCodec.of((buf, map) -> {
            VarInt.write((ByteBuf)buf, (int)map.size());
            map.forEach((k, v) -> {
                keyCodec.encode(buf, k);
                valueCodec.encode(buf, v);
            });
        }, buf -> {
            int size = VarInt.read((ByteBuf)buf);
            LinkedHashMap<Object, Object> map = LinkedHashMap.newLinkedHashMap(size);
            for (int i = 0; i < size; ++i) {
                map.put(keyCodec.decode(buf), valueCodec.decode(buf));
            }
            return map;
        });
    }

    public static <O, C extends Collection<O>> StreamCodec<RegistryFriendlyByteBuf, C> ofJsonArrayString(Codec<O> codec, IntFunction<C> collectionFactory) {
        return StreamCodec.of((buf, objs) -> {
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)buf.registryAccess());
            JsonArray arr = new JsonArray();
            for (Object obj : objs) {
                JsonElement json = (JsonElement)codec.encodeStart((DynamicOps)ops, obj).getOrThrow();
                arr.add(json);
            }
            INF_UTF8.encode(buf, (Object)arr.toString());
        }, buf -> {
            JsonArray json = (JsonArray)GSON.fromJson((String)INF_UTF8.decode(buf), JsonArray.class);
            Collection c = (Collection)collectionFactory.apply(json.size());
            RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)buf.registryAccess());
            for (JsonElement e : json) {
                c.add(codec.parse((DynamicOps)ops, (Object)e).getOrThrow());
            }
            return c;
        });
    }

    public static RegistryFriendlyByteBuf byteBuf(byte @Nullable [] buf, RegistryAccess registryAccess) {
        return new RegistryFriendlyByteBuf(buf != null ? Unpooled.wrappedBuffer((byte[])buf) : Unpooled.buffer(), registryAccess);
    }
}

