/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.util.event;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.function.Function;
import xland.mcmod.neospeedzero.util.event.Event;

final class Events<T, I>
implements Event<T, I> {
    private final Function<? super Iterable<? extends T>, ? extends I> merger;
    private final LinkedHashSet<T> registry = new LinkedHashSet();

    Events(Function<? super Iterable<? extends T>, ? extends I> merger) {
        Objects.requireNonNull(merger, "merger cannot be null");
        this.merger = merger;
    }

    @Override
    public I invoker() {
        return this.merger.apply(Collections.unmodifiableCollection(this.registry));
    }

    @Override
    public void register(T listener) {
        this.registry.addLast(listener);
    }

    @Override
    public void unregister(T listener) {
        this.registry.remove(listener);
    }

    @Override
    public void clearListeners() {
        this.registry.clear();
    }

    @Override
    public boolean isRegistered(T listener) {
        return this.registry.contains(listener);
    }
}

