/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.util.event;

import com.mojang.brigadier.CommandDispatcher;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.ApiStatus;
import xland.mcmod.neospeedzero.util.event.neoforge.PlatformEventsImpl;

@ApiStatus.Internal
public abstract class PlatformEvents {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PlatformEvents getInstance() {
        return PlatformEventsImpl.getInstance();
    }

    public abstract void whenServerStarting(Consumer<MinecraftServer> var1);

    public abstract void whenServerStopped(Consumer<MinecraftServer> var1);

    public void preServerPlayerTick(Consumer<ServerPlayer> callback) {
        this.prePlayerTick(player -> {
            if (player instanceof ServerPlayer) {
                callback.accept((ServerPlayer)player);
            }
        });
    }

    protected abstract void prePlayerTick(Consumer<Player> var1);

    public abstract void registerCommand(Consumer<CommandDispatcher<CommandSourceStack>> var1);

    public abstract void registerResourceReloadListener(ResourceLocation var1, Function<HolderLookup.Provider, PreparableReloadListener> var2);

    public abstract <T extends GameRules.Value<T>> GameRules.Key<T> registerGameRule(String var1, GameRules.Category var2, GameRules.Type<T> var3);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void registerKeyMapping(KeyMapping var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void postClientTick(Runnable var1);
}

