/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.util.network;

import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.util.network.ServerToClientPayload;
import xland.mcmod.neospeedzero.util.network.neoforge.PlatformNetworkImpl;

public abstract class PlatformNetwork {
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static PlatformNetwork getInstance() {
        return PlatformNetworkImpl.getInstance();
    }

    public <P extends CustomPacketPayload> void registerC2S(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, P> typeAndCodec, Consumer<ServerPlayer> callback) {
        this.registerC2SImpl(PlatformNetwork.transform(typeAndCodec), callback);
    }

    public <C extends ServerToClientPayload> void registerS2C(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, C> typeAndCodec) {
        this.registerS2CImpl(PlatformNetwork.transform(typeAndCodec));
    }

    protected abstract <P extends CustomPacketPayload> void registerC2SImpl(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, P> var1, Consumer<ServerPlayer> var2);

    protected abstract <C extends ServerToClientPayload> void registerS2CImpl(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, C> var1);

    @OnlyIn(value=Dist.CLIENT)
    public abstract void sendToServer(CustomPacketPayload var1);

    public abstract void sendToPlayer(ServerToClientPayload var1, ServerPlayer var2);

    public abstract void sendToPlayers(ServerToClientPayload var1, Collection<? extends ServerPlayer> var2);

    static <T extends CustomPacketPayload> CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, T> transform(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, T> original) {
        return new CustomPacketPayload.TypeAndCodec(original.type(), new TransformedStreamCodec(original.codec()));
    }

    private record TransformedStreamCodec<T extends CustomPacketPayload>(StreamCodec<RegistryFriendlyByteBuf, T> original) implements StreamCodec<RegistryFriendlyByteBuf, T>
    {
        private static final ThreadLocal<ByteBuf> BUF_CACHE = ThreadLocal.withInitial(Unpooled::buffer);

        private static void packByteArray(ByteBuf dest, ByteBuf src) {
            VarInt.write((ByteBuf)dest, (int)src.readableBytes());
            dest.writeBytes(src);
        }

        private static void unpackByteArray(ByteBuf dest, ByteBuf src) {
            int length = VarInt.read((ByteBuf)src);
            dest.writeBytes(src, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void encode(RegistryFriendlyByteBuf buf, T payload) {
            ByteBuf localBufCache = BUF_CACHE.get();
            try {
                this.original.encode((Object)new RegistryFriendlyByteBuf(localBufCache, buf.registryAccess()), payload);
                TransformedStreamCodec.packByteArray((ByteBuf)buf, localBufCache);
            }
            finally {
                localBufCache.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public T decode(RegistryFriendlyByteBuf buf) {
            ByteBuf localBufCache = BUF_CACHE.get();
            try {
                TransformedStreamCodec.unpackByteArray(localBufCache, (ByteBuf)buf);
                CustomPacketPayload customPacketPayload = (CustomPacketPayload)this.original.decode((Object)new RegistryFriendlyByteBuf(localBufCache, buf.registryAccess()));
                return (T)customPacketPayload;
            }
            finally {
                localBufCache.clear();
            }
        }
    }
}

