/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.util.network.neoforge;

import java.util.Collection;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.network.ClientPacketDistributor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import xland.mcmod.neospeedzero.util.network.PlatformNetwork;
import xland.mcmod.neospeedzero.util.network.ServerToClientPayload;

public final class PlatformNetworkImpl
extends PlatformNetwork {
    private static final PlatformNetworkImpl INSTANCE = new PlatformNetworkImpl();

    private PlatformNetworkImpl() {
    }

    public static PlatformNetwork getInstance() {
        return INSTANCE;
    }

    @Override
    public <P extends CustomPacketPayload> void registerC2SImpl(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, P> typeAndCodec, Consumer<ServerPlayer> callback) {
        Objects.requireNonNull(typeAndCodec, "typeAndCodec cannot be null.");
        Objects.requireNonNull(callback, "callback cannot be null.");
        PlatformNetworkImpl.registerPayloadHandlers(event -> event.registrar(typeAndCodec.type().id().getNamespace()).optional().playToServer(typeAndCodec.type(), typeAndCodec.codec(), (payload, context) -> callback.accept((ServerPlayer)context.player())));
    }

    @Override
    public <C extends ServerToClientPayload> void registerS2CImpl(CustomPacketPayload.TypeAndCodec<RegistryFriendlyByteBuf, C> typeAndCodec) {
        Objects.requireNonNull(typeAndCodec, "typeAndCodec cannot be null.");
        PlatformNetworkImpl.registerPayloadHandlers(event -> {
            PayloadRegistrar registrar = event.registrar(typeAndCodec.type().id().getNamespace()).optional();
            if (FMLEnvironment.getDist() != Dist.CLIENT) {
                registrar.playToClient(typeAndCodec.type(), typeAndCodec.codec());
            } else {
                registrar.playToClient(typeAndCodec.type(), typeAndCodec.codec(), (payload, context) -> payload.onClientReceive());
            }
        });
    }

    private static void registerPayloadHandlers(Consumer<RegisterPayloadHandlersEvent> consumer) {
        ModList.get().getModContainerById("neospeedzero").map(ModContainer::getEventBus).orElseThrow().addListener(RegisterPayloadHandlersEvent.class, consumer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void sendToServer(CustomPacketPayload payload) {
        ClientPacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayer(ServerToClientPayload payload, ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @Override
    public void sendToPlayers(ServerToClientPayload payload, Collection<? extends ServerPlayer> players) {
        ClientboundCustomPayloadPacket packet = new ClientboundCustomPayloadPacket((CustomPacketPayload)payload);
        players.forEach(p -> p.connection.send((Packet)packet));
    }
}

