/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.view;

import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
abstract class AbstractSlottedScreen
extends Screen {
    protected int imageWidth = 176;
    protected int imageHeight = 166;
    protected int leftPos;
    protected int topPos;
    protected final List<@NotNull FakeSlot> slots = Lists.newArrayList();
    protected int hoveredSlotIndex = -1;
    private static final ResourceLocation SLOT_HIGHLIGHT_BACK_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_back");
    private static final ResourceLocation SLOT_HIGHLIGHT_FRONT_SPRITE = ResourceLocation.withDefaultNamespace((String)"container/slot_highlight_front");

    protected AbstractSlottedScreen(Component title) {
        super(title);
    }

    protected void init() {
        this.leftPos = (this.width - this.imageWidth) / 2;
        this.topPos = (this.height - this.imageHeight) / 2;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        int leftPos = this.leftPos;
        int topPos = this.topPos;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)leftPos, (float)topPos);
        guiGraphics.drawString(this.font, this.title, 8, 6, -12566464, false);
        this.findHoveredSlot(mouseX, mouseY);
        this.renderSlotHighlightBack(guiGraphics);
        this.renderSlots(guiGraphics);
        this.renderSlotHighlightFront(guiGraphics);
        guiGraphics.pose().popMatrix();
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.renderBackground(guiGraphics, mouseX, mouseY, partialTick);
        this.renderExtraBackground(guiGraphics, mouseX, mouseY, partialTick);
    }

    protected abstract void renderExtraBackground(GuiGraphics var1, int var2, int var3, float var4);

    protected void renderSlots(GuiGraphics guiGraphics) {
        for (FakeSlot slot : this.slots) {
            slot.render(guiGraphics, this.getFont());
        }
    }

    private void findHoveredSlot(double mouseX, double mouseY) {
        for (int i = 0; i < this.slots.size(); ++i) {
            if (!this.isHovering(this.slots.get(i), mouseX, mouseY)) continue;
            this.hoveredSlotIndex = i;
            return;
        }
        this.hoveredSlotIndex = -1;
    }

    protected boolean isHovering(int x, int y, double mouseX, double mouseY) {
        int i = this.leftPos;
        int j = this.topPos;
        return (mouseX -= (double)i) >= (double)(x - 1) && mouseX < (double)(x + 16 + 1) && (mouseY -= (double)j) >= (double)(y - 1) && mouseY < (double)(y + 16 + 1);
    }

    protected boolean isHovering(FakeSlot fakeSlot, double mouseX, double mouseY) {
        return this.isHovering(fakeSlot.x(), fakeSlot.y(), mouseX, mouseY);
    }

    @Nullable
    private FakeSlot getCachedHoveredSlot() {
        int index = this.hoveredSlotIndex;
        if (index < 0 || index >= this.slots.size()) {
            return null;
        }
        return this.slots.get(index);
    }

    private void renderSlotHighlightBack(GuiGraphics guiGraphics) {
        FakeSlot cachedHoveredSlot = this.getCachedHoveredSlot();
        if (cachedHoveredSlot != null) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_BACK_SPRITE, cachedHoveredSlot.x() - 4, cachedHoveredSlot.y() - 4, 24, 24);
        }
    }

    private void renderSlotHighlightFront(GuiGraphics guiGraphics) {
        FakeSlot cachedHoveredSlot = this.getCachedHoveredSlot();
        if (cachedHoveredSlot != null) {
            guiGraphics.blitSprite(RenderPipelines.GUI_TEXTURED, SLOT_HIGHLIGHT_FRONT_SPRITE, cachedHoveredSlot.x() - 4, cachedHoveredSlot.y() - 4, 24, 24);
        }
    }

    protected void renderTooltip(GuiGraphics guiGraphics, int x, int y) {
        FakeSlot cachedHoveredSlot = this.getCachedHoveredSlot();
        if (cachedHoveredSlot != null) {
            ItemStack itemStack = cachedHoveredSlot.getItemStack();
            if (itemStack.isEmpty()) {
                return;
            }
            assert (this.minecraft != null);
            guiGraphics.setTooltipForNextFrame(this.font, AbstractSlottedScreen.getTooltipFromItem((Minecraft)this.minecraft, (ItemStack)itemStack), itemStack.getTooltipImage(), x, y, (ResourceLocation)itemStack.get(DataComponents.TOOLTIP_STYLE));
        }
    }

    protected static class FakeSlot {
        private final int x;
        private final int y;
        @NotNull
        private ItemStack itemStack;

        public FakeSlot(int x, int y, @Nullable ItemStack itemStack) {
            this.x = x;
            this.y = y;
            this.itemStack = FakeSlot.orEmpty(itemStack);
        }

        @NotNull
        private static ItemStack orEmpty(@Nullable ItemStack stack) {
            return Objects.requireNonNullElse(stack, ItemStack.EMPTY);
        }

        public FakeSlot(int x, int y) {
            this(x, y, ItemStack.EMPTY);
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        @NotNull
        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public void setItemStack(@Nullable ItemStack itemStack) {
            this.itemStack = FakeSlot.orEmpty(itemStack);
        }

        public void render(GuiGraphics guiGraphics, Font font) {
            guiGraphics.renderItem(this.getItemStack(), this.x(), this.y());
            guiGraphics.renderItemDecorations(font, this.getItemStack(), this.x(), this.y());
        }
    }
}

