/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.record.SpeedrunChallenge;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.util.network.PlatformNetwork;
import xland.mcmod.neospeedzero.util.network.ServerToClientPayload;
import xland.mcmod.neospeedzero.view.ViewChallengeScreen;
import xland.mcmod.neospeedzero.view.ViewPackets;

public record ChallengeSnapshot(UUID recordId, Component title, List<ItemStack> challenges, long[] successTimeMap) implements ServerToClientPayload
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ChallengeSnapshot> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, ChallengeSnapshot::recordId, (StreamCodec)ComponentSerialization.STREAM_CODEC, ChallengeSnapshot::title, (StreamCodec)ByteBufCodecs.list().apply(ItemStack.STREAM_CODEC), ChallengeSnapshot::challenges, (StreamCodec)ByteBufCodecs.LONG_ARRAY, ChallengeSnapshot::successTimeMap, ChallengeSnapshot::new);

    public static ChallengeSnapshot fromRecord(@NotNull SpeedrunRecord record) {
        return new ChallengeSnapshot(record.recordId(), (Component)record.goal().goal().display().copy(), record.challenges().stream().map(SpeedrunChallenge::icon).toList(), (long[])record.collectedTimes().clone());
    }

    public void sendToClient(ServerPlayer serverPlayer) {
        PlatformNetwork.getInstance().sendToPlayer(this, serverPlayer);
    }

    @NotNull
    public CustomPacketPayload.Type<ChallengeSnapshot> type() {
        return ViewPackets.TYPE_SNAPSHOT;
    }

    int totalPageCount() {
        return Math.ceilDivExact(this.challenges().size(), 63);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onClientReceive() {
        class Receiver
        implements Runnable {
            Receiver() {
            }

            @Override
            public void run() {
                Minecraft.getInstance().setScreen((Screen)new ViewChallengeScreen(ChallengeSnapshot.this));
            }
        }
        new Receiver().run();
    }

    public Component toText() {
        MutableComponent root = Component.empty();
        root.append((Component)Component.translatable((String)"command.neospeedzero.view_raw.title", (Object[])new Object[]{this.title()}).withStyle(s -> s.withHoverEvent((HoverEvent)new HoverEvent.ShowText((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.id", (Object[])new Object[]{String.valueOf(this.recordId())}))))).append("\n");
        ArrayList<ItemStack> yes = new ArrayList<ItemStack>();
        ArrayList no = new ArrayList();
        int i = 0;
        long[] timeMap = this.successTimeMap();
        for (ItemStack challenge : this.challenges()) {
            ArrayList<ItemStack> target = timeMap[i++] >= 0L ? yes : no;
            target.add(challenge);
        }
        root.append((Component)Component.translatable((String)"command.neospeedzero.view_raw.complete.yes", (Object[])new Object[]{yes.size()}).withStyle(ChatFormatting.GREEN)).append("\n");
        root.append(ChallengeSnapshot.join(yes.iterator()));
        root.append("\n");
        root.append((Component)Component.translatable((String)"command.neospeedzero.view_raw.complete.no", (Object[])new Object[]{no.size()}).withStyle(ChatFormatting.RED)).append("\n");
        root.append(ChallengeSnapshot.join(no.iterator()));
        root.append("\n\n").append((Component)Component.translatable((String)"message.neospeedzero.record.snapshot.non-synced"));
        return root;
    }

    private static Component join(Iterator<ItemStack> stacks) {
        MutableComponent component = Component.empty();
        while (stacks.hasNext()) {
            ItemStack next = stacks.next();
            component.append(next.getDisplayName());
            if (!stacks.hasNext()) continue;
            component.append(", ");
        }
        return component;
    }

    public record Change(UUID recordId, int index, long newValue) implements ServerToClientPayload
    {
        public static final StreamCodec<RegistryFriendlyByteBuf, Change> STREAM_CODEC = StreamCodec.composite((StreamCodec)UUIDUtil.STREAM_CODEC, Change::recordId, (StreamCodec)ByteBufCodecs.VAR_INT, Change::index, (StreamCodec)ByteBufCodecs.LONG, Change::newValue, Change::new);

        public boolean applyTo(ChallengeSnapshot snapshot) {
            if (!Objects.equals(this.recordId(), snapshot.recordId())) {
                return false;
            }
            int index = this.index();
            if (index >= 0 && index < snapshot.successTimeMap().length) {
                snapshot.successTimeMap()[index] = this.newValue();
            }
            return true;
        }

        public void broadcastToAll(PlayerList playerList) {
            PlatformNetwork.getInstance().sendToPlayers(this, playerList.getPlayers());
        }

        @NotNull
        public CustomPacketPayload.Type<Change> type() {
            return ViewPackets.TYPE_CHANGE;
        }

        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void onClientReceive() {
            Screen screen = Minecraft.getInstance().screen;
            if (screen instanceof ViewChallengeScreen) {
                ViewChallengeScreen viewChallengeScreen = (ViewChallengeScreen)screen;
                viewChallengeScreen.onDataUpdate(this);
            }
        }
    }
}

