/*
 * Decompiled with CFR 0.152.
 */
package xland.mcmod.neospeedzero.view;

import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import xland.mcmod.neospeedzero.NeoSpeedLifecycle;
import xland.mcmod.neospeedzero.record.SpeedrunRecord;
import xland.mcmod.neospeedzero.util.ABSDebug;
import xland.mcmod.neospeedzero.util.network.PlatformNetwork;
import xland.mcmod.neospeedzero.view.ChallengeSnapshot;

public interface ViewPackets {
    public static final ResourceLocation ID_SNAPSHOT = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"view_challenge");
    public static final CustomPacketPayload.Type<ChallengeSnapshot> TYPE_SNAPSHOT = new CustomPacketPayload.Type(ID_SNAPSHOT);
    public static final ResourceLocation ID_CHANGE = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"sync_challenge");
    public static final CustomPacketPayload.Type<ChallengeSnapshot.Change> TYPE_CHANGE = new CustomPacketPayload.Type(ID_CHANGE);
    public static final ResourceLocation ID_C2S_REQUEST = ResourceLocation.fromNamespaceAndPath((String)"neospeedzero", (String)"request_view_challenge");
    public static final CustomPacketPayload.Type<Request> TYPE_C2S_REQUEST = new CustomPacketPayload.Type(ID_C2S_REQUEST);

    public static void register() {
        ABSDebug.debug(4, l -> l.info("ViewPackets registering (1/2)"));
        PlatformNetwork.getInstance().registerS2C(new CustomPacketPayload.TypeAndCodec(TYPE_SNAPSHOT, ChallengeSnapshot.STREAM_CODEC));
        PlatformNetwork.getInstance().registerS2C(new CustomPacketPayload.TypeAndCodec(TYPE_CHANGE, ChallengeSnapshot.Change.STREAM_CODEC));
        ABSDebug.debug(4, l -> l.info("ViewPackets registered (2/2)"));
        PlatformNetwork.getInstance().registerC2S(new CustomPacketPayload.TypeAndCodec(TYPE_C2S_REQUEST, Request.STREAM_CODEC), serverPlayer -> {
            SpeedrunRecord record = serverPlayer.ns0$currentRecord();
            if (record != null) {
                NeoSpeedLifecycle.viewRecord(serverPlayer, record);
            } else {
                serverPlayer.sendSystemMessage((Component)Component.translatable((String)"message.neospeedzero.record.stop.absent", (Object[])new Object[]{serverPlayer.getDisplayName()}));
            }
        });
    }

    public static class Request
    implements CustomPacketPayload {
        public static final Request INSTANCE = new Request();
        public static final StreamCodec<RegistryFriendlyByteBuf, Request> STREAM_CODEC = StreamCodec.unit((Object)INSTANCE);

        private Request() {
        }

        @NotNull
        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return TYPE_C2S_REQUEST;
        }

        public String toString() {
            return "ViewPackets.Request";
        }

        public int hashCode() {
            return System.identityHashCode(INSTANCE);
        }

        public boolean equals(Object obj) {
            return obj instanceof Request;
        }
    }
}

