/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.ChatManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChatCommands
implements CommandExecutor {
    private final ChatManager chatManager;
    private final HashMap<UUID, Set<ChatManager.ChatChannel>> mutedChannels;

    public ChatCommands(ChatManager chatManager) {
        this.chatManager = chatManager;
        this.mutedChannels = new HashMap();
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args2) {
        ChatManager.ChatChannel channel;
        String cmdName;
        if (!(sender instanceof Player)) {
            sender.sendMessage("This command can only be used by players!");
            return true;
        }
        Player player = (Player)sender;
        switch (cmdName = command.getName().toLowerCase()) {
            case "localchat": {
                ChatManager.ChatChannel chatChannel = ChatManager.ChatChannel.LOCAL;
                break;
            }
            case "globalchat": {
                ChatManager.ChatChannel chatChannel = ChatManager.ChatChannel.GLOBAL;
                break;
            }
            case "staffchat": {
                ChatManager.ChatChannel chatChannel = ChatManager.ChatChannel.STAFF;
                break;
            }
            case "adminchat": {
                ChatManager.ChatChannel chatChannel = ChatManager.ChatChannel.ADMIN;
                break;
            }
            case "globaltoggle": 
            case "gt": {
                ChatManager.ChatChannel chatChannel = this.handleToggle(player, ChatManager.ChatChannel.GLOBAL);
                break;
            }
            case "localtoggle": 
            case "lt": {
                ChatManager.ChatChannel chatChannel = this.handleToggle(player, ChatManager.ChatChannel.LOCAL);
                break;
            }
            case "staffchattoggle": 
            case "st": {
                ChatManager.ChatChannel chatChannel = this.handleToggle(player, ChatManager.ChatChannel.STAFF);
                break;
            }
            case "adminchattoggle": 
            case "at": {
                ChatManager.ChatChannel chatChannel = this.handleToggle(player, ChatManager.ChatChannel.ADMIN);
                break;
            }
            default: {
                ChatManager.ChatChannel chatChannel = channel = null;
            }
        }
        if (cmdName.endsWith("toggle") || cmdName.equals("gt") || cmdName.equals("lt") || cmdName.equals("st") || cmdName.equals("at")) {
            return true;
        }
        if (channel == null) {
            return false;
        }
        if (args2.length > 0) {
            String message = String.join((CharSequence)" ", args2);
            this.chatManager.handleChat(player, message, channel);
        } else {
            this.chatManager.setPlayerChannel(player, channel);
        }
        return true;
    }

    private ChatManager.ChatChannel handleToggle(Player player, ChatManager.ChatChannel channel) {
        UUID playerId = player.getUniqueId();
        Set playerMuted = this.mutedChannels.computeIfAbsent(playerId, k -> new HashSet());
        if (playerMuted.contains((Object)channel)) {
            playerMuted.remove((Object)channel);
            player.sendMessage(MiniMessage.miniMessage().deserialize("<green>Unmuted " + channel.toString().toLowerCase() + " chat.</green>"));
        } else {
            playerMuted.add(channel);
            player.sendMessage(MiniMessage.miniMessage().deserialize("<red>Muted " + channel.toString().toLowerCase() + " chat.</red>"));
        }
        return null;
    }
}

