/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.AdminChatHandler;
import com.deftchat.DeftChat;
import com.deftchat.DiscordManager;
import com.deftchat.GlobalChatHandler;
import com.deftchat.LocalChatHandler;
import com.deftchat.RedisManager;
import com.deftchat.StaffChatHandler;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.HashMap;
import java.util.UUID;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatManager
implements Listener {
    private final DeftChat plugin;
    private final HashMap<UUID, ChatChannel> playerChannels;
    private final RedisManager redisManager;
    private final MiniMessage miniMessage;
    private final HashMap<UUID, Hologram> activeHolograms;
    private DiscordManager discordManager;
    private final LocalChatHandler localChatHandler;
    private final GlobalChatHandler globalChatHandler;
    private final StaffChatHandler staffChatHandler;
    private final AdminChatHandler adminChatHandler;

    public ChatManager(DeftChat plugin) {
        this.plugin = plugin;
        this.playerChannels = new HashMap();
        this.miniMessage = MiniMessage.miniMessage();
        this.redisManager = new RedisManager(plugin);
        this.activeHolograms = new HashMap();
        this.localChatHandler = new LocalChatHandler(plugin, this.miniMessage, this.activeHolograms);
        this.globalChatHandler = new GlobalChatHandler(plugin, this.miniMessage, this.redisManager);
        this.staffChatHandler = new StaffChatHandler(plugin, this.miniMessage, this.redisManager);
        this.adminChatHandler = new AdminChatHandler(plugin, this.miniMessage, this.redisManager);
    }

    public void setDiscordManager(DiscordManager discordManager) {
        this.discordManager = discordManager;
        this.localChatHandler.setDiscordManager(discordManager);
        this.globalChatHandler.setDiscordManager(discordManager);
        this.staffChatHandler.setDiscordManager(discordManager);
        this.adminChatHandler.setDiscordManager(discordManager);
    }

    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        String message = event.getMessage();
        ChatChannel channel = this.playerChannels.getOrDefault(player.getUniqueId(), ChatChannel.GLOBAL);
        event.setCancelled(true);
        this.handleChat(player, message, channel);
    }

    public void handleChat(Player sender, String message, ChatChannel channel) {
        switch (channel.ordinal()) {
            case 0: {
                this.localChatHandler.handle(sender, message);
                break;
            }
            case 1: {
                this.globalChatHandler.handle(sender, message);
                break;
            }
            case 2: {
                this.staffChatHandler.handle(sender, message);
                break;
            }
            case 3: {
                this.adminChatHandler.handle(sender, message);
            }
        }
    }

    public boolean isPlaceholderAPIAvailable() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public void setPlayerChannel(Player player, ChatChannel channel) {
        this.playerChannels.put(player.getUniqueId(), channel);
        Object message = switch (channel.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 1 -> this.miniMessage.deserialize("<green>You have entered global chat.</green>");
            case 0 -> this.miniMessage.deserialize("<yellow>You have entered local chat.</yellow>");
            case 2 -> this.miniMessage.deserialize("<red>You have entered staff chat.</red>");
            case 3 -> this.miniMessage.deserialize("<dark_red>You have entered admin chat.</dark_red>");
        };
        player.sendMessage(message);
    }

    public ChatChannel getPlayerChannel(Player player) {
        return this.playerChannels.getOrDefault(player.getUniqueId(), ChatChannel.valueOf(this.plugin.getConfig().getString("chat.default-channel", "GLOBAL")));
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    public void broadcastCrossServerMessage(String playerName, String message, String channelType) {
        try {
            ChatChannel channel = ChatChannel.valueOf(channelType);
            Object formattedMessage = this.miniMessage.deserialize(this.plugin.getConfig().getString("format.channels." + channel.toString().toLowerCase() + ".prefix", "[" + channelType + "]") + " <gray>" + playerName + "</gray>: <white>" + message + "</white>");
            switch (channel.ordinal()) {
                case 1: {
                    this.plugin.getServer().broadcast(formattedMessage);
                    break;
                }
                case 2: {
                    this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("deftchat.staff")).forEach(p -> p.sendMessage(formattedMessage));
                    break;
                }
                case 3: {
                    this.plugin.getServer().getOnlinePlayers().stream().filter(p -> p.hasPermission("deftchat.admin")).forEach(p -> p.sendMessage(formattedMessage));
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("Received invalid channel type from cross-server chat: " + channelType);
        }
    }

    public static enum ChatChannel {
        LOCAL,
        GLOBAL,
        STAFF,
        ADMIN;

    }
}

