/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.ChatCommands;
import com.deftchat.ChatManager;
import com.deftchat.ChatTabCompleter;
import com.deftchat.DiscordManager;
import com.deftchat.PlayerJoinLeaveListener;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class DeftChat
extends JavaPlugin
implements Listener {
    private static DeftChat instance;
    private FileConfiguration config;
    private ChatManager chatManager;
    private DiscordManager discordManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.config = this.getConfig();
        this.chatManager = new ChatManager(this);
        this.discordManager = new DiscordManager(this, this.config, this.chatManager);
        this.chatManager.setDiscordManager(this.discordManager);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.chatManager, (Plugin)this);
        if (this.discordManager != null && this.discordManager.isEnabled()) {
            this.getServer().getPluginManager().registerEvents((Listener)new PlayerJoinLeaveListener(this.discordManager), (Plugin)this);
        }
        this.registerCommands();
        this.getLogger().info("DeftChat has been enabled!");
    }

    public void onDisable() {
        if (this.chatManager != null) {
            this.chatManager.getRedisManager().shutdown();
        }
        if (this.discordManager != null) {
            this.discordManager.shutdown();
        }
        this.getLogger().info("DeftChat has been disabled!");
    }

    private void registerCommands() {
        ChatCommands chatCommandExecutor = new ChatCommands(this.chatManager);
        ChatTabCompleter tabCompleter = new ChatTabCompleter();
        this.getCommand("localchat").setExecutor((CommandExecutor)chatCommandExecutor);
        this.getCommand("globalchat").setExecutor((CommandExecutor)chatCommandExecutor);
        this.getCommand("staffchat").setExecutor((CommandExecutor)chatCommandExecutor);
        this.getCommand("adminchat").setExecutor((CommandExecutor)chatCommandExecutor);
        this.getCommand("localchat").setTabCompleter((TabCompleter)tabCompleter);
        this.getCommand("globalchat").setTabCompleter((TabCompleter)tabCompleter);
        this.getCommand("staffchat").setTabCompleter((TabCompleter)tabCompleter);
        this.getCommand("adminchat").setTabCompleter((TabCompleter)tabCompleter);
    }

    public static DeftChat getInstance() {
        return instance;
    }

    public DiscordManager getDiscordManager() {
        return this.discordManager;
    }

    public ChatManager getChatManager() {
        return this.chatManager;
    }
}

