/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.ChatManager;
import java.awt.Color;
import java.time.Instant;
import java.util.EnumSet;
import net.dv8tion.jda.api.EmbedBuilder;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.JDABuilder;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.channel.concrete.TextChannel;
import net.dv8tion.jda.api.events.message.MessageReceivedEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import net.dv8tion.jda.api.requests.GatewayIntent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DiscordManager
extends ListenerAdapter {
    private final JavaPlugin plugin;
    private final FileConfiguration config;
    private final ChatManager chatManager;
    private JDA jda;
    private TextChannel syncChannel;
    private boolean enabled;
    private String minecraftToDiscordFormat;
    private String discordToMinecraftFormat;
    private boolean sendJoinLeaveMessages;
    private String joinMessageFormat;
    private String leaveMessageFormat;

    public DiscordManager(JavaPlugin plugin, FileConfiguration config, ChatManager chatManager) {
        this.plugin = plugin;
        this.config = config;
        this.chatManager = chatManager;
        this.loadConfig();
    }

    public void loadConfig() {
        block7: {
            this.enabled = this.config.getBoolean("discord.enabled", false);
            String botToken = this.config.getString("discord.bot-token", "YOUR_BOT_TOKEN_HERE");
            String channelId = this.config.getString("discord.channel-id", "YOUR_CHANNEL_ID_HERE");
            this.minecraftToDiscordFormat = this.config.getString("discord.minecraft-to-discord-format", "**[{channel}] {player}:** {message}");
            this.discordToMinecraftFormat = this.config.getString("discord.discord-to-minecraft-format", "<aqua>[Discord]</aqua> <gray>{user}:</gray> <white>{message}");
            this.sendJoinLeaveMessages = this.config.getBoolean("discord.send-join-leave-messages", false);
            this.joinMessageFormat = this.config.getString("discord.join-message-format", "\u2705 **{player}** joined the server.");
            this.leaveMessageFormat = this.config.getString("discord.leave-message-format", "\u274c **{player}** left the server.");
            if (this.enabled) {
                if (botToken == null || botToken.isEmpty() || botToken.equals("YOUR_BOT_TOKEN_HERE")) {
                    this.plugin.getLogger().warning("Discord bot token is not set in config.yml. Disabling Discord integration.");
                    this.enabled = false;
                    return;
                }
                if (channelId == null || channelId.isEmpty() || channelId.equals("YOUR_CHANNEL_ID_HERE")) {
                    this.plugin.getLogger().warning("Discord channel ID is not set in config.yml. Disabling Discord integration.");
                    this.enabled = false;
                    return;
                }
                try {
                    this.jda = JDABuilder.createLight(botToken, EnumSet.of(GatewayIntent.GUILD_MESSAGES, GatewayIntent.MESSAGE_CONTENT)).addEventListeners(this).build().awaitReady();
                    this.syncChannel = this.jda.getTextChannelById(channelId);
                    if (this.syncChannel == null) {
                        this.plugin.getLogger().severe("Could not find Discord channel with ID: " + channelId + ". Disabling Discord integration.");
                        this.enabled = false;
                        this.jda.shutdownNow();
                        this.jda = null;
                        break block7;
                    }
                    this.plugin.getLogger().info("Successfully connected to Discord and found sync channel: " + this.syncChannel.getName());
                }
                catch (Exception e) {
                    this.plugin.getLogger().severe("Failed to initialize Discord bot: " + e.getMessage());
                    e.printStackTrace();
                    this.enabled = false;
                    if (this.jda != null) {
                        this.jda.shutdownNow();
                        this.jda = null;
                    }
                    break block7;
                }
            }
            this.plugin.getLogger().info("Discord integration is disabled in config.yml.");
        }
    }

    public void shutdown() {
        if (this.jda != null) {
            this.jda.shutdown();
            this.plugin.getLogger().info("Discord bot shut down.");
        }
    }

    public void sendMessageToDiscord(String channelName, String playerName, String message) {
        if (!this.enabled || this.syncChannel == null) {
            return;
        }
        String sanitizedPlayerName = playerName.replace("`", "'").replace("*", "").replace("_", "").replace("~", "");
        String sanitizedMessage = message.replace("`", "'").replace("*", "").replace("_", "").replace("~", "");
        EmbedBuilder embed = new EmbedBuilder();
        embed.setAuthor(sanitizedPlayerName, null, "https://crafatar.com/avatars/" + String.valueOf(Bukkit.getOfflinePlayer((String)playerName).getUniqueId()) + "?overlay");
        embed.setDescription(sanitizedMessage);
        embed.setColor(Color.CYAN);
        embed.setFooter("Channel: " + channelName);
        embed.setTimestamp(Instant.now());
        this.syncChannel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    public void sendJoinNotification(String playerName) {
        if (!this.enabled || this.syncChannel == null || !this.sendJoinLeaveMessages) {
            return;
        }
        String formattedMessage = this.joinMessageFormat.replace("{player}", playerName.replace("`", "'").replace("*", "").replace("_", "").replace("~", ""));
        EmbedBuilder embed = new EmbedBuilder();
        embed.setDescription(formattedMessage);
        embed.setColor(Color.GREEN);
        embed.setTimestamp(Instant.now());
        this.syncChannel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    public void sendLeaveNotification(String playerName) {
        if (!this.enabled || this.syncChannel == null || !this.sendJoinLeaveMessages) {
            return;
        }
        String formattedMessage = this.leaveMessageFormat.replace("{player}", playerName.replace("`", "'").replace("*", "").replace("_", "").replace("~", ""));
        EmbedBuilder embed = new EmbedBuilder();
        embed.setDescription(formattedMessage);
        embed.setColor(Color.RED);
        embed.setTimestamp(Instant.now());
        this.syncChannel.sendMessageEmbeds(embed.build(), new MessageEmbed[0]).queue();
    }

    @Override
    public void onMessageReceived(MessageReceivedEvent event) {
        if (!this.enabled || event.getAuthor().isBot() || event.getChannel().getIdLong() != this.syncChannel.getIdLong()) {
            return;
        }
        String userName = event.getAuthor().getName();
        String messageContent = event.getMessage().getContentDisplay();
        if (messageContent.startsWith("/")) {
            return;
        }
        String formattedMessage = this.discordToMinecraftFormat.replace("{user}", userName).replace("{message}", messageContent);
        Object component = MiniMessage.miniMessage().deserialize(formattedMessage);
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Bukkit.getServer().broadcast(component));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

