/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.ChatManager;
import com.deftchat.DeftChat;
import com.deftchat.DiscordManager;
import com.deftchat.RedisManager;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;

public class GlobalChatHandler {
    private final DeftChat plugin;
    private final MiniMessage miniMessage;
    private final RedisManager redisManager;
    private DiscordManager discordManager;

    public GlobalChatHandler(DeftChat plugin, MiniMessage miniMessage, RedisManager redisManager) {
        this.plugin = plugin;
        this.miniMessage = miniMessage;
        this.redisManager = redisManager;
    }

    public void setDiscordManager(DiscordManager discordManager) {
        this.discordManager = discordManager;
    }

    public void handle(Player sender, String message) {
        if (!sender.hasPermission("deftchat.chat.global")) {
            sender.sendMessage(Component.text("You don't have permission to use global chat!").color(NamedTextColor.RED));
            return;
        }
        Component formattedMessage = this.formatMessage(sender, message);
        this.plugin.getServer().broadcast(formattedMessage);
        if (this.redisManager.isEnabled()) {
            this.redisManager.publishMessage(sender.getName(), message, ChatManager.ChatChannel.GLOBAL.toString());
        }
        if (this.discordManager != null && this.discordManager.isEnabled()) {
            String plainMessage = MiniMessage.miniMessage().stripTags(this.processMessageContent(sender, message));
            this.discordManager.sendMessageToDiscord("Global", sender.getName(), plainMessage);
        }
    }

    private Component formatMessage(Player player, String message) {
        String prefix = this.plugin.getConfig().getString("format.channels.global.prefix", "<gray>[G]</gray>");
        String playerName = player.getName();
        prefix = this.parsePlaceholders(player, prefix);
        playerName = this.parsePlaceholders(player, playerName);
        Object prefixComponent = this.miniMessage.deserialize(prefix);
        TextComponent playerComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(playerName);
        String processedMessageString = this.processMessageContent(player, message);
        Object messageComponent = this.miniMessage.deserialize(processedMessageString);
        return prefixComponent.append(Component.text(" ")).append(playerComponent).append(Component.text(": ")).append((Component)messageComponent);
    }

    private String processMessageContent(Player player, String message) {
        String tempMessage = message;
        tempMessage = this.parsePlaceholders(player, tempMessage);
        if (player.hasPermission("deftchat.color")) {
            return (String)MiniMessage.miniMessage().serialize(LegacyComponentSerializer.legacyAmpersand().deserialize(tempMessage));
        }
        tempMessage = ChatColor.stripColor((String)LegacyComponentSerializer.legacySection().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(tempMessage)));
        return MiniMessage.miniMessage().stripTags(tempMessage);
    }

    private String parsePlaceholders(Player player, String text) {
        if (this.plugin.getChatManager().isPlaceholderAPIAvailable()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

