/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.DeftChat;
import com.deftchat.DiscordManager;
import eu.decentsoftware.holograms.api.DHAPI;
import eu.decentsoftware.holograms.api.holograms.Hologram;
import java.util.Arrays;
import java.util.HashMap;
import java.util.UUID;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class LocalChatHandler {
    private final DeftChat plugin;
    private final MiniMessage miniMessage;
    private final HashMap<UUID, Hologram> activeHolograms;
    private DiscordManager discordManager;

    public LocalChatHandler(DeftChat plugin, MiniMessage miniMessage, HashMap<UUID, Hologram> activeHolograms) {
        this.plugin = plugin;
        this.miniMessage = miniMessage;
        this.activeHolograms = activeHolograms;
    }

    public void setDiscordManager(DiscordManager discordManager) {
        this.discordManager = discordManager;
    }

    public void handle(Player sender, String message) {
        if (!sender.hasPermission("deftchat.chat.local")) {
            sender.sendMessage(Component.text("You don't have permission to use local chat!").color(NamedTextColor.RED));
            return;
        }
        Component formattedMessage = this.formatMessage(sender, message);
        double range = this.plugin.getConfig().getDouble("chat.local-range", 120.0);
        sender.getWorld().getPlayers().stream().filter(p -> p.getLocation().distance(sender.getLocation()) <= range).forEach(p -> p.sendMessage(formattedMessage));
        if (sender.hasPermission("deftchat.chatbubbles")) {
            this.showChatBubble(sender, message);
        }
    }

    private Component formatMessage(Player player, String message) {
        String prefix = this.plugin.getConfig().getString("format.channels.local.prefix", "<yellow>[L]</yellow>");
        String playerName = player.getName();
        prefix = this.parsePlaceholders(player, prefix);
        playerName = this.parsePlaceholders(player, playerName);
        Object prefixComponent = this.miniMessage.deserialize(prefix);
        TextComponent playerComponent = LegacyComponentSerializer.legacyAmpersand().deserialize(playerName);
        String processedMessageString = this.processMessageContent(player, message);
        Object messageComponent = this.miniMessage.deserialize(processedMessageString);
        return prefixComponent.append(Component.text(" ")).append(playerComponent).append(Component.text(": ")).append((Component)messageComponent);
    }

    private String processMessageContent(Player player, String message) {
        String tempMessage = message;
        tempMessage = this.parsePlaceholders(player, tempMessage);
        if (player.hasPermission("deftchat.color")) {
            return (String)MiniMessage.miniMessage().serialize(LegacyComponentSerializer.legacyAmpersand().deserialize(tempMessage));
        }
        tempMessage = ChatColor.stripColor((String)LegacyComponentSerializer.legacySection().serialize((Component)LegacyComponentSerializer.legacyAmpersand().deserialize(tempMessage)));
        return MiniMessage.miniMessage().stripTags(tempMessage);
    }

    private String parsePlaceholders(Player player, String text) {
        if (this.plugin.getChatManager().isPlaceholderAPIAvailable()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }

    private void showChatBubble(final Player player, String message) {
        Hologram existingHologram = this.activeHolograms.remove(player.getUniqueId());
        if (existingHologram != null) {
            DHAPI.removeHologram((String)existingHologram.getName());
        }
        Location loc = player.getLocation().add(0.0, 3.0, 0.0);
        String holoName = "chat_" + player.getUniqueId().toString().substring(0, 8);
        Hologram hologram = DHAPI.createHologram((String)holoName, (Location)loc, (boolean)false, Arrays.asList(message));
        this.activeHolograms.put(player.getUniqueId(), hologram);
        new BukkitRunnable(){
            int ticks = 0;

            public void run() {
                Hologram holo = LocalChatHandler.this.activeHolograms.get(player.getUniqueId());
                if (holo != null) {
                    if (this.ticks >= 40) {
                        LocalChatHandler.this.activeHolograms.remove(player.getUniqueId());
                        DHAPI.removeHologram((String)holo.getName());
                        this.cancel();
                    } else {
                        DHAPI.moveHologram((String)holo.getName(), (Location)player.getLocation().add(0.0, 3.0, 0.0));
                        ++this.ticks;
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }
}

