/*
 * Decompiled with CFR 0.152.
 */
package com.deftchat;

import com.deftchat.DeftChat;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPubSub;

public class RedisManager {
    private final DeftChat plugin;
    private Jedis publishJedis;
    private Jedis subscribeJedis;
    private final String channel;
    private boolean enabled;

    public RedisManager(DeftChat plugin) {
        this.plugin = plugin;
        FileConfiguration config = plugin.getConfig();
        this.enabled = config.getBoolean("redis.enabled", false);
        this.channel = config.getString("redis.channel", "deftchat");
        if (this.enabled) {
            String host = config.getString("redis.host", "localhost");
            int port = config.getInt("redis.port", 6379);
            String password = config.getString("redis.password", "");
            try {
                this.publishJedis = new Jedis(host, port);
                this.subscribeJedis = new Jedis(host, port);
                if (!password.isEmpty()) {
                    this.publishJedis.auth(password);
                    this.subscribeJedis.auth(password);
                }
                this.startSubscriber();
                plugin.getLogger().info("Redis connection established successfully!");
            }
            catch (Exception e) {
                plugin.getLogger().severe("Failed to connect to Redis: " + e.getMessage());
                this.enabled = false;
            }
        }
    }

    private void startSubscriber() {
        Thread subscriberThread = new Thread(() -> {
            try {
                this.subscribeJedis.subscribe(new JedisPubSub(){

                    @Override
                    public void onMessage(String channel, String message) {
                        try {
                            JSONParser parser = new JSONParser();
                            JSONObject json = (JSONObject)parser.parse(message);
                            String playerName = (String)json.get((Object)"player");
                            String chatMessage = (String)json.get((Object)"message");
                            String channelType = (String)json.get((Object)"channel");
                            RedisManager.this.plugin.getServer().getScheduler().runTask((Plugin)RedisManager.this.plugin, () -> RedisManager.this.plugin.getChatManager().broadcastCrossServerMessage(playerName, chatMessage, channelType));
                        }
                        catch (ParseException e) {
                            RedisManager.this.plugin.getLogger().warning("Failed to parse cross-server message: " + e.getMessage());
                        }
                    }
                }, this.channel);
            }
            catch (Exception e) {
                this.plugin.getLogger().severe("Redis subscriber disconnected: " + e.getMessage());
            }
        });
        subscriberThread.setDaemon(true);
        subscriberThread.start();
    }

    public void publishMessage(String playerName, String message, String channel) {
        if (!this.enabled) {
            return;
        }
        try {
            JSONObject json = new JSONObject();
            json.put((Object)"player", (Object)playerName);
            json.put((Object)"message", (Object)message);
            json.put((Object)"channel", (Object)channel);
            this.publishJedis.publish(this.channel, json.toJSONString());
        }
        catch (Exception e) {
            this.plugin.getLogger().warning("Failed to publish message to Redis: " + e.getMessage());
        }
    }

    public void shutdown() {
        if (this.enabled) {
            if (this.publishJedis != null) {
                this.publishJedis.close();
            }
            if (this.subscribeJedis != null) {
                this.subscribeJedis.close();
            }
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

