/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.commands.ProtocolCommand;
import redis.clients.jedis.exceptions.JedisAccessControlException;
import redis.clients.jedis.exceptions.JedisAskDataException;
import redis.clients.jedis.exceptions.JedisBusyException;
import redis.clients.jedis.exceptions.JedisClusterException;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisDataException;
import redis.clients.jedis.exceptions.JedisMovedDataException;
import redis.clients.jedis.exceptions.JedisNoScriptException;
import redis.clients.jedis.util.KeyValue;
import redis.clients.jedis.util.RedisInputStream;
import redis.clients.jedis.util.RedisOutputStream;
import redis.clients.jedis.util.SafeEncoder;

public final class Protocol {
    public static final String DEFAULT_HOST = "127.0.0.1";
    public static final int DEFAULT_PORT = 6379;
    public static final int DEFAULT_SENTINEL_PORT = 26379;
    public static final int DEFAULT_TIMEOUT = 2000;
    public static final int DEFAULT_DATABASE = 0;
    public static final int CLUSTER_HASHSLOTS = 16384;
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final byte ASTERISK_BYTE = 42;
    public static final byte COLON_BYTE = 58;
    public static final byte COMMA_BYTE = 44;
    public static final byte DOLLAR_BYTE = 36;
    public static final byte EQUAL_BYTE = 61;
    public static final byte GREATER_THAN_BYTE = 62;
    public static final byte HASH_BYTE = 35;
    public static final byte LEFT_BRACE_BYTE = 40;
    public static final byte MINUS_BYTE = 45;
    public static final byte PERCENT_BYTE = 37;
    public static final byte PLUS_BYTE = 43;
    public static final byte TILDE_BYTE = 126;
    public static final byte UNDERSCORE_BYTE = 95;
    public static final byte[] BYTES_TRUE = Protocol.toByteArray(1);
    public static final byte[] BYTES_FALSE = Protocol.toByteArray(0);
    public static final byte[] BYTES_TILDE = SafeEncoder.encode("~");
    public static final byte[] BYTES_EQUAL = SafeEncoder.encode("=");
    public static final byte[] BYTES_ASTERISK = SafeEncoder.encode("*");
    public static final byte[] POSITIVE_INFINITY_BYTES = "+inf".getBytes();
    public static final byte[] NEGATIVE_INFINITY_BYTES = "-inf".getBytes();
    private static final String ASK_PREFIX = "ASK ";
    private static final String MOVED_PREFIX = "MOVED ";
    private static final String CLUSTERDOWN_PREFIX = "CLUSTERDOWN ";
    private static final String BUSY_PREFIX = "BUSY ";
    private static final String NOSCRIPT_PREFIX = "NOSCRIPT ";
    private static final String WRONGPASS_PREFIX = "WRONGPASS";
    private static final String NOPERM_PREFIX = "NOPERM";

    private Protocol() {
        throw new InstantiationError("Must not instantiate this class");
    }

    public static void sendCommand(RedisOutputStream os, CommandArguments args2) {
        try {
            os.write((byte)42);
            os.writeIntCrLf(args2.size());
            for (Rawable arg : args2) {
                os.write((byte)36);
                byte[] bin = arg.getRaw();
                os.writeIntCrLf(bin.length);
                os.write(bin);
                os.writeCrLf();
            }
        }
        catch (IOException e) {
            throw new JedisConnectionException(e);
        }
    }

    private static void processError(RedisInputStream is) {
        String message = is.readLine();
        if (message.startsWith(MOVED_PREFIX)) {
            String[] movedInfo = Protocol.parseTargetHostAndSlot(message);
            throw new JedisMovedDataException(message, HostAndPort.from(movedInfo[1]), Integer.parseInt(movedInfo[0]));
        }
        if (message.startsWith(ASK_PREFIX)) {
            String[] askInfo = Protocol.parseTargetHostAndSlot(message);
            throw new JedisAskDataException(message, HostAndPort.from(askInfo[1]), Integer.parseInt(askInfo[0]));
        }
        if (message.startsWith(CLUSTERDOWN_PREFIX)) {
            throw new JedisClusterException(message);
        }
        if (message.startsWith(BUSY_PREFIX)) {
            throw new JedisBusyException(message);
        }
        if (message.startsWith(NOSCRIPT_PREFIX)) {
            throw new JedisNoScriptException(message);
        }
        if (message.startsWith(WRONGPASS_PREFIX)) {
            throw new JedisAccessControlException(message);
        }
        if (message.startsWith(NOPERM_PREFIX)) {
            throw new JedisAccessControlException(message);
        }
        throw new JedisDataException(message);
    }

    public static String readErrorLineIfPossible(RedisInputStream is) {
        byte b = is.readByte();
        if (b != 45) {
            return null;
        }
        return is.readLine();
    }

    private static String[] parseTargetHostAndSlot(String clusterRedirectResponse) {
        String[] response = new String[2];
        String[] messageInfo = clusterRedirectResponse.split(" ");
        response[0] = messageInfo[1];
        response[1] = messageInfo[2];
        return response;
    }

    private static Object process(RedisInputStream is) {
        byte b = is.readByte();
        switch (b) {
            case 43: {
                return is.readLineBytes();
            }
            case 36: 
            case 61: {
                return Protocol.processBulkReply(is);
            }
            case 42: {
                return Protocol.processMultiBulkReply(is);
            }
            case 95: {
                return is.readNullCrLf();
            }
            case 35: {
                return is.readBooleanCrLf();
            }
            case 58: {
                return is.readLongCrLf();
            }
            case 44: {
                return is.readDoubleCrLf();
            }
            case 40: {
                return is.readBigIntegerCrLf();
            }
            case 37: {
                return Protocol.processMapKeyValueReply(is);
            }
            case 126: {
                return Protocol.processMultiBulkReply(is);
            }
            case 62: {
                return Protocol.processMultiBulkReply(is);
            }
            case 45: {
                Protocol.processError(is);
                return null;
            }
        }
        throw new JedisConnectionException("Unknown reply: " + (char)b);
    }

    private static byte[] processBulkReply(RedisInputStream is) {
        int size;
        int len = is.readIntCrLf();
        if (len == -1) {
            return null;
        }
        byte[] read = new byte[len];
        for (int offset = 0; offset < len; offset += size) {
            size = is.read(read, offset, len - offset);
            if (size != -1) continue;
            throw new JedisConnectionException("It seems like server has closed the connection.");
        }
        is.readByte();
        is.readByte();
        return read;
    }

    private static List<Object> processMultiBulkReply(RedisInputStream is) {
        int num = is.readIntCrLf();
        if (num == -1) {
            return null;
        }
        ArrayList<Object> ret = new ArrayList<Object>(num);
        for (int i = 0; i < num; ++i) {
            try {
                ret.add(Protocol.process(is));
                continue;
            }
            catch (JedisDataException e) {
                ret.add(e);
            }
        }
        return ret;
    }

    private static List<KeyValue> processMapKeyValueReply(RedisInputStream is) {
        int num = is.readIntCrLf();
        if (num == -1) {
            return null;
        }
        ArrayList<KeyValue> ret = new ArrayList<KeyValue>(num);
        for (int i = 0; i < num; ++i) {
            ret.add(new KeyValue<Object, Object>(Protocol.process(is), Protocol.process(is)));
        }
        return ret;
    }

    public static Object read(RedisInputStream is) {
        return Protocol.process(is);
    }

    public static final byte[] toByteArray(boolean value) {
        return value ? BYTES_TRUE : BYTES_FALSE;
    }

    public static final byte[] toByteArray(int value) {
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static final byte[] toByteArray(long value) {
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static final byte[] toByteArray(double value) {
        if (value == Double.POSITIVE_INFINITY) {
            return POSITIVE_INFINITY_BYTES;
        }
        if (value == Double.NEGATIVE_INFINITY) {
            return NEGATIVE_INFINITY_BYTES;
        }
        return SafeEncoder.encode(String.valueOf(value));
    }

    public static enum ClusterKeyword implements Rawable
    {
        MEET,
        RESET,
        INFO,
        FAILOVER,
        SLOTS,
        NODES,
        REPLICAS,
        SLAVES,
        MYID,
        ADDSLOTS,
        DELSLOTS,
        GETKEYSINSLOT,
        SETSLOT,
        NODE,
        MIGRATING,
        IMPORTING,
        STABLE,
        FORGET,
        FLUSHSLOTS,
        KEYSLOT,
        COUNTKEYSINSLOT,
        SAVECONFIG,
        REPLICATE,
        LINKS,
        ADDSLOTSRANGE,
        DELSLOTSRANGE,
        BUMPEPOCH,
        MYSHARDID,
        SHARDS;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum ResponseKeyword implements Rawable
    {
        SUBSCRIBE,
        PSUBSCRIBE,
        UNSUBSCRIBE,
        PUNSUBSCRIBE,
        MESSAGE,
        PMESSAGE,
        PONG,
        SSUBSCRIBE,
        SUNSUBSCRIBE,
        SMESSAGE;

        private final byte[] raw = SafeEncoder.encode(this.name().toLowerCase(Locale.ENGLISH));

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum SentinelKeyword implements Rawable
    {
        MYID,
        MASTERS,
        MASTER,
        SENTINELS,
        SLAVES,
        REPLICAS,
        RESET,
        FAILOVER,
        REMOVE,
        SET,
        MONITOR,
        GET_MASTER_ADDR_BY_NAME("GET-MASTER-ADDR-BY-NAME");

        private final byte[] raw;

        private SentinelKeyword() {
            this.raw = SafeEncoder.encode(this.name());
        }

        private SentinelKeyword(String str) {
            this.raw = SafeEncoder.encode(str);
        }

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum Keyword implements Rawable
    {
        AGGREGATE,
        ALPHA,
        BY,
        GET,
        LIMIT,
        NO,
        NOSORT,
        ONE,
        SET,
        STORE,
        WEIGHTS,
        WITHSCORE,
        WITHSCORES,
        RESETSTAT,
        REWRITE,
        RESET,
        FLUSH,
        EXISTS,
        LOAD,
        LEN,
        HELP,
        SCHEDULE,
        MATCH,
        COUNT,
        TYPE,
        KEYS,
        REFCOUNT,
        ENCODING,
        IDLETIME,
        FREQ,
        REPLACE,
        GETNAME,
        SETNAME,
        SETINFO,
        LIST,
        ID,
        KILL,
        PERSIST,
        STREAMS,
        CREATE,
        MKSTREAM,
        SETID,
        DESTROY,
        DELCONSUMER,
        MAXLEN,
        GROUP,
        IDLE,
        TIME,
        BLOCK,
        NOACK,
        RETRYCOUNT,
        STREAM,
        GROUPS,
        CONSUMERS,
        JUSTID,
        WITHVALUES,
        NOMKSTREAM,
        MINID,
        CREATECONSUMER,
        SETUSER,
        GETUSER,
        DELUSER,
        WHOAMI,
        USERS,
        CAT,
        GENPASS,
        LOG,
        SAVE,
        DRYRUN,
        COPY,
        AUTH,
        AUTH2,
        NX,
        XX,
        EX,
        PX,
        EXAT,
        PXAT,
        ABSTTL,
        KEEPTTL,
        INCR,
        LT,
        GT,
        CH,
        INFO,
        PAUSE,
        UNPAUSE,
        UNBLOCK,
        REV,
        WITHCOORD,
        WITHDIST,
        WITHHASH,
        ANY,
        FROMMEMBER,
        FROMLONLAT,
        BYRADIUS,
        BYBOX,
        BYLEX,
        BYSCORE,
        STOREDIST,
        TO,
        FORCE,
        TIMEOUT,
        DB,
        UNLOAD,
        ABORT,
        IDX,
        MINMATCHLEN,
        WITHMATCHLEN,
        FULL,
        DELETE,
        LIBRARYNAME,
        WITHCODE,
        DESCRIPTION,
        GETKEYS,
        GETKEYSANDFLAGS,
        DOCS,
        FILTERBY,
        DUMP,
        MODULE,
        ACLCAT,
        PATTERN,
        DOCTOR,
        USAGE,
        SAMPLES,
        PURGE,
        STATS,
        LOADEX,
        CONFIG,
        ARGS,
        RANK,
        NOW,
        VERSION,
        ADDR,
        SKIPME,
        USER,
        LADDR,
        CHANNELS,
        NUMPAT,
        NUMSUB,
        SHARDCHANNELS,
        SHARDNUMSUB;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }

    public static enum Command implements ProtocolCommand
    {
        PING,
        AUTH,
        HELLO,
        SET,
        GET,
        GETDEL,
        GETEX,
        EXISTS,
        DEL,
        UNLINK,
        TYPE,
        FLUSHDB,
        FLUSHALL,
        MOVE,
        KEYS,
        RANDOMKEY,
        RENAME,
        RENAMENX,
        DUMP,
        RESTORE,
        DBSIZE,
        SELECT,
        SWAPDB,
        MIGRATE,
        ECHO,
        EXPIRE,
        EXPIREAT,
        EXPIRETIME,
        PEXPIRE,
        PEXPIREAT,
        PEXPIRETIME,
        TTL,
        PTTL,
        MULTI,
        DISCARD,
        EXEC,
        WATCH,
        UNWATCH,
        SORT,
        SORT_RO,
        INFO,
        SHUTDOWN,
        MONITOR,
        CONFIG,
        LCS,
        GETSET,
        MGET,
        SETNX,
        SETEX,
        PSETEX,
        MSET,
        MSETNX,
        DECR,
        DECRBY,
        INCR,
        INCRBY,
        INCRBYFLOAT,
        STRLEN,
        APPEND,
        SUBSTR,
        SETBIT,
        GETBIT,
        BITPOS,
        SETRANGE,
        GETRANGE,
        BITCOUNT,
        BITOP,
        BITFIELD,
        BITFIELD_RO,
        HSET,
        HGET,
        HSETNX,
        HMSET,
        HMGET,
        HINCRBY,
        HEXISTS,
        HDEL,
        HLEN,
        HKEYS,
        HVALS,
        HGETALL,
        HSTRLEN,
        HRANDFIELD,
        HINCRBYFLOAT,
        RPUSH,
        LPUSH,
        LLEN,
        LRANGE,
        LTRIM,
        LINDEX,
        LSET,
        LREM,
        LPOP,
        RPOP,
        BLPOP,
        BRPOP,
        LINSERT,
        LPOS,
        RPOPLPUSH,
        BRPOPLPUSH,
        BLMOVE,
        LMOVE,
        LMPOP,
        BLMPOP,
        LPUSHX,
        RPUSHX,
        SADD,
        SMEMBERS,
        SREM,
        SPOP,
        SMOVE,
        SCARD,
        SRANDMEMBER,
        SINTER,
        SINTERSTORE,
        SUNION,
        SUNIONSTORE,
        SDIFF,
        SDIFFSTORE,
        SISMEMBER,
        SMISMEMBER,
        SINTERCARD,
        ZADD,
        ZDIFF,
        ZDIFFSTORE,
        ZRANGE,
        ZREM,
        ZINCRBY,
        ZRANK,
        ZREVRANK,
        ZREVRANGE,
        ZRANDMEMBER,
        ZCARD,
        ZSCORE,
        ZPOPMAX,
        ZPOPMIN,
        ZCOUNT,
        ZUNION,
        ZUNIONSTORE,
        ZINTER,
        ZINTERSTORE,
        ZRANGEBYSCORE,
        ZREVRANGEBYSCORE,
        ZREMRANGEBYRANK,
        ZREMRANGEBYSCORE,
        ZLEXCOUNT,
        ZRANGEBYLEX,
        ZREVRANGEBYLEX,
        ZREMRANGEBYLEX,
        ZMSCORE,
        ZRANGESTORE,
        ZINTERCARD,
        ZMPOP,
        BZMPOP,
        BZPOPMIN,
        BZPOPMAX,
        GEOADD,
        GEODIST,
        GEOHASH,
        GEOPOS,
        GEORADIUS,
        GEORADIUS_RO,
        GEOSEARCH,
        GEOSEARCHSTORE,
        GEORADIUSBYMEMBER,
        GEORADIUSBYMEMBER_RO,
        PFADD,
        PFCOUNT,
        PFMERGE,
        XADD,
        XLEN,
        XDEL,
        XTRIM,
        XRANGE,
        XREVRANGE,
        XREAD,
        XACK,
        XGROUP,
        XREADGROUP,
        XPENDING,
        XCLAIM,
        XAUTOCLAIM,
        XINFO,
        EVAL,
        EVALSHA,
        SCRIPT,
        EVAL_RO,
        EVALSHA_RO,
        FUNCTION,
        FCALL,
        FCALL_RO,
        SUBSCRIBE,
        UNSUBSCRIBE,
        PSUBSCRIBE,
        PUNSUBSCRIBE,
        PUBLISH,
        PUBSUB,
        SSUBSCRIBE,
        SUNSUBSCRIBE,
        SPUBLISH,
        SAVE,
        BGSAVE,
        BGREWRITEAOF,
        LASTSAVE,
        PERSIST,
        ROLE,
        FAILOVER,
        SLOWLOG,
        OBJECT,
        CLIENT,
        TIME,
        SCAN,
        HSCAN,
        SSCAN,
        ZSCAN,
        WAIT,
        CLUSTER,
        ASKING,
        READONLY,
        READWRITE,
        SLAVEOF,
        REPLICAOF,
        COPY,
        SENTINEL,
        MODULE,
        ACL,
        TOUCH,
        MEMORY,
        LOLWUT,
        COMMAND,
        RESET,
        LATENCY,
        WAITAOF;

        private final byte[] raw = SafeEncoder.encode(this.name());

        @Override
        public byte[] getRaw() {
            return this.raw;
        }
    }
}

