/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.gears;

import java.util.Collections;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.gears.RedisGearsProtocol;
import redis.clients.jedis.params.IParams;

public class TFunctionListParams
implements IParams {
    private boolean withCode = false;
    private int verbose;
    private String libraryName;

    public static TFunctionListParams listParams() {
        return new TFunctionListParams();
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.withCode) {
            args2.add(RedisGearsProtocol.GearsKeyword.WITHCODE);
        }
        if (this.verbose > 0 && this.verbose < 4) {
            args2.add(String.join((CharSequence)"", Collections.nCopies(this.verbose, "v")));
        } else if (this.verbose != 0) {
            throw new IllegalArgumentException("verbose must be between 1 and 3");
        }
        if (this.libraryName != null) {
            args2.add(RedisGearsProtocol.GearsKeyword.LIBRARY).add(this.libraryName);
        }
    }

    public TFunctionListParams withCode() {
        this.withCode = true;
        return this;
    }

    public TFunctionListParams verbose(int verbose) {
        this.verbose = verbose;
        return this;
    }

    public TFunctionListParams library(String libraryName) {
        this.libraryName = libraryName;
        return this;
    }
}

