/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.CommandObject;
import redis.clients.jedis.CommandObjects;
import redis.clients.jedis.Connection;
import redis.clients.jedis.PipelineBase;
import redis.clients.jedis.RedisProtocol;
import redis.clients.jedis.Response;
import redis.clients.jedis.graph.ResultSet;
import redis.clients.jedis.mcf.CircuitBreakerFailoverConnectionProvider;
import redis.clients.jedis.providers.MultiClusterPooledConnectionProvider;
import redis.clients.jedis.util.KeyValue;

public class MultiClusterPipeline
extends PipelineBase
implements Closeable {
    private final CircuitBreakerFailoverConnectionProvider failoverProvider;
    private final Queue<KeyValue<CommandArguments, Response<?>>> commands = new LinkedList();

    public MultiClusterPipeline(MultiClusterPooledConnectionProvider pooledProvider) {
        super(new CommandObjects());
        try (Connection connection = pooledProvider.getConnection();){
            RedisProtocol proto = connection.getRedisProtocol();
            if (proto != null) {
                this.commandObjects.setProtocol(proto);
            }
        }
        this.failoverProvider = new CircuitBreakerFailoverConnectionProvider(pooledProvider);
    }

    @Override
    protected final <T> Response<T> appendCommand(CommandObject<T> commandObject) {
        CommandArguments args2 = commandObject.getArguments();
        Response<T> response = new Response<T>(commandObject.getBuilder());
        this.commands.add(KeyValue.of(args2, response));
        return response;
    }

    @Override
    public void close() {
        this.sync();
    }

    @Override
    public void sync() {
        if (this.commands.isEmpty()) {
            return;
        }
        try (Connection connection = this.failoverProvider.getConnection();){
            this.commands.forEach(command -> connection.sendCommand((CommandArguments)command.getKey()));
            List<Object> unformatted = connection.getMany(this.commands.size());
            unformatted.forEach(rawReply -> ((Response)this.commands.poll().getValue()).set(rawReply));
        }
    }

    public Response<Long> waitReplicas(int replicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitReplicas(replicas, timeout2));
    }

    public Response<KeyValue<Long, Long>> waitAOF(long numLocal, long numReplicas, long timeout2) {
        return this.appendCommand(this.commandObjects.waitAOF(numLocal, numReplicas, timeout2));
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphQuery(String name, String query, Map<String, Object> params, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<ResultSet> graphReadonlyQuery(String name, String query, Map<String, Object> params, long timeout2) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<String> graphDelete(String name) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }

    @Override
    public Response<List<String>> graphProfile(String graphName, String query) {
        throw new UnsupportedOperationException("Graph commands are not supported.");
    }
}

