/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.params;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.StreamEntryID;
import redis.clients.jedis.args.Rawable;
import redis.clients.jedis.args.RawableFactory;
import redis.clients.jedis.params.IParams;

public class XAddParams
implements IParams {
    private Rawable id;
    private Long maxLen;
    private boolean approximateTrimming;
    private boolean exactTrimming;
    private boolean nomkstream;
    private String minId;
    private Long limit;

    public static XAddParams xAddParams() {
        return new XAddParams();
    }

    public XAddParams noMkStream() {
        this.nomkstream = true;
        return this;
    }

    public XAddParams id(byte[] id) {
        this.id = RawableFactory.from(id);
        return this;
    }

    public XAddParams id(String id) {
        this.id = RawableFactory.from(id);
        return this;
    }

    public XAddParams id(StreamEntryID id) {
        return this.id(id.toString());
    }

    public XAddParams id(long time, long sequence2) {
        return this.id(time + "-" + sequence2);
    }

    public XAddParams id(long time) {
        return this.id(time + "-*");
    }

    public XAddParams maxLen(long maxLen) {
        this.maxLen = maxLen;
        return this;
    }

    public XAddParams minId(String minId) {
        this.minId = minId;
        return this;
    }

    public XAddParams approximateTrimming() {
        this.approximateTrimming = true;
        return this;
    }

    public XAddParams exactTrimming() {
        this.exactTrimming = true;
        return this;
    }

    public XAddParams limit(long limit) {
        this.limit = limit;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.nomkstream) {
            args2.add(Protocol.Keyword.NOMKSTREAM);
        }
        if (this.maxLen != null) {
            args2.add(Protocol.Keyword.MAXLEN);
            if (this.approximateTrimming) {
                args2.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args2.add(Protocol.BYTES_EQUAL);
            }
            args2.add(this.maxLen);
        } else if (this.minId != null) {
            args2.add(Protocol.Keyword.MINID);
            if (this.approximateTrimming) {
                args2.add(Protocol.BYTES_TILDE);
            } else if (this.exactTrimming) {
                args2.add(Protocol.BYTES_EQUAL);
            }
            args2.add(this.minId);
        }
        if (this.limit != null) {
            args2.add(Protocol.Keyword.LIMIT).add(this.limit);
        }
        args2.add(this.id != null ? this.id : StreamEntryID.NEW_ENTRY);
    }
}

