/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Connection;
import redis.clients.jedis.ConnectionPool;
import redis.clients.jedis.DefaultJedisClientConfig;
import redis.clients.jedis.HostAndPort;
import redis.clients.jedis.JedisClientConfig;
import redis.clients.jedis.ShardedCommandArguments;
import redis.clients.jedis.exceptions.JedisException;
import redis.clients.jedis.providers.ConnectionProvider;
import redis.clients.jedis.util.Hashing;

@Deprecated
public class ShardedConnectionProvider
implements ConnectionProvider {
    private final TreeMap<Long, HostAndPort> nodes = new TreeMap();
    private final Map<String, ConnectionPool> resources = new HashMap<String, ConnectionPool>();
    private final JedisClientConfig clientConfig;
    private final GenericObjectPoolConfig<Connection> poolConfig;
    private final Hashing algo;

    public ShardedConnectionProvider(List<HostAndPort> shards) {
        this(shards, DefaultJedisClientConfig.builder().build());
    }

    public ShardedConnectionProvider(List<HostAndPort> shards, JedisClientConfig clientConfig) {
        this(shards, clientConfig, new GenericObjectPoolConfig<Connection>());
    }

    public ShardedConnectionProvider(List<HostAndPort> shards, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig) {
        this(shards, clientConfig, poolConfig, Hashing.MURMUR_HASH);
    }

    public ShardedConnectionProvider(List<HostAndPort> shards, JedisClientConfig clientConfig, Hashing algo) {
        this(shards, clientConfig, null, algo);
    }

    public ShardedConnectionProvider(List<HostAndPort> shards, JedisClientConfig clientConfig, GenericObjectPoolConfig<Connection> poolConfig, Hashing algo) {
        this.clientConfig = clientConfig;
        this.poolConfig = poolConfig;
        this.algo = algo;
        this.initialize(shards);
    }

    private void initialize(List<HostAndPort> shards) {
        for (int i = 0; i < shards.size(); ++i) {
            HostAndPort shard = shards.get(i);
            for (int n = 0; n < 160; ++n) {
                Long hash = this.algo.hash("SHARD-" + i + "-NODE-" + n);
                this.nodes.put(hash, shard);
                this.setupNodeIfNotExist(shard);
            }
        }
    }

    private ConnectionPool setupNodeIfNotExist(HostAndPort node) {
        String nodeKey = node.toString();
        ConnectionPool existingPool = this.resources.get(nodeKey);
        if (existingPool != null) {
            return existingPool;
        }
        ConnectionPool nodePool = this.poolConfig == null ? new ConnectionPool(node, this.clientConfig) : new ConnectionPool(node, this.clientConfig, this.poolConfig);
        this.resources.put(nodeKey, nodePool);
        return nodePool;
    }

    public Hashing getHashingAlgo() {
        return this.algo;
    }

    private void reset() {
        for (ConnectionPool pool : this.resources.values()) {
            try {
                if (pool == null) continue;
                pool.destroy();
            }
            catch (RuntimeException runtimeException) {}
        }
        this.resources.clear();
        this.nodes.clear();
    }

    @Override
    public void close() {
        this.reset();
    }

    public HostAndPort getNode(Long hash) {
        return hash != null ? this.getNodeFromHash(hash) : null;
    }

    public Connection getConnection(HostAndPort node) {
        return node != null ? this.setupNodeIfNotExist(node).getResource() : this.getConnection();
    }

    @Override
    public Connection getConnection(CommandArguments args2) {
        Long hash = ((ShardedCommandArguments)args2).getKeyHash();
        return hash != null ? this.getConnection(this.getNodeFromHash(hash)) : this.getConnection();
    }

    private List<ConnectionPool> getShuffledNodesPool() {
        ArrayList<ConnectionPool> pools = new ArrayList<ConnectionPool>(this.resources.values());
        Collections.shuffle(pools);
        return pools;
    }

    @Override
    public Connection getConnection() {
        List<ConnectionPool> pools = this.getShuffledNodesPool();
        JedisException suppressed = null;
        for (ConnectionPool pool : pools) {
            Connection jedis = null;
            try {
                jedis = pool.getResource();
                if (jedis == null) continue;
                jedis.ping();
                return jedis;
            }
            catch (JedisException ex) {
                if (suppressed == null) {
                    suppressed = ex;
                }
                if (jedis == null) continue;
                jedis.close();
            }
        }
        JedisException noReachableNode = new JedisException("No reachable shard.");
        if (suppressed != null) {
            noReachableNode.addSuppressed(suppressed);
        }
        throw noReachableNode;
    }

    private HostAndPort getNodeFromHash(Long hash) {
        SortedMap<Long, HostAndPort> tail = this.nodes.tailMap(hash);
        if (tail.isEmpty()) {
            return this.nodes.get(this.nodes.firstKey());
        }
        return (HostAndPort)tail.get(tail.firstKey());
    }

    public Map<String, ConnectionPool> getConnectionMap() {
        return Collections.unmodifiableMap(this.resources);
    }
}

