/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.timeseries;

import redis.clients.jedis.CommandArguments;
import redis.clients.jedis.Protocol;
import redis.clients.jedis.params.IParams;
import redis.clients.jedis.timeseries.AggregationType;
import redis.clients.jedis.timeseries.TimeSeriesProtocol;
import redis.clients.jedis.util.SafeEncoder;

public class TSMRangeParams
implements IParams {
    private Long fromTimestamp;
    private Long toTimestamp;
    private boolean latest;
    private long[] filterByTimestamps;
    private double[] filterByValues;
    private boolean withLabels;
    private String[] selectedLabels;
    private Integer count;
    private byte[] align;
    private AggregationType aggregationType;
    private long bucketDuration;
    private byte[] bucketTimestamp;
    private boolean empty;
    private String[] filters;
    private String groupByLabel;
    private String groupByReduce;

    public TSMRangeParams(long fromTimestamp, long toTimestamp) {
        this.fromTimestamp = fromTimestamp;
        this.toTimestamp = toTimestamp;
    }

    public static TSMRangeParams multiRangeParams(long fromTimestamp, long toTimestamp) {
        return new TSMRangeParams(fromTimestamp, toTimestamp);
    }

    public TSMRangeParams() {
    }

    public static TSMRangeParams multiRangeParams() {
        return new TSMRangeParams();
    }

    public TSMRangeParams fromTimestamp(long fromTimestamp) {
        this.fromTimestamp = fromTimestamp;
        return this;
    }

    public TSMRangeParams toTimestamp(long toTimestamp) {
        this.toTimestamp = toTimestamp;
        return this;
    }

    public TSMRangeParams latest() {
        this.latest = true;
        return this;
    }

    public TSMRangeParams filterByTS(long ... timestamps) {
        this.filterByTimestamps = timestamps;
        return this;
    }

    public TSMRangeParams filterByValues(double min, double max) {
        this.filterByValues = new double[]{min, max};
        return this;
    }

    public TSMRangeParams withLabels(boolean withLabels) {
        this.withLabels = withLabels;
        return this;
    }

    public TSMRangeParams withLabels() {
        return this.withLabels(true);
    }

    public TSMRangeParams selectedLabels(String ... labels) {
        this.selectedLabels = labels;
        return this;
    }

    public TSMRangeParams count(int count) {
        this.count = count;
        return this;
    }

    private TSMRangeParams align(byte[] raw) {
        this.align = raw;
        return this;
    }

    public TSMRangeParams align(long timestamp) {
        return this.align(Protocol.toByteArray(timestamp));
    }

    public TSMRangeParams alignStart() {
        return this.align(TimeSeriesProtocol.MINUS);
    }

    public TSMRangeParams alignEnd() {
        return this.align(TimeSeriesProtocol.PLUS);
    }

    public TSMRangeParams aggregation(AggregationType aggregationType, long bucketDuration) {
        this.aggregationType = aggregationType;
        this.bucketDuration = bucketDuration;
        return this;
    }

    public TSMRangeParams bucketTimestamp(String bucketTimestamp) {
        this.bucketTimestamp = SafeEncoder.encode(bucketTimestamp);
        return this;
    }

    public TSMRangeParams bucketTimestampLow() {
        this.bucketTimestamp = TimeSeriesProtocol.MINUS;
        return this;
    }

    public TSMRangeParams bucketTimestampHigh() {
        this.bucketTimestamp = TimeSeriesProtocol.PLUS;
        return this;
    }

    public TSMRangeParams bucketTimestampMid() {
        this.bucketTimestamp = Protocol.BYTES_TILDE;
        return this;
    }

    public TSMRangeParams empty() {
        this.empty = true;
        return this;
    }

    public TSMRangeParams filter(String ... filters) {
        this.filters = filters;
        return this;
    }

    public TSMRangeParams groupBy(String label, String reduce) {
        this.groupByLabel = label;
        this.groupByReduce = reduce;
        return this;
    }

    @Override
    public void addParams(CommandArguments args2) {
        if (this.filters == null) {
            throw new IllegalArgumentException("FILTER arguments must be set.");
        }
        if (this.fromTimestamp == null) {
            args2.add(TimeSeriesProtocol.MINUS);
        } else {
            args2.add(Protocol.toByteArray(this.fromTimestamp));
        }
        if (this.toTimestamp == null) {
            args2.add(TimeSeriesProtocol.PLUS);
        } else {
            args2.add(Protocol.toByteArray(this.toTimestamp));
        }
        if (this.latest) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.LATEST);
        }
        if (this.filterByTimestamps != null) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER_BY_TS);
            for (long ts : this.filterByTimestamps) {
                args2.add(Protocol.toByteArray(ts));
            }
        }
        if (this.filterByValues != null) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER_BY_VALUE);
            for (double value : this.filterByValues) {
                args2.add(Protocol.toByteArray(value));
            }
        }
        if (this.withLabels) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.WITHLABELS);
        } else if (this.selectedLabels != null) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.SELECTED_LABELS);
            for (String label : this.selectedLabels) {
                args2.add(label);
            }
        }
        if (this.count != null) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.COUNT).add(Protocol.toByteArray(this.count));
        }
        if (this.aggregationType != null) {
            if (this.align != null) {
                args2.add(TimeSeriesProtocol.TimeSeriesKeyword.ALIGN).add(this.align);
            }
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.AGGREGATION).add(this.aggregationType).add(Protocol.toByteArray(this.bucketDuration));
            if (this.bucketTimestamp != null) {
                args2.add(TimeSeriesProtocol.TimeSeriesKeyword.BUCKETTIMESTAMP).add(this.bucketTimestamp);
            }
            if (this.empty) {
                args2.add(TimeSeriesProtocol.TimeSeriesKeyword.EMPTY);
            }
        }
        args2.add(TimeSeriesProtocol.TimeSeriesKeyword.FILTER);
        for (String filter : this.filters) {
            args2.add(filter);
        }
        if (this.groupByLabel != null && this.groupByReduce != null) {
            args2.add(TimeSeriesProtocol.TimeSeriesKeyword.GROUPBY).add(this.groupByLabel).add(TimeSeriesProtocol.TimeSeriesKeyword.REDUCE).add(this.groupByReduce);
        }
    }
}

