/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils;

import com.mojang.brigadier.CommandDispatcher;
import com.serverutils.commands.BackCommand;
import com.serverutils.commands.HomeCommand;
import com.serverutils.commands.RtpCommand;
import com.serverutils.commands.TpaCommand;
import com.serverutils.config.ConfigManager;
import com.serverutils.data.PlayerDataManager;
import java.util.Collections;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ServerUtils
implements ModInitializer {
    public static final String MOD_ID = "serverutils";
    private static PlayerDataManager playerDataManager;
    private static ConfigManager configManager;

    public void onInitialize() {
        configManager = new ConfigManager();
        configManager.load();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            playerDataManager = new PlayerDataManager(server);
        });
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            HomeCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TpaCommand.register((CommandDispatcher<class_2168>)dispatcher);
            RtpCommand.register((CommandDispatcher<class_2168>)dispatcher);
            BackCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            PlayerDataManager mgr = ServerUtils.getPlayerDataManager();
            if (mgr == null) {
                return;
            }
            long now = System.currentTimeMillis();
            for (UUID uuid : mgr.getPendingRtpKeysSnapshot()) {
                PlayerDataManager.PendingRtp pending = mgr.getPendingRtp(uuid);
                if (pending == null || now < pending.dueAtMillis) continue;
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player == null) {
                    mgr.clearPendingRtp(uuid);
                    continue;
                }
                class_2960 id = class_2960.method_12829((String)pending.dimension);
                if (id == null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cInvalid world for pending RTP."));
                    mgr.clearPendingRtp(uuid);
                    continue;
                }
                class_5321 levelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                class_3218 world = server.method_3847(levelKey);
                if (world == null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cWorld no longer available for RTP."));
                    mgr.clearPendingRtp(uuid);
                    continue;
                }
                player.method_48105(world, pending.x, pending.y, pending.z, Collections.emptySet(), player.method_36454(), player.method_36455(), false);
                player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aRTP complete!"));
                mgr.setLastRtpAt(uuid, now);
                mgr.clearPendingRtp(uuid);
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            PlayerDataManager mgr = ServerUtils.getPlayerDataManager();
            if (mgr == null) {
                return;
            }
            long now = System.currentTimeMillis();
            ConfigManager.ConfigData cfg = ServerUtils.getConfig().get();
            for (UUID uuid : mgr.getPendingHomeKeysSnapshot()) {
                double dz;
                double dy;
                PlayerDataManager.PendingHome pending = mgr.getPendingHome(uuid);
                if (pending == null) continue;
                class_3222 player = server.method_3760().method_14602(uuid);
                if (player == null) {
                    mgr.clearPendingHome(uuid);
                    continue;
                }
                double dx = player.method_23317() - pending.startX;
                double distSqr = dx * dx + (dy = player.method_23318() - pending.startY) * dy + (dz = player.method_23321() - pending.startZ) * dz;
                if (distSqr > pending.cancelRadius * pending.cancelRadius) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cTeleport cancelled: you moved."));
                    mgr.clearPendingHome(uuid);
                    continue;
                }
                long msLeft = pending.dueAtMillis - now;
                int secLeft = (int)Math.ceil((double)Math.max(0L, msLeft) / 1000.0);
                if (secLeft != pending.lastAnnouncedSeconds) {
                    pending.lastAnnouncedSeconds = secLeft;
                    if (secLeft > 0) {
                        player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eTeleporting in " + secLeft + "s. Don't move!")));
                        if (cfg.homeChimeEachSecond) {
                            player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14627, class_3419.field_15248, 0.8f, 1.0f);
                        }
                    }
                }
                if (now < pending.dueAtMillis) continue;
                class_2960 id = class_2960.method_12829((String)pending.dimension);
                if (id == null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cInvalid world for pending home teleport."));
                    mgr.clearPendingHome(uuid);
                    continue;
                }
                class_5321 levelKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                class_3218 world = server.method_3847(levelKey);
                if (world == null) {
                    player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cWorld no longer available for home teleport."));
                    mgr.clearPendingHome(uuid);
                    continue;
                }
                player.method_48105(world, pending.x, pending.y, pending.z, Collections.emptySet(), player.method_36454(), player.method_36455(), false);
                player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aTeleported to home!"));
                mgr.clearPendingHome(uuid);
            }
        });
    }

    public static PlayerDataManager getPlayerDataManager() {
        return playerDataManager;
    }

    public static ConfigManager getConfig() {
        return configManager;
    }
}

