/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.serverutils.ServerUtils;
import com.serverutils.data.PlayerDataManager;
import com.serverutils.perm.PermissionUtil;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class HomeCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"home").requires(source -> PermissionUtil.has(source, "serverutils.command.home", true))).executes(ctx -> HomeCommand.executeHome((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(HomeCommand::suggestHomes).executes(ctx -> HomeCommand.executeHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"suhome").requires(source -> PermissionUtil.has(source, "serverutils.command.home", true))).executes(ctx -> HomeCommand.executeHome((CommandContext<class_2168>)ctx, null))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(HomeCommand::suggestHomes).executes(ctx -> HomeCommand.executeHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"sethome").requires(source -> PermissionUtil.has(source, "serverutils.command.sethome", true))).executes(ctx -> HomeCommand.executeSetHome((CommandContext<class_2168>)ctx, "home"))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> HomeCommand.executeSetHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delhome").requires(source -> PermissionUtil.has(source, "serverutils.command.delhome", true))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.word()).suggests(HomeCommand::suggestHomes).executes(ctx -> HomeCommand.executeDelHome((CommandContext<class_2168>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name")))));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"homes").requires(source -> PermissionUtil.has(source, "serverutils.command.homes", true))).executes(HomeCommand::executeHomes));
    }

    private static CompletableFuture<Suggestions> suggestHomes(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        try {
            class_3222 player = ((class_2168)ctx.getSource()).method_44023();
            if (player != null) {
                Set<String> names = ServerUtils.getPlayerDataManager().getHomeNames(player.method_5667());
                for (String n : names) {
                    builder.suggest(n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return builder.buildFuture();
    }

    private static int executeSetHome(CommandContext<class_2168> ctx, String name) {
        int limit;
        int current;
        boolean replacing;
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        PlayerDataManager manager = ServerUtils.getPlayerDataManager();
        String key = name.toLowerCase(Locale.ROOT);
        boolean bl = replacing = manager.getHome(player.method_5667(), key) != null;
        if (!replacing && (current = manager.getHomesCount(player.method_5667())) >= (limit = PermissionUtil.getMaxHomes(player))) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cYou have reached your homes limit (" + String.valueOf(limit == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(limit)) + ").")));
            return 0;
        }
        manager.setHome(player.method_5667(), key, player.method_73189(), player.method_51469().method_27983().method_29177().toString());
        player.method_64398((class_2561)class_2561.method_43470((String)((replacing ? "\u00a7eHome updated: " : "\u00a7aHome set: ") + key)));
        return 1;
    }

    private static int executeHome(CommandContext<class_2168> ctx, String nameOrNull) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        PlayerDataManager manager = ServerUtils.getPlayerDataManager();
        if (nameOrNull == null) {
            Set<String> names = manager.getHomeNames(player.method_5667());
            if (names.isEmpty()) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eYou have no homes. Use \u00a7a/sethome [name]"));
            } else {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aYour homes:"));
                for (String n : names) {
                    PlayerDataManager.HomeLocation h = manager.getHome(player.method_5667(), n);
                    String dim = h != null ? h.dimension : "?";
                    player.method_64398((class_2561)class_2561.method_43470((String)(" - \u00a7f" + n + " \u00a77(" + dim + ")")));
                }
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7a/home <name>\u00a77 or press TAB to autocomplete."));
            }
            return 1;
        }
        String name = nameOrNull;
        PlayerDataManager.HomeLocation home = manager.getHome(player.method_5667(), name);
        if (home == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cHome '" + name + "' not found!")));
            return 0;
        }
        int warmup = Math.max(0, ServerUtils.getConfig().get().homeWarmupSeconds);
        manager.setLastLocation(player.method_5667(), player.method_73189(), player.method_51469().method_27983().method_29177().toString());
        long due = System.currentTimeMillis() + (long)warmup * 1000L;
        double cancelRadius = Math.max(0.1, ServerUtils.getConfig().get().homeCancelMoveDistance);
        manager.scheduleHomeTp(player.method_5667(), home.dimension, home.x + 0.5, home.y, home.z + 0.5, due, player.method_23317(), player.method_23318(), player.method_23321(), cancelRadius);
        if (warmup > 0) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eTeleporting to \u00a7a" + name + " \u00a7ein " + warmup + "s. Don't move!")));
        } else {
            class_2960 id = class_2960.method_12829((String)home.dimension);
            if (id == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cInvalid dimension for home."));
                return 0;
            }
            class_5321 key = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
            class_3218 world = ((class_2168)ctx.getSource()).method_9211().method_3847(key);
            if (world == null) {
                player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cWorld not found for home."));
                return 0;
            }
            player.method_48105(world, home.x + 0.5, home.y, home.z + 0.5, Collections.emptySet(), player.method_36454(), player.method_36455(), false);
            player.method_51469().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aTeleported to home '" + name + "'.")));
        }
        return 1;
    }

    private static int executeDelHome(CommandContext<class_2168> ctx, String name) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        PlayerDataManager manager = ServerUtils.getPlayerDataManager();
        if (manager.getHome(player.method_5667(), name) == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cHome '" + name + "' not found!")));
            return 0;
        }
        manager.deleteHome(player.method_5667(), name);
        player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aHome '" + name + "' deleted.")));
        return 1;
    }

    private static int executeHomes(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        PlayerDataManager manager = ServerUtils.getPlayerDataManager();
        Set<String> homes = manager.getHomeNames(player.method_5667());
        int limit = PermissionUtil.getMaxHomes(player);
        if (homes.isEmpty()) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7eYou have no homes. Limit: \u00a7f" + String.valueOf(limit == Integer.MAX_VALUE ? "unlimited" : Integer.valueOf(limit)))));
        } else {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aYour homes (" + homes.size() + "/" + String.valueOf(limit == Integer.MAX_VALUE ? "\u221e" : Integer.valueOf(limit)) + "):")));
            for (String n : homes) {
                PlayerDataManager.HomeLocation h = manager.getHome(player.method_5667(), n);
                String dim = h != null ? h.dimension : "?";
                player.method_64398((class_2561)class_2561.method_43470((String)(" - \u00a7f" + n + " \u00a77(" + dim + ")")));
            }
        }
        return 1;
    }
}

