/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.serverutils.ServerUtils;
import com.serverutils.config.ConfigManager;
import com.serverutils.perm.PermissionUtil;
import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2784;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class RtpCommand {
    private static final Random RANDOM = new Random();

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").requires(source -> PermissionUtil.has(source, "serverutils.command.rtp", true))).executes(RtpCommand::executeRtp));
    }

    private static int executeRtp(CommandContext<class_2168> ctx) {
        long left;
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        ConfigManager.ConfigData cfg = ServerUtils.getConfig().get();
        String dimId = player.method_51469().method_27983().method_29177().toString();
        if (!cfg.rtpAllowedWorlds.contains(dimId)) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cRTP is disabled in this world."));
            return 0;
        }
        int cd = Math.max(0, PermissionUtil.getRtpCooldownSeconds(player));
        long now = System.currentTimeMillis();
        Long last = ServerUtils.getPlayerDataManager().getLastRtpAt(player.method_5667());
        if (cd > 0 && last != null && (left = last + (long)cd * 1000L - now) > 0L) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7cYou must wait " + left / 1000L + "s before using /rtp again.")));
            return 0;
        }
        class_3218 world = ((class_2168)ctx.getSource()).method_9225();
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eSearching for a safe location..."));
        class_2338 safePos = RtpCommand.findSafeLocation(world, cfg);
        if (safePos == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cCouldn't find a safe location. Try again."));
            return 0;
        }
        ServerUtils.getPlayerDataManager().setLastLocation(player.method_5667(), player.method_73189(), world.method_27983().method_29177().toString());
        int warmup = Math.max(0, cfg.rtpWarmupSeconds);
        long due = now + (long)warmup * 1000L;
        ServerUtils.getPlayerDataManager().scheduleRtp(player.method_5667(), world.method_27983().method_29177().toString(), (double)safePos.method_10263() + 0.5, safePos.method_10264(), (double)safePos.method_10260() + 0.5, due);
        if (warmup > 0) {
            player.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aRTP in " + warmup + "s. Don\u2019t log out!")));
        } else {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aTeleporting..."));
        }
        return 1;
    }

    private static class_2338 findSafeLocation(class_3218 world, ConfigManager.ConfigData cfg) {
        int attempts = Math.max(1, cfg.rtpMaxAttempts);
        double minDist = Math.max(0, cfg.rtpMinDistance);
        double maxDist = Math.max(minDist, (double)cfg.rtpMaxDistance);
        double centerX = 0.0;
        double centerZ = 0.0;
        double effectiveMax = maxDist;
        if (cfg.rtpRespectWorldBorder) {
            class_2784 border = world.method_8621();
            double size = border.method_11965();
            double half = size / 2.0;
            double margin = Math.max(0, cfg.rtpWorldBorderMargin);
            centerX = border.method_11964();
            centerZ = border.method_11980();
            double borderLimitedMax = Math.max(0.0, half - margin);
            effectiveMax = Math.min(maxDist, borderLimitedMax);
        }
        if (cfg.rtpClampToHardMax) {
            effectiveMax = Math.min(effectiveMax, (double)Math.max(0, cfg.rtpHardMaxRadius));
        }
        if (minDist > effectiveMax) {
            minDist = Math.max(0.0, Math.min(minDist, effectiveMax));
        }
        int minYWorld = world.method_8597().comp_651();
        for (int i = 0; i < attempts; ++i) {
            class_2338 candidate;
            int yTop;
            double radius = RtpCommand.randomDouble(minDist, effectiveMax);
            double theta = RANDOM.nextDouble() * Math.PI * 2.0;
            int x = (int)Math.round(centerX + radius * Math.cos(theta));
            int z = (int)Math.round(centerZ + radius * Math.sin(theta));
            if (cfg.rtpClampToHardMax && cfg.rtpHardMaxRadius > 0) {
                int hard = cfg.rtpHardMaxRadius;
                x = RtpCommand.clampToRange(x, (int)Math.floor(centerX) - hard, (int)Math.ceil(centerX) + hard);
                z = RtpCommand.clampToRange(z, (int)Math.floor(centerZ) - hard, (int)Math.ceil(centerZ) + hard);
            }
            if (cfg.rtpLoadChunks) {
                try {
                    world.method_8497(x >> 4, z >> 4);
                }
                catch (Throwable hard) {}
            } else if (!world.method_8393(x >> 4, z >> 4)) continue;
            if ((yTop = world.method_8624(class_2902.class_2903.field_13203, x, z)) <= minYWorld || (candidate = RtpCommand.scanDownForSafe(world, new class_2338(x, yTop, z), 16, minYWorld)) == null || cfg.rtpRespectWorldBorder && !world.method_8621().method_11952(candidate)) continue;
            return candidate;
        }
        return null;
    }

    private static int clampToRange(int val, int min, int max) {
        if (val < min) {
            return min;
        }
        if (val > max) {
            return max;
        }
        return val;
    }

    private static class_2338 scanDownForSafe(class_3218 world, class_2338 start, int maxDepth, int minYWorld) {
        class_2338 pos = start.method_10062();
        int minY = minYWorld + 2;
        for (int i = 0; i < maxDepth && pos.method_10264() > minY; ++i) {
            class_2338 below;
            if (RtpCommand.isAir((class_1936)world, pos) && RtpCommand.isAir((class_1936)world, pos.method_10084()) && RtpCommand.isSolid((class_1936)world, below = pos.method_10074()) && !RtpCommand.isHazard((class_1936)world, below) && !RtpCommand.isFluid((class_1936)world, pos) && !RtpCommand.isFluid((class_1936)world, pos.method_10084())) {
                return pos;
            }
            pos = pos.method_10074();
        }
        return null;
    }

    private static boolean isAir(class_1936 world, class_2338 pos) {
        return world.method_8320(pos).method_26215();
    }

    private static boolean isSolid(class_1936 world, class_2338 pos) {
        return !world.method_8320(pos).method_26220((class_1922)world, pos).method_1110();
    }

    private static boolean isFluid(class_1936 world, class_2338 pos) {
        return !world.method_8316(pos).method_15769();
    }

    private static boolean isHazard(class_1936 world, class_2338 below) {
        class_2680 bs = world.method_8320(below);
        return bs.method_27852(class_2246.field_10029) || bs.method_27852(class_2246.field_10092) || bs.method_27852(class_2246.field_17350) || bs.method_27852(class_2246.field_10036) || bs.method_27852(class_2246.field_23860) || bs.method_27852(class_2246.field_16999);
    }

    private static double randomDouble(double min, double max) {
        if (max <= min) {
            return min;
        }
        return min + RANDOM.nextDouble() * (max - min);
    }
}

