/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.serverutils.ServerUtils;
import com.serverutils.data.PlayerDataManager;
import com.serverutils.perm.PermissionUtil;
import java.util.Collections;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;

public class TpaCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpa").requires(source -> PermissionUtil.has(source, "serverutils.command.tpa", true))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(TpaCommand::executeTpa)));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpaccept").requires(source -> PermissionUtil.has(source, "serverutils.command.tpaccept", true))).executes(TpaCommand::executeTpaccept));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpdeny").requires(source -> PermissionUtil.has(source, "serverutils.command.tpdeny", true))).executes(TpaCommand::executeTpdeny));
    }

    private static int executeTpa(CommandContext<class_2168> ctx) {
        class_3222 sender = ((class_2168)ctx.getSource()).method_44023();
        if (sender == null) {
            return 0;
        }
        try {
            class_3222 target = class_2186.method_9315(ctx, (String)"player");
            if (sender.equals((Object)target)) {
                sender.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou cannot teleport to yourself!"));
                return 0;
            }
            long timeoutMs = (long)ServerUtils.getConfig().get().tpaTimeoutSeconds * 1000L;
            ServerUtils.getPlayerDataManager().addTpaRequest(sender.method_5667(), target.method_5667(), timeoutMs);
            sender.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aTeleport request sent to " + target.method_5477().getString())));
            target.method_64398((class_2561)class_2561.method_43470((String)("\u00a7e" + sender.method_5477().getString() + " wants to teleport to you! Type \u00a7a/tpaccept \u00a7eor \u00a7c/tpdeny")));
            return 1;
        }
        catch (Exception e) {
            sender.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cPlayer not found!"));
            return 0;
        }
    }

    private static int executeTpaccept(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        PlayerDataManager manager = ServerUtils.getPlayerDataManager();
        PlayerDataManager.TpaRequest request = manager.getTpaRequest(player.method_5667());
        if (request == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou have no pending teleport requests!"));
            return 0;
        }
        class_3222 requester = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14602(request.requester);
        if (requester == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cThe player is no longer online!"));
            manager.removeTpaRequest(player.method_5667());
            return 0;
        }
        manager.setLastLocation(requester.method_5667(), requester.method_73189(), requester.method_51469().method_27983().method_29177().toString());
        class_3218 targetWorld = ((class_2168)ctx.getSource()).method_9225();
        requester.method_48105(targetWorld, player.method_23317(), player.method_23318(), player.method_23321(), Collections.emptySet(), requester.method_36454(), requester.method_36455(), false);
        requester.method_51469().method_43128(null, requester.method_23317(), requester.method_23318(), requester.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7aTeleport request accepted."));
        requester.method_64398((class_2561)class_2561.method_43470((String)("\u00a7aTeleporting to " + player.method_5477().getString() + ".")));
        manager.removeTpaRequest(player.method_5667());
        return 1;
    }

    private static int executeTpdeny(CommandContext<class_2168> ctx) {
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return 0;
        }
        PlayerDataManager manager = ServerUtils.getPlayerDataManager();
        PlayerDataManager.TpaRequest request = manager.getTpaRequest(player.method_5667());
        if (request == null) {
            player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7cYou have no pending teleport requests!"));
            return 0;
        }
        class_3222 requester = ((class_2168)ctx.getSource()).method_9211().method_3760().method_14602(request.requester);
        if (requester != null) {
            requester.method_64398((class_2561)class_2561.method_43470((String)("\u00a7c" + player.method_5477().getString() + " denied your teleport request.")));
        }
        player.method_64398((class_2561)class_2561.method_43470((String)"\u00a7eTeleport request denied."));
        manager.removeTpaRequest(player.method_5667());
        return 1;
    }
}

