/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path configPath = FabricLoader.getInstance().getConfigDir().resolve("serverutils.json");
    private ConfigData data = new ConfigData();

    public void load() {
        try {
            if (Files.notExists(this.configPath, new LinkOption[0])) {
                this.save();
                return;
            }
            try (BufferedReader reader = Files.newBufferedReader(this.configPath);){
                ConfigData loaded = (ConfigData)GSON.fromJson((Reader)reader, ConfigData.class);
                if (loaded != null) {
                    this.data = loaded;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        try {
            if (Files.notExists(this.configPath.getParent(), new LinkOption[0])) {
                Files.createDirectories(this.configPath.getParent(), new FileAttribute[0]);
            }
            try (BufferedWriter writer = Files.newBufferedWriter(this.configPath, new OpenOption[0]);){
                GSON.toJson((Object)this.data, (Appendable)writer);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ConfigData get() {
        return this.data;
    }

    public static class ConfigData {
        public int defaultMaxHomes = 3;
        public boolean useLuckPermsMetaForMaxHomes = true;
        public int permissionMaxHomesScanCeil = 100;
        public boolean allowUnlimitedHomesPermission = true;
        public int homeWarmupSeconds = 5;
        public double homeCancelMoveDistance = 1.5;
        public boolean homeChimeEachSecond = true;
        public int tpaTimeoutSeconds = 60;
        public int rtpMinDistance = 500;
        public int rtpMaxDistance = 5000;
        public int rtpMaxAttempts = 24;
        public boolean rtpRespectWorldBorder = true;
        public int rtpWorldBorderMargin = 16;
        public List<String> rtpAllowedWorlds = Arrays.asList("minecraft:overworld");
        public int rtpWarmupSeconds = 3;
        public int rtpDefaultCooldownSeconds = 60;
        public boolean rtpLoadChunks = true;
        public boolean rtpClampToHardMax = true;
        public int rtpHardMaxRadius = 25000;
    }
}

