/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_243;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;

public class PlayerDataManager {
    private final Path dataFolder;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final Map<UUID, PlayerData> playerDataCache = new ConcurrentHashMap<UUID, PlayerData>();
    private final Map<UUID, TpaRequest> tpaRequests = new ConcurrentHashMap<UUID, TpaRequest>();
    private final Map<UUID, Long> lastRtpAt = new ConcurrentHashMap<UUID, Long>();
    private final Map<UUID, PendingRtp> pendingRtp = new ConcurrentHashMap<UUID, PendingRtp>();
    private final Map<UUID, PendingHome> pendingHome = new ConcurrentHashMap<UUID, PendingHome>();

    public PlayerDataManager(MinecraftServer server) {
        this.dataFolder = server.method_27050(class_5218.field_24188).resolve("serverutils");
        try {
            Files.createDirectories(this.dataFolder, new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public PlayerData getPlayerData(UUID uuid) {
        return this.playerDataCache.computeIfAbsent(uuid, this::loadPlayerData);
    }

    private PlayerData loadPlayerData(UUID uuid) {
        Path file = this.dataFolder.resolve(String.valueOf(uuid) + ".json");
        if (Files.exists(file, new LinkOption[0])) {
            PlayerData playerData;
            block9: {
                BufferedReader reader = Files.newBufferedReader(file);
                try {
                    PlayerData data = (PlayerData)this.gson.fromJson((Reader)reader, PlayerData.class);
                    PlayerData playerData2 = playerData = data != null ? data : new PlayerData();
                    if (reader == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                ((Reader)reader).close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                ((Reader)reader).close();
            }
            return playerData;
        }
        return new PlayerData();
    }

    public void savePlayerData(UUID uuid) {
        PlayerData data = this.playerDataCache.get(uuid);
        if (data == null) {
            return;
        }
        Path file = this.dataFolder.resolve(String.valueOf(uuid) + ".json");
        try (BufferedWriter writer = Files.newBufferedWriter(file, new OpenOption[0]);){
            this.gson.toJson((Object)data, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setHome(UUID uuid, String name, class_243 pos, String dimension) {
        PlayerData data = this.getPlayerData(uuid);
        data.homes.put(name.toLowerCase(Locale.ROOT), new HomeLocation(pos.field_1352, pos.field_1351, pos.field_1350, dimension));
        this.savePlayerData(uuid);
    }

    public HomeLocation getHome(UUID uuid, String name) {
        return this.getPlayerData((UUID)uuid).homes.get(name.toLowerCase(Locale.ROOT));
    }

    public void deleteHome(UUID uuid, String name) {
        PlayerData data = this.getPlayerData(uuid);
        data.homes.remove(name.toLowerCase(Locale.ROOT));
        this.savePlayerData(uuid);
    }

    public Set<String> getHomeNames(UUID uuid) {
        return this.getPlayerData((UUID)uuid).homes.keySet();
    }

    public int getHomesCount(UUID uuid) {
        return this.getPlayerData((UUID)uuid).homes.size();
    }

    public void setLastLocation(UUID uuid, class_243 pos, String dimension) {
        PlayerData data = this.getPlayerData(uuid);
        data.lastLocation = new HomeLocation(pos.field_1352, pos.field_1351, pos.field_1350, dimension);
        this.savePlayerData(uuid);
    }

    public HomeLocation getLastLocation(UUID uuid) {
        return this.getPlayerData((UUID)uuid).lastLocation;
    }

    public void addTpaRequest(UUID requester, UUID target, long timeoutMillis) {
        this.tpaRequests.put(target, new TpaRequest(requester, System.currentTimeMillis(), timeoutMillis));
    }

    public TpaRequest getTpaRequest(UUID target) {
        TpaRequest req = this.tpaRequests.get(target);
        if (req != null && System.currentTimeMillis() - req.timestamp > req.timeoutMillis) {
            this.tpaRequests.remove(target);
            return null;
        }
        return req;
    }

    public void removeTpaRequest(UUID target) {
        this.tpaRequests.remove(target);
    }

    public Long getLastRtpAt(UUID uuid) {
        return this.lastRtpAt.get(uuid);
    }

    public void setLastRtpAt(UUID uuid, long millis) {
        this.lastRtpAt.put(uuid, millis);
    }

    public void scheduleRtp(UUID player, String dimension, double x, double y, double z, long dueAtMillis) {
        this.pendingRtp.put(player, new PendingRtp(player, dimension, x, y, z, dueAtMillis));
    }

    public Set<UUID> getPendingRtpKeysSnapshot() {
        return new HashSet<UUID>(this.pendingRtp.keySet());
    }

    public PendingRtp getPendingRtp(UUID uuid) {
        return this.pendingRtp.get(uuid);
    }

    public void clearPendingRtp(UUID uuid) {
        this.pendingRtp.remove(uuid);
    }

    public PendingRtp popPendingRtp(UUID uuid) {
        return this.pendingRtp.remove(uuid);
    }

    public void scheduleHomeTp(UUID player, String dimension, double x, double y, double z, long dueAtMillis, double startX, double startY, double startZ, double cancelRadius) {
        this.pendingHome.put(player, new PendingHome(player, dimension, x, y, z, dueAtMillis, startX, startY, startZ, cancelRadius));
    }

    public Set<UUID> getPendingHomeKeysSnapshot() {
        return new HashSet<UUID>(this.pendingHome.keySet());
    }

    public PendingHome getPendingHome(UUID uuid) {
        return this.pendingHome.get(uuid);
    }

    public void clearPendingHome(UUID uuid) {
        this.pendingHome.remove(uuid);
    }

    public PendingHome popPendingHome(UUID uuid) {
        return this.pendingHome.remove(uuid);
    }

    public static class PlayerData {
        public Map<String, HomeLocation> homes = new HashMap<String, HomeLocation>();
        public HomeLocation lastLocation;
    }

    public static class HomeLocation {
        public double x;
        public double y;
        public double z;
        public String dimension;

        public HomeLocation() {
        }

        public HomeLocation(double x, double y, double z, String dimension) {
            this.x = x;
            this.y = y;
            this.z = z;
            this.dimension = dimension;
        }
    }

    public static class TpaRequest {
        public UUID requester;
        public long timestamp;
        public long timeoutMillis;

        public TpaRequest() {
        }

        public TpaRequest(UUID requester, long timestamp, long timeoutMillis) {
            this.requester = requester;
            this.timestamp = timestamp;
            this.timeoutMillis = timeoutMillis;
        }
    }

    public static class PendingRtp {
        public UUID player;
        public String dimension;
        public double x;
        public double y;
        public double z;
        public long dueAtMillis;

        public PendingRtp() {
        }

        public PendingRtp(UUID player, String dimension, double x, double y, double z, long dueAtMillis) {
            this.player = player;
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dueAtMillis = dueAtMillis;
        }
    }

    public static class PendingHome {
        public UUID player;
        public String dimension;
        public double x;
        public double y;
        public double z;
        public long dueAtMillis;
        public double startX;
        public double startY;
        public double startZ;
        public double cancelRadius;
        public int lastAnnouncedSeconds = -1;

        public PendingHome() {
        }

        public PendingHome(UUID player, String dimension, double x, double y, double z, long dueAtMillis, double startX, double startY, double startZ, double cancelRadius) {
            this.player = player;
            this.dimension = dimension;
            this.x = x;
            this.y = y;
            this.z = z;
            this.dueAtMillis = dueAtMillis;
            this.startX = startX;
            this.startY = startY;
            this.startZ = startZ;
            this.cancelRadius = cancelRadius;
        }
    }
}

