/*
 * Decompiled with CFR 0.152.
 */
package com.serverutils.perm;

import com.serverutils.ServerUtils;
import com.serverutils.config.ConfigManager;
import net.fabricmc.loader.api.FabricLoader;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.cacheddata.CachedMetaData;
import net.luckperms.api.model.user.User;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class PermissionUtil {
    public static boolean has(class_2168 source, String node, boolean def) {
        if (source.method_9228() == null) {
            return true;
        }
        class_1297 class_12972 = source.method_9228();
        if (class_12972 instanceof class_3222) {
            class_3222 player = (class_3222)class_12972;
            return PermissionUtil.has(player, node, def);
        }
        return source.method_9259(2) || def;
    }

    public static boolean has(class_3222 player, String node, boolean def) {
        if (FabricLoader.getInstance().isModLoaded("luckperms")) {
            try {
                boolean allowed;
                LuckPerms lp = LuckPermsProvider.get();
                User user = lp.getUserManager().getUser(player.method_5667());
                if (user != null && (allowed = user.getCachedData().getPermissionData().checkPermission(node).asBoolean())) {
                    return true;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return player.method_64475(2) || def;
    }

    public static int getMaxHomes(class_3222 player) {
        int ceil;
        ConfigManager.ConfigData cfg;
        block8: {
            cfg = ServerUtils.getConfig().get();
            if (cfg.allowUnlimitedHomesPermission && PermissionUtil.has(player, "serverutils.homes.unlimited", false)) {
                return Integer.MAX_VALUE;
            }
            if (cfg.useLuckPermsMetaForMaxHomes && FabricLoader.getInstance().isModLoaded("luckperms")) {
                try {
                    CachedMetaData meta;
                    String value;
                    LuckPerms lp = LuckPermsProvider.get();
                    User user = lp.getUserManager().getUser(player.method_5667());
                    if (user == null || (value = (meta = user.getCachedData().getMetaData()).getMetaValue("serverutils.homes.max")) == null) break block8;
                    try {
                        int parsed = Integer.parseInt(value);
                        if (parsed >= 0) {
                            return parsed;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (Throwable lp) {
                    // empty catch block
                }
            }
        }
        for (int i = ceil = Math.max(1, cfg.permissionMaxHomesScanCeil); i >= 1; --i) {
            if (!PermissionUtil.has(player, "serverutils.homes.max." + i, false)) continue;
            return i;
        }
        return Math.max(0, cfg.defaultMaxHomes);
    }

    public static int getRtpCooldownSeconds(class_3222 player) {
        ConfigManager.ConfigData cfg;
        block8: {
            cfg = ServerUtils.getConfig().get();
            if (PermissionUtil.has(player, "serverutils.rtp.bypasscooldown", false)) {
                return 0;
            }
            if (FabricLoader.getInstance().isModLoaded("luckperms")) {
                try {
                    CachedMetaData meta;
                    String value;
                    LuckPerms lp = LuckPermsProvider.get();
                    User user = lp.getUserManager().getUser(player.method_5667());
                    if (user == null || (value = (meta = user.getCachedData().getMetaData()).getMetaValue("serverutils.rtp.cooldown")) == null) break block8;
                    try {
                        int parsed = Integer.parseInt(value);
                        if (parsed >= 0) {
                            return parsed;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                catch (Throwable lp) {
                    // empty catch block
                }
            }
        }
        for (int s = 3600; s >= 0; --s) {
            if (!PermissionUtil.has(player, "serverutils.rtp.cooldown." + s, false)) continue;
            return s;
        }
        return Math.max(0, cfg.rtpDefaultCooldownSeconds);
    }
}

