/*
 * Decompiled with CFR 0.152.
 */
package com.shen79.flashlightmod;

import com.shen79.flashlightmod.Constants;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.light.data.AreaLightData;
import foundry.veil.api.client.render.light.data.LightData;
import foundry.veil.api.client.render.light.renderer.LightRenderHandle;
import foundry.veil.api.client.render.light.renderer.LightRenderer;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class Lights {
    private final LightRenderHandle<AreaLightData>[] lights = new LightRenderHandle[4];
    private int tickCounter = 0;

    public Lights() {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getLightRenderer();
        this.lights[0] = lightRenderer.addLight((LightData)new AreaLightData());
        this.lights[1] = lightRenderer.addLight((LightData)new AreaLightData());
        this.lights[2] = lightRenderer.addLight((LightData)new AreaLightData());
        this.lights[3] = lightRenderer.addLight((LightData)new AreaLightData());
        ((AreaLightData)this.lights[0].getLightData()).setSize(1.0, 1.0);
        ((AreaLightData)this.lights[1].getLightData()).setSize(1.0, 1.0);
        ((AreaLightData)this.lights[0].getLightData()).setBrightness(0.5f);
        ((AreaLightData)this.lights[1].getLightData()).setBrightness(0.5f);
        ((AreaLightData)this.lights[2].getLightData()).setAngle(1.0f);
        ((AreaLightData)this.lights[2].getLightData()).setDistance(Constants.distance - Constants.distance / 6.0f);
        ((AreaLightData)this.lights[2].getLightData()).setBrightness(0.4f);
        ((AreaLightData)this.lights[3].getLightData()).setBrightness(-0.5f);
        ((AreaLightData)this.lights[3].getLightData()).setSize((double)0.15f, (double)0.15f);
    }

    private void update(Vector3f pos, float rotX, float rotY) {
        for (LightRenderHandle<AreaLightData> handle : this.lights) {
            AreaLightData light = (AreaLightData)handle.getLightData();
            light.getPosition().set((double)pos.x, (double)pos.y, (double)pos.z);
            light.getOrientation().set((Quaternionfc)new Quaternionf().rotateXYZ((float)Math.toRadians(-rotX), (float)Math.toRadians(rotY), 0.0f));
            light.setDistance(Constants.distance);
            light.setAngle(0.1f);
            light.setSize(0.5, 0.5);
        }
        ((AreaLightData)this.lights[0].getLightData()).setSize((double)0.4f, (double)0.4f);
        ((AreaLightData)this.lights[1].getLightData()).setBrightness(0.5f);
        ((AreaLightData)this.lights[2].getLightData()).setAngle(1.0f);
        ((AreaLightData)this.lights[2].getLightData()).setDistance(Constants.distance - Constants.distance / 6.0f);
        ((AreaLightData)this.lights[2].getLightData()).setBrightness(0.4f);
        ((AreaLightData)this.lights[3].getLightData()).setBrightness(-0.5f);
        ((AreaLightData)this.lights[3].getLightData()).setSize((double)0.15f, (double)0.15f);
    }

    public void tryUpdate(Vector3f pos, float rotX, float rotY, int interval) {
        if (interval <= 1) {
            this.update(pos, rotX, rotY);
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= interval) {
            this.update(pos, rotX, rotY);
            this.tickCounter = 0;
        }
    }

    public void remove() {
        for (LightRenderHandle<AreaLightData> handle : this.lights) {
            handle.free();
        }
    }
}

