/*
 * Decompiled with CFR 0.152.
 */
package com.shen79.flashlightmod;

import com.mojang.logging.LogUtils;
import com.shen79.flashlightmod.FlashlightItem;
import com.shen79.flashlightmod.Lights;
import foundry.veil.api.event.VeilRenderLevelStageEvent;
import foundry.veil.platform.VeilEventPlatform;
import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector3f;
import org.slf4j.Logger;

public class ImmersiveFlashlights {
    public static final String MODID = "flashlightmod";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final RegistrationProvider<Item> ITEMS = RegistrationProvider.get((ResourceKey)Registries.ITEM, (String)"flashlightmod");
    public static final RegistrationProvider<SoundEvent> SOUNDS = RegistrationProvider.get((ResourceKey)Registries.SOUND_EVENT, (String)"flashlightmod");
    public static final RegistryObject<SoundEvent> FLASHLIGHT_TURN_ON = ImmersiveFlashlights.registerSoundEvent("flashlight_on");
    public static final RegistryObject<SoundEvent> FLASHLIGHT_TURN_OFF = ImmersiveFlashlights.registerSoundEvent("flashlight_off");
    public static final RegistryObject<FlashlightItem> FLASHLIGHT = ITEMS.register("flashlight", () -> new FlashlightItem(new Item.Properties().stacksTo(1)));
    private static final HashMap<UUID, Lights> lightMap = new HashMap();
    public static ModelResourceLocation FLASHLIGHT_ON = null;
    public static ModelResourceLocation FLASHLIGHT_OFF = null;

    public static void init() {
    }

    public static void clientInit() {
        VeilEventPlatform.INSTANCE.onVeilRenderLevelStage((stage, levelRenderer, bufferSource, matrixStack, matrix4fc, matrix4fc1, i, deltaTracker, camera, frustum) -> {
            if (stage.equals((Object)VeilRenderLevelStageEvent.Stage.AFTER_WEATHER)) {
                ImmersiveFlashlights.renderEvent(deltaTracker.getGameTimeDeltaPartialTick(false));
            }
        });
    }

    public static void renderEvent(float partialTicks) {
        ArrayList<UUID> removeLights = new ArrayList<UUID>(lightMap.keySet());
        ClientLevel level = Minecraft.getInstance().level;
        for (AbstractClientPlayer player : level.players()) {
            ItemStack stack;
            boolean firstPerson;
            if (!player.getMainHandItem().is((Item)FLASHLIGHT.get()) && !player.getOffhandItem().is((Item)FLASHLIGHT.get())) continue;
            boolean rightHand = true;
            boolean bl = firstPerson = player == Minecraft.getInstance().player && Minecraft.getInstance().options.getCameraType().isFirstPerson();
            if (player.getMainHandItem().is((Item)FLASHLIGHT.get())) {
                stack = player.getMainHandItem();
            } else {
                stack = player.getOffhandItem();
                rightHand = false;
            }
            CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            boolean enabled = false;
            if (data != null) {
                enabled = data.copyTag().getBoolean("enabled");
            }
            if (!enabled) continue;
            Lights lights = lightMap.computeIfAbsent(player.getUUID(), uuid -> new Lights());
            Vec3 forward = ImmersiveFlashlights.rotateY(1.5707963705062866, new Vec3(Math.cos(Math.toRadians(player.getViewYRot(partialTicks))), 0.0, Math.sin(Math.toRadians(player.getViewYRot(partialTicks)))).scale(firstPerson ? -0.5 : 1.0));
            Vec3 pos = player.getPosition(partialTicks).add(0.0, (double)((firstPerson ? 1.35f : 1.0f) - (player.isCrouching() ? 0.3f : 0.0f) - (float)(player.isVisuallyCrawling() ? 1 : 0)), 0.0).add(ImmersiveFlashlights.rotateY(1.5707964f * (float)(rightHand ? -1 : 1) * (float)(firstPerson ? 1 : 0), forward.scale(firstPerson ? 0.3 : 0.8)).add(forward.scale(-0.2)));
            lights.update(new Vector3f((float)pos.x, (float)pos.y, (float)pos.z), player.getViewXRot(partialTicks), player.getViewYRot(partialTicks));
            removeLights.remove(player.getUUID());
        }
        for (UUID uuid2 : removeLights) {
            lightMap.get(uuid2).remove();
            lightMap.remove(uuid2);
        }
    }

    private static RegistryObject<SoundEvent> registerSoundEvent(String name) {
        return SOUNDS.register(ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name), () -> SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name)));
    }

    private static Vec3 rotateY(double angle, Vec3 original) {
        double cos = Math.cos(angle);
        double sin = Math.sin(angle);
        return new Vec3(original.z * sin + original.x * cos, original.y, original.z * cos - original.x * sin);
    }
}

