/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.io.javalin.jetty;

import info.journeymap.shaded.io.javalin.config.PrivateConfig;
import info.journeymap.shaded.io.javalin.http.Context;
import info.journeymap.shaded.io.javalin.http.staticfiles.ResourceHandler;
import info.journeymap.shaded.io.javalin.http.staticfiles.StaticFileConfig;
import info.journeymap.shaded.io.javalin.jetty.CompressingResponseWrapper;
import info.journeymap.shaded.io.javalin.jetty.ConfigurableHandler;
import info.journeymap.shaded.io.javalin.jetty.JettyPrecompressingResourceHandler;
import info.journeymap.shaded.io.javalin.jetty.JettyResourceHandlerKt;
import info.journeymap.shaded.io.javalin.util.JavalinLogger;
import info.journeymap.shaded.kotlin.kotlin.Metadata;
import info.journeymap.shaded.kotlin.kotlin.NoWhenBranchMatchedException;
import info.journeymap.shaded.kotlin.kotlin.Result;
import info.journeymap.shaded.kotlin.kotlin.ResultKt;
import info.journeymap.shaded.kotlin.kotlin.Unit;
import info.journeymap.shaded.kotlin.kotlin.collections.CollectionsKt;
import info.journeymap.shaded.kotlin.kotlin.jvm.functions.Function1;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.Intrinsics;
import info.journeymap.shaded.kotlin.kotlin.jvm.internal.SourceDebugExtension;
import info.journeymap.shaded.kotlin.kotlin.sequences.Sequence;
import info.journeymap.shaded.kotlin.kotlin.sequences.SequencesKt;
import info.journeymap.shaded.kotlin.kotlin.text.StringsKt;
import info.journeymap.shaded.org.eclipse.jetty.io.EofException;
import info.journeymap.shaded.org.eclipse.jetty.server.Request;
import info.journeymap.shaded.org.eclipse.jetty.server.Server;
import info.journeymap.shaded.org.eclipse.jetty.util.resource.Resource;
import info.journeymap.shaded.org.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u000eH\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00070\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0010\u0010!\u001a\u0004\u0018\u00010\u0017*\u0004\u0018\u00010\u0017H\u0002R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0018\u0010\f\u001a\u00020\r*\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Linfo/journeymap/shaded/io/javalin/jetty/JettyResourceHandler;", "Linfo/journeymap/shaded/io/javalin/http/staticfiles/ResourceHandler;", "pvt", "Linfo/journeymap/shaded/io/javalin/config/PrivateConfig;", "(Lio/javalin/config/PrivateConfig;)V", "handlers", "", "Linfo/journeymap/shaded/io/javalin/jetty/ConfigurableHandler;", "lateInitConfigs", "Linfo/journeymap/shaded/io/javalin/http/staticfiles/StaticFileConfig;", "getPvt", "()Lio/javalin/config/PrivateConfig;", "target", "", "Linfo/journeymap/shaded/io/javalin/http/Context;", "getTarget", "(Lio/javalin/http/Context;)Ljava/lang/String;", "addStaticFileConfig", "", "config", "canHandle", "ctx", "fileOrWelcomeFile", "Linfo/journeymap/shaded/org/eclipse/jetty/util/resource/Resource;", "handler", "Linfo/journeymap/shaded/org/eclipse/jetty/server/handler/ResourceHandler;", "handle", "init", "", "nonSkippedHandlers", "Linfo/journeymap/shaded/kotlin/kotlin/sequences/Sequence;", "jettyRequest", "Linfo/journeymap/shaded/org/eclipse/jetty/server/Request;", "fileOrNull", "javalin"})
@SourceDebugExtension(value={"SMAP\nJettyResourceHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JettyResourceHandler.kt\nio/javalin/jetty/JettyResourceHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1549#2:144\n1620#2,3:145\n1247#3,2:148\n1313#3:150\n1314#3:153\n215#4,2:151\n1#5:154\n*S KotlinDebug\n*F\n+ 1 JettyResourceHandler.kt\nio/javalin/jetty/JettyResourceHandler\n*L\n35#1:144\n35#1:145,3\n44#1:148,2\n54#1:150\n54#1:153\n59#1:151,2\n*E\n"})
public final class JettyResourceHandler
implements ResourceHandler {
    @NotNull
    private final PrivateConfig pvt;
    @NotNull
    private final List<StaticFileConfig> lateInitConfigs;
    @NotNull
    private final List<ConfigurableHandler> handlers;

    public JettyResourceHandler(@NotNull PrivateConfig pvt) {
        Intrinsics.checkNotNullParameter(pvt, "pvt");
        this.pvt = pvt;
        this.lateInitConfigs = new ArrayList();
        this.handlers = new ArrayList();
    }

    @NotNull
    public final PrivateConfig getPvt() {
        return this.pvt;
    }

    /*
     * WARNING - void declaration
     */
    public final void init() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = this.lateInitConfigs;
        List<ConfigurableHandler> list = this.handlers;
        boolean $i$f$map = false;
        void var3_4 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            StaticFileConfig staticFileConfig = (StaticFileConfig)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Server server = this.pvt.jetty.server;
            Intrinsics.checkNotNull(server);
            collection.add(new ConfigurableHandler((StaticFileConfig)it, server));
        }
        list.addAll((List)destination$iv$iv);
    }

    @Override
    public boolean addStaticFileConfig(@NotNull StaticFileConfig config) {
        boolean bl;
        Intrinsics.checkNotNullParameter(config, "config");
        Server server = this.pvt.jetty.server;
        boolean bl2 = server != null ? server.isStarted() : false;
        if (bl2) {
            Server server2 = this.pvt.jetty.server;
            Intrinsics.checkNotNull(server2);
            bl = this.handlers.add(new ConfigurableHandler(config, server2));
        } else {
            bl = this.lateInitConfigs.add(config);
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean canHandle(@NotNull Context ctx) {
        boolean bl;
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Request request = JettyResourceHandlerKt.access$jettyReq(ctx);
        Intrinsics.checkNotNullExpressionValue(request, "access$jettyReq(...)");
        Sequence<ConfigurableHandler> $this$any$iv = this.nonSkippedHandlers(request);
        boolean $i$f$any = false;
        Iterator<ConfigurableHandler> iterator2 = $this$any$iv.iterator();
        do {
            ConfigurableHandler element$iv;
            if (!iterator2.hasNext()) return false;
            ConfigurableHandler handler = element$iv = iterator2.next();
            boolean bl2 = false;
            try {
                if (this.fileOrWelcomeFile(handler, this.getTarget(ctx)) != null) {
                    return true;
                }
                boolean bl3 = false;
                bl = bl3;
            }
            catch (Exception e) {
                boolean bl4;
                boolean bl5;
                String string = e.getMessage();
                if (string != null) {
                    if (StringsKt.contains$default((CharSequence)string, "Rejected alias reference", false, 2, null)) {
                        return true;
                    }
                    bl5 = false;
                } else {
                    bl5 = false;
                }
                if (bl5) return true;
                String string2 = e.getMessage();
                if (string2 != null) {
                    if (StringsKt.contains$default((CharSequence)string2, "Failed alias check", false, 2, null)) {
                        return true;
                    }
                    bl4 = false;
                } else {
                    bl4 = false;
                }
                if (bl4) {
                    return true;
                }
                boolean bl6 = false;
                bl = bl6;
            }
        } while (!bl);
        return true;
    }

    @Override
    public boolean handle(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter(ctx, "ctx");
        Request request = JettyResourceHandlerKt.access$jettyReq(ctx);
        Intrinsics.checkNotNullExpressionValue(request, "access$jettyReq(...)");
        Sequence<ConfigurableHandler> $this$forEach$iv = this.nonSkippedHandlers(request);
        boolean $i$f$forEach = false;
        Iterator<ConfigurableHandler> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            ConfigurableHandler element$iv;
            ConfigurableHandler handler = element$iv = iterator2.next();
            boolean bl = false;
            try {
                boolean bl2;
                String target = this.getTarget(ctx);
                Resource fileOrWelcomeFile = this.fileOrWelcomeFile(handler, target);
                if (fileOrWelcomeFile == null) continue;
                Map<String, String> $this$forEach$iv2 = handler.getConfig().headers;
                boolean $i$f$forEach2 = false;
                Object object = $this$forEach$iv2.entrySet().iterator();
                while (object.hasNext()) {
                    Map.Entry<String, String> element$iv2;
                    Map.Entry<String, String> it = element$iv2 = object.next();
                    boolean bl3 = false;
                    ctx.header(it.getKey(), it.getValue());
                }
                boolean bl4 = handler.getConfig().precompress;
                if (bl4) {
                    bl2 = JettyPrecompressingResourceHandler.INSTANCE.handle(target, fileOrWelcomeFile, ctx, this.pvt.compressionStrategy);
                } else if (!bl4) {
                    ctx.res().setContentType(null);
                    JettyResourceHandler jettyResourceHandler = this;
                    try {
                        JettyResourceHandler $this$handle_u24lambda_u244_u24lambda_u243 = jettyResourceHandler;
                        boolean bl5 = false;
                        handler.handle(target, JettyResourceHandlerKt.access$jettyReq(ctx), ctx.req(), new CompressingResponseWrapper(ctx));
                        object = Result.constructor-impl(Unit.INSTANCE);
                    }
                    catch (Throwable throwable) {
                        object = Result.constructor-impl(ResultKt.createFailure(throwable));
                    }
                    bl2 = Result.isSuccess-impl(object);
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                return bl2;
            }
            catch (Exception e) {
                if (e instanceof EofException) continue;
                JavalinLogger.info("Exception occurred while handling static resource", e);
            }
        }
        return false;
    }

    private final Resource fileOrNull(Resource $this$fileOrNull) {
        Resource resource;
        Resource resource2 = $this$fileOrNull;
        if (resource2 != null) {
            Resource resource3;
            Resource it = resource3 = resource2;
            boolean bl = false;
            resource = it.exists() && !it.isDirectory() ? resource3 : null;
        } else {
            resource = null;
        }
        return resource;
    }

    private final Resource fileOrWelcomeFile(info.journeymap.shaded.org.eclipse.jetty.server.handler.ResourceHandler handler, String target) {
        Resource resource = handler.getResource(target);
        if (resource == null || (resource = this.fileOrNull(resource)) == null) {
            Resource resource2 = handler.getResource(StringsKt.removeSuffix(target, (CharSequence)"/") + "/index.html");
            resource = resource2 != null ? this.fileOrNull(resource2) : null;
        }
        return resource;
    }

    private final Sequence<ConfigurableHandler> nonSkippedHandlers(Request jettyRequest) {
        return SequencesKt.filter(CollectionsKt.asSequence((Iterable)this.handlers), (Function1)new Function1<ConfigurableHandler, Boolean>(jettyRequest){
            final /* synthetic */ Request $jettyRequest;
            {
                this.$jettyRequest = $jettyRequest;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull ConfigurableHandler it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it.getConfig().skipFileFunction.invoke(this.$jettyRequest) == false;
            }
        });
    }

    private final String getTarget(Context $this$target) {
        String string = $this$target.req().getRequestURI();
        Intrinsics.checkNotNullExpressionValue(string, "getRequestURI(...)");
        String string2 = $this$target.req().getContextPath();
        Intrinsics.checkNotNullExpressionValue(string2, "getContextPath(...)");
        return StringsKt.removePrefix(string, (CharSequence)string2);
    }
}

