/*
 * Decompiled with CFR 0.152.
 */
package info.journeymap.shaded.org.eclipse.jetty.server.resource;

import info.journeymap.shaded.org.eclipse.jetty.http.HttpContent;
import info.journeymap.shaded.org.eclipse.jetty.server.resource.ByteBufferRangeWriter;
import info.journeymap.shaded.org.eclipse.jetty.server.resource.InputStreamRangeWriter;
import info.journeymap.shaded.org.eclipse.jetty.server.resource.RangeWriter;
import info.journeymap.shaded.org.eclipse.jetty.server.resource.SeekableByteChannelRangeWriter;
import info.journeymap.shaded.org.slf4j.Logger;
import info.journeymap.shaded.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import java.util.Objects;

public class HttpContentRangeWriter {
    private static final Logger LOG = LoggerFactory.getLogger(HttpContentRangeWriter.class);

    public static RangeWriter newRangeWriter(HttpContent content) {
        block7: {
            Objects.requireNonNull(content, "HttpContent");
            ByteBuffer buffer = content.getDirectBuffer();
            if (buffer == null) {
                buffer = content.getIndirectBuffer();
            }
            if (buffer != null) {
                return new ByteBufferRangeWriter(buffer);
            }
            try {
                ReadableByteChannel channel = content.getReadableByteChannel();
                if (channel != null) {
                    if (channel instanceof SeekableByteChannel) {
                        SeekableByteChannel seekableByteChannel = (SeekableByteChannel)channel;
                        return new SeekableByteChannelRangeWriter(seekableByteChannel, () -> (SeekableByteChannel)content.getReadableByteChannel());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Skipping non-SeekableByteChannel option {} from content {}", (Object)channel, (Object)content);
                    }
                    channel.close();
                }
            }
            catch (IOException e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("Skipping ReadableByteChannel option", e);
            }
        }
        return new InputStreamRangeWriter(() -> content.getInputStream());
    }
}

