/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap;

import info.journeymap.shaded.io.javalin.Javalin;
import info.journeymap.shaded.io.javalin.http.staticfiles.Location;
import info.journeymap.shaded.org.slf4j.Logger;
import info.journeymap.shaded.org.slf4j.LoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.io.FileHandler;
import journeymap_webmap.routes.Data;
import journeymap_webmap.routes.Log;
import journeymap_webmap.routes.Polygons;
import journeymap_webmap.routes.Resources;
import journeymap_webmap.routes.Skin;
import journeymap_webmap.routes.Status;
import journeymap_webmap.routes.Tiles;
import journeymap_webmap.routes.Waypoints;
import net.minecraft.resources.ResourceLocation;

public class WebMap {
    public static final Logger logger = LoggerFactory.getLogger("webmap");
    private int port = 0;
    private boolean started = false;
    private Javalin app = null;
    private static WebMap INSTANCE;

    public static WebMap getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new WebMap();
        }
        return INSTANCE;
    }

    public void start() {
        if (!this.started) {
            this.findPort(true);
            this.initialise();
            this.started = true;
            logger.info("WebMap is now listening on port {}", (Object)this.port);
        }
    }

    private void initialise() {
        try {
            this.app = (Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)((Javalin)Javalin.create(config -> {
                String assetsRootProperty = System.getProperty("journeymap.webmap.assets_root", null);
                File testFile = new File("../src/main/resources/assets/journeymap/web");
                if (assetsRootProperty != null) {
                    logger.info("Detected 'journeymap.webmap.assets_root' property, serving static files from: " + assetsRootProperty);
                    config.staticFiles.add(assetsRootProperty, Location.EXTERNAL);
                } else if (testFile.exists()) {
                    try {
                        String assets = testFile.getCanonicalPath();
                        logger.info("Development environment detected, serving static files from the filesystem.: " + assets);
                        config.staticFiles.add(testFile.getCanonicalPath(), Location.EXTERNAL);
                    }
                    catch (IOException e) {
                        logger.error("WebMap error finding local assets path", e);
                    }
                } else {
                    File dir = new File(FileHandler.getMinecraftDirectory(), Constants.WEB_DIR);
                    if (dir.exists()) {
                        dir.delete();
                    }
                    if (!dir.exists()) {
                        logger.info("Attempting to copy web content to {}", (Object)new File(Constants.JOURNEYMAP_DIR, "web"));
                        boolean created = FileHandler.copyResources((File)dir, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"journeymap_webmap", (String)"web"), (String)"", (boolean)false);
                        logger.info("Web content copied successfully: {}", (Object)created);
                    }
                    if (dir.exists()) {
                        logger.info("Loading web content from local: {}", (Object)dir.getPath());
                        config.staticFiles.add(dir.getPath(), Location.EXTERNAL);
                    } else {
                        logger.info("Loading web content from jar: {}", (Object)"/assets/journeymap/web");
                        config.staticFiles.add("/assets/journeymap/web", Location.CLASSPATH);
                    }
                }
            }).before(ctx -> {
                ctx.header("Access-Control-Allow-Origin", "*");
                ctx.header("Cache-Control", "no-cache");
            })).get("/waypoint/{id}/icon", Waypoints::iconGet)).get("/data/{type}", Data::dataGet)).get("/logs", Log::logGet)).get("/polygons", Polygons::polygonsGet)).get("/resources", Resources::resourcesGet)).get("/skin/{uuid}", Skin::skinGet)).get("/status", Status::statusGet)).get("/tiles/tile.png", Tiles::tilesGet);
            this.app.start(this.port);
        }
        catch (Exception e) {
            logger.error("Failed to start server: " + String.valueOf(e));
            this.stop();
        }
    }

    public void stop() {
        if (this.started) {
            if (this.app != null) {
                this.app.stop();
            }
            this.started = false;
            logger.info("WebMap stopped.");
        }
    }

    private void findPort(boolean tryCurrentPort) {
        if (this.port == 0) {
            if (JourneymapClient.getInstance() == null || JourneymapClient.getInstance().getWebMapProperties() == null) {
                this.port = 8080;
            } else {
                String configuredPort = (String)JourneymapClient.getInstance().getWebMapProperties().port.get();
                this.port = configuredPort == null ? 0 : Integer.parseInt(configuredPort);
                logger.info("port found, set to " + this.port);
            }
        }
        if (tryCurrentPort) {
            try {
                socket = new ServerSocket(this.port);
                this.port = socket.getLocalPort();
                socket.close();
            }
            catch (IOException e) {
                logger.warn("Configured port " + this.port + " could not be bound: " + String.valueOf(e));
                this.findPort(false);
            }
            logger.info("Configured port " + this.port + " is available.");
        } else {
            try {
                socket = new ServerSocket(0);
                this.port = socket.getLocalPort();
                socket.close();
                logger.info("New port " + this.port + " assigned by ServerSocket.");
            }
            catch (IOException e) {
                logger.error("Configured port {} could not be bound on second attempt, failing: ", (Object)this.port, (Object)e);
                this.stop();
            }
        }
    }

    public int getPort() {
        return this.port;
    }
}

