/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.journeymap.shaded.io.javalin.http.ContentType;
import info.journeymap.shaded.io.javalin.http.Context;
import java.util.ArrayList;
import java.util.HashMap;
import journeymap.api.client.impl.ClientAPI;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.PolygonOverlay;
import journeymap.api.v2.client.model.MapPolygon;
import journeymap.api.v2.client.util.UIState;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.draw.DrawPolygonStep;
import journeymap.client.render.draw.OverlayDrawStep;
import net.minecraft.core.BlockPos;

public class Polygons {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void polygonsGet(Context ctx) {
        ArrayList<3> data = new ArrayList<3>();
        ArrayList steps = new ArrayList();
        UIState fullscreenState = ClientAPI.INSTANCE.getUIState(Context.UI.Fullscreen);
        UIState minimapState = ClientAPI.INSTANCE.getUIState(Context.UI.Minimap);
        UIState uiState = fullscreenState != null && !fullscreenState.active && minimapState != null && minimapState.active ? minimapState : fullscreenState;
        ClientAPI.INSTANCE.getDrawSteps(steps, uiState);
        for (OverlayDrawStep overlayDrawStep : steps) {
            if (!(overlayDrawStep instanceof DrawPolygonStep)) continue;
            final DrawPolygonStep step = (DrawPolygonStep)overlayDrawStep;
            final PolygonOverlay polygon = (PolygonOverlay)step.getOverlay();
            final ArrayList<1> points = new ArrayList<1>();
            final String label = polygon.getLabel();
            final int fontColor = polygon.getTextProperties() != null ? polygon.getTextProperties().getColor() : 0;
            for (final BlockPos point : polygon.getOuterArea().getPoints()) {
                points.add(new HashMap<String, Integer>(){
                    {
                        this.put("x", point.getX());
                        this.put("y", point.getY());
                        this.put("z", point.getZ());
                    }
                });
            }
            final ArrayList holes = new ArrayList();
            if (polygon.getHoles() != null) {
                for (MapPolygon hole : polygon.getHoles()) {
                    ArrayList<2> holePoints = new ArrayList<2>();
                    for (final BlockPos holePoint : hole.getPoints()) {
                        holePoints.add(new HashMap<String, Integer>(){
                            {
                                this.put("x", holePoint.getX());
                                this.put("y", holePoint.getY());
                                this.put("z", holePoint.getZ());
                            }
                        });
                    }
                    holes.add(holePoints);
                }
            }
            data.add(new HashMap<Object, Object>(){
                {
                    this.put("fillColor", RGB.toHexString((Integer)polygon.getShapeProperties().getFillColor()));
                    this.put("fillOpacity", Float.valueOf(polygon.getShapeProperties().getFillOpacity()));
                    this.put("strokeColor", RGB.toHexString((Integer)polygon.getShapeProperties().getStrokeColor()));
                    this.put("strokeOpacity", Float.valueOf(polygon.getShapeProperties().getStrokeOpacity()));
                    this.put("strokeWidth", Float.valueOf(polygon.getShapeProperties().getStrokeWidth()));
                    this.put("imageLocation", step.getTextureResource() != null ? step.getTextureResource().toString() : "");
                    this.put("texturePositionX", polygon.getShapeProperties().getTexturePositionX());
                    this.put("texturePositionY", polygon.getShapeProperties().getTexturePositionY());
                    this.put("textureScaleX", polygon.getShapeProperties().getTextureScaleX());
                    this.put("textureScaleY", polygon.getShapeProperties().getTextureScaleY());
                    this.put("fontColor", RGB.toHexString((Integer)fontColor));
                    this.put("label", label);
                    this.put("holes", holes);
                    this.put("points", points);
                }
            });
        }
        ctx.contentType(ContentType.APPLICATION_JSON);
        ctx.result(GSON.toJson(data));
    }
}

