/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import info.journeymap.shaded.io.javalin.http.ContentType;
import info.journeymap.shaded.io.javalin.http.Context;
import java.util.HashMap;
import journeymap.client.JourneymapClient;
import journeymap.client.model.MapState;
import journeymap.client.ui.minimap.MiniMap;
import journeymap_webmap.WebmapStatus;
import net.minecraft.client.Minecraft;

public class Status {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void statusGet(Context ctx) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        WebmapStatus status = Minecraft.getInstance().level == null ? WebmapStatus.NO_WORLD : (JourneymapClient.getInstance().isMapping() == false ? WebmapStatus.STARTING : WebmapStatus.READY);
        if (status == WebmapStatus.READY) {
            MapState mapState = MiniMap.state();
            data.put("mapType", mapState.getMapType().name());
            HashMap<String, Boolean> allowedMapTypes = new HashMap<String, Boolean>();
            allowedMapTypes.put("cave", mapState.isCaveMappingAllowed() && mapState.isCaveMappingEnabled());
            allowedMapTypes.put("surface", mapState.isSurfaceMappingAllowed());
            allowedMapTypes.put("topo", mapState.isTopoMappingAllowed());
            if (allowedMapTypes.values().stream().noneMatch(Boolean::booleanValue)) {
                status = WebmapStatus.DISABLED;
            }
            data.put("allowedMapTypes", allowedMapTypes);
        }
        data.put("status", status.getStatus());
        ctx.contentType(ContentType.APPLICATION_JSON);
        ctx.result(GSON.toJson(data));
    }
}

