/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.javalin.http.ContentType;
import io.javalin.http.Context;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import journeymap.client.data.DataCache;
import journeymap.client.data.ImagesData;
import journeymap.client.model.entity.EntityDTO;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import org.apache.logging.log4j.Logger;

public class Data {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setExclusionStrategies(new ExclusionStrategy[]{new EntityDTO.EntityDTOExclusionStrategy()}).create();
    private static final Logger logger = Journeymap.getLogger((String)"webmap/routes/data");
    private static final List<String> dataTypesRequiringSince = List.of("all", "images");

    public static void dataGet(Context ctx) {
        String since = ctx.queryParam("images.since") != null ? ctx.queryParam("images.since") : null;
        String type = ctx.pathParam("type");
        if (dataTypesRequiringSince.contains(type) && since == null) {
            logger.warn("Data type '{}' requested without 'images.since' parameter", (Object)type);
            ctx.status(400);
            ctx.result("Data type '" + type + "' requires 'images.since' parameter.");
            return;
        }
        long sinceTime = since == null ? 0L : Long.parseLong(since);
        HashMap<String, ClientWaypointImpl> data = null;
        switch (type) {
            case "all": {
                data = DataCache.INSTANCE.getAll(sinceTime);
                break;
            }
            case "ambient": {
                data = DataCache.INSTANCE.getAmbientCreatures(false);
                break;
            }
            case "animals": {
                data = DataCache.INSTANCE.getAnimals(false);
                break;
            }
            case "mobs": {
                data = DataCache.INSTANCE.getMobs(false);
                break;
            }
            case "images": {
                data = new ImagesData(Long.valueOf(Long.parseLong(since)));
                break;
            }
            case "player": {
                data = DataCache.INSTANCE.getPlayer(false);
                break;
            }
            case "players": {
                data = DataCache.INSTANCE.getPlayers(false);
                break;
            }
            case "world": {
                data = DataCache.INSTANCE.getWorld(false);
                break;
            }
            case "villagers": {
                data = DataCache.INSTANCE.getVillagers(false);
                break;
            }
            case "waypoints": {
                Collection holders = DataCache.INSTANCE.getWaypoints(false);
                HashMap<String, ClientWaypointImpl> wpMap = new HashMap<String, ClientWaypointImpl>();
                for (ClientWaypointImpl holder : holders) {
                    wpMap.put(holder.getId(), holder);
                }
                data = wpMap;
                break;
            }
            default: {
                logger.warn("Unknown data type '{}'", (Object)type);
                ctx.status(400);
                ctx.result("Unknown data type '" + type + "'");
                return;
            }
        }
        if (data == null) {
            logger.warn("Unknown data type '{}'", (Object)type);
            ctx.status(400);
            ctx.result("Unknown data type '" + type + "'");
            return;
        }
        ctx.contentType(ContentType.APPLICATION_JSON);
        ctx.result(GSON.toJson((Object)data));
    }
}

