/*
 * Decompiled with CFR 0.152.
 */
package journeymap_webmap.routes;

import io.javalin.http.Context;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.util.Arrays;
import java.util.List;
import javax.imageio.IIOException;
import journeymap.client.JourneymapClient;
import journeymap.client.render.draw.MobIconCache;
import journeymap.client.texture.TextureCache;
import journeymap.common.Journeymap;
import journeymap_webmap.Constants;
import net.minecraft.class_1011;
import net.minecraft.class_1043;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.apache.logging.log4j.Logger;
import org.eclipse.jetty.io.EofException;

public class Resources {
    private static final Logger logger = Journeymap.getLogger((String)"webmap/routes/resources");
    private static final List<String> ALLOWED_EXTENSIONS = Arrays.asList("png");

    public static void resourcesGet(Context ctx) {
        class_1011 img;
        String extension;
        String resource = ctx.queryParam("resource");
        class_2960 identifier = resource != null ? class_2960.method_60654((String)resource) : null;
        boolean close = false;
        String string = extension = resource != null ? resource.substring(resource.lastIndexOf(46) + 1) : null;
        if (class_310.method_1551().field_1687 == null || !JourneymapClient.getInstance().isMapping().booleanValue() || resource == null || "undefined".equals(resource)) {
            ctx.result("");
            return;
        }
        if (extension != null && extension.contains(":")) {
            extension = extension.split(":")[0];
        }
        if ("fake".equals(identifier != null ? identifier.method_12836() : null)) {
            img = ((class_1043)TextureCache.getTexture((class_2960)identifier)).method_4525();
        } else {
            try {
                img = MobIconCache.getWebMapIcon((class_2960)identifier).method_4525();
                if (img == null) {
                    close = true;
                    img = class_1011.method_4309((InputStream)Constants.getResourceAsStream(identifier));
                }
            }
            catch (FileNotFoundException | NullPointerException e) {
                logger.warn("File at resource location not found: {}", (Object)resource);
                ctx.status(404);
                close = true;
                img = Resources.getDefaultImage();
            }
            catch (IIOException | EofException e) {
                logger.info("Connection closed while writing image response. WebMap probably reloaded.");
                ctx.result("");
                return;
            }
            catch (Exception e) {
                logger.error("Exception thrown while retrieving resource at location: {}", (Object)resource, (Object)e);
                ctx.status(500);
                close = true;
                img = Resources.getDefaultImage();
            }
        }
        ctx.contentType("image/" + extension);
        if (img != null && img.field_4988 > 0L) {
            try {
                img.method_24032(Channels.newChannel((OutputStream)ctx.outputStream()));
                ctx.outputStream().flush();
            }
            catch (Exception e) {
                logger.warn("image not found {}", (Object)resource);
            }
            if (close) {
                img.close();
            }
        }
    }

    private static class_1011 getDefaultImage() {
        try {
            class_1011 img = class_1011.method_4309((InputStream)Resources.class.getResource("/assets/journeymap/ui/img/marker-dot-160.png").openStream());
            return img;
        }
        catch (IOException e) {
            return null;
        }
    }
}

