/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity;

import com.benbenlaw.casting.block.custom.ControllerBlock;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.EquipmentModifierBlockEntity;
import com.benbenlaw.casting.block.entity.MixerBlockEntity;
import com.benbenlaw.casting.block.entity.SolidifierBlockEntity;
import com.benbenlaw.casting.block.entity.TankBlockEntity;
import com.benbenlaw.casting.recipe.FuelRecipe;
import com.benbenlaw.casting.recipe.MeltingRecipe;
import com.benbenlaw.casting.screen.SmelterMenu;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControllerBlockEntity
extends BlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(16){

        protected void onContentsChanged(int slot) {
            ControllerBlockEntity.this.setChanged();
            ControllerBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot >= 0 && slot <= 14) {
                return 1;
            }
            return 64;
        }

        public int getSlotLimit(int slot) {
            if (slot >= 0 && slot <= 14) {
                return 1;
            }
            return 64;
        }
    };
    public final FluidTank TANK_1 = new FluidTank(16000){

        protected void onContentsChanged() {
            ControllerBlockEntity.this.setChanged();
            ControllerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_2 = new FluidTank(16000){

        protected void onContentsChanged() {
            ControllerBlockEntity.this.setChanged();
            ControllerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_3 = new FluidTank(16000){

        protected void onContentsChanged() {
            ControllerBlockEntity.this.setChanged();
            ControllerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_4 = new FluidTank(16000){

        protected void onContentsChanged() {
            ControllerBlockEntity.this.setChanged();
            ControllerBlockEntity.this.sync();
        }
    };
    private final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 4;
        }

        @NotNull
        public FluidStack getFluidInTank(int tank) {
            return switch (tank) {
                case 0 -> ControllerBlockEntity.this.TANK_1.getFluid();
                case 1 -> ControllerBlockEntity.this.TANK_2.getFluid();
                case 2 -> ControllerBlockEntity.this.TANK_3.getFluid();
                case 3 -> ControllerBlockEntity.this.TANK_4.getFluid();
                default -> FluidStack.EMPTY;
            };
        }

        public int getTankCapacity(int tank) {
            if (tank == 0) {
                return ControllerBlockEntity.this.TANK_1.getCapacity();
            }
            if (tank == 1) {
                return ControllerBlockEntity.this.TANK_2.getCapacity();
            }
            if (tank == 2) {
                return ControllerBlockEntity.this.TANK_3.getCapacity();
            }
            if (tank == 3) {
                return ControllerBlockEntity.this.TANK_4.getCapacity();
            }
            return 0;
        }

        public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
            if (tank == 0) {
                return ControllerBlockEntity.this.TANK_1.isFluidValid(stack);
            }
            if (tank == 1) {
                return ControllerBlockEntity.this.TANK_2.isFluidValid(stack);
            }
            if (tank == 2) {
                return ControllerBlockEntity.this.TANK_3.isFluidValid(stack);
            }
            if (tank == 3) {
                return ControllerBlockEntity.this.TANK_4.isFluidValid(stack);
            }
            return false;
        }

        public int fill(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_1.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_1.fill(resource, action);
            }
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_2.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_2.fill(resource, action);
            }
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_3.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_3.fill(resource, action);
            }
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_4.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_4.fill(resource, action);
            }
            return 0;
        }

        @NotNull
        public FluidStack drain(FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_1.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_1.drain(resource.getAmount(), action);
            }
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_2.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_2.drain(resource.getAmount(), action);
            }
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_3.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_3.drain(resource.getAmount(), action);
            }
            if (resource.getFluid() == ControllerBlockEntity.this.TANK_4.getFluid().getFluid()) {
                return ControllerBlockEntity.this.TANK_4.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        @NotNull
        public FluidStack drain(int maxDrain, @NotNull IFluidHandler.FluidAction action) {
            assert (ControllerBlockEntity.this.level != null);
            if (ControllerBlockEntity.this.TANK_1.getFluidAmount() > 0) {
                return ControllerBlockEntity.this.TANK_1.drain(maxDrain, action);
            }
            if (ControllerBlockEntity.this.TANK_2.getFluidAmount() > 0) {
                return ControllerBlockEntity.this.TANK_2.drain(maxDrain, action);
            }
            if (ControllerBlockEntity.this.TANK_3.getFluidAmount() > 0) {
                return ControllerBlockEntity.this.TANK_3.drain(maxDrain, action);
            }
            if (ControllerBlockEntity.this.TANK_4.getFluidAmount() > 0) {
                return ControllerBlockEntity.this.TANK_4.drain(maxDrain, action);
            }
            return FluidStack.EMPTY;
        }
    };
    public final ContainerData data;
    public int[] progress = new int[15];
    public int[] maxProgress = new int[15];
    public int fuelTemp = 0;
    private final IItemHandler controllerItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i != 15, i -> i == 1);

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public void getOutputFluidStack1(FluidStack stack) {
        this.TANK_1.setFluid(stack);
    }

    public void setOutputFluid1(FluidStack stack) {
        this.TANK_1.setFluid(stack);
    }

    public FluidStack getOutputFluid1() {
        return this.TANK_1.getFluid();
    }

    public void getOutputFluidStack2(FluidStack stack) {
        this.TANK_2.setFluid(stack);
    }

    public void setOutputFluid2(FluidStack stack) {
        this.TANK_2.setFluid(stack);
    }

    public FluidStack getOutputFluid2() {
        return this.TANK_2.getFluid();
    }

    public void getOutputFluidStack3(FluidStack stack) {
        this.TANK_3.setFluid(stack);
    }

    public void setOutputFluid3(FluidStack stack) {
        this.TANK_3.setFluid(stack);
    }

    public FluidStack getOutputFluid3() {
        return this.TANK_3.getFluid();
    }

    public void getOutputFluidStack4(FluidStack stack) {
        this.TANK_4.setFluid(stack);
    }

    public void setOutputFluid4(FluidStack stack) {
        this.TANK_4.setFluid(stack);
    }

    public FluidStack getOutputFluid4() {
        return this.TANK_4.getFluid();
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.controllerItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public ControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.CONTROLLER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                if (index < 15) {
                    return ControllerBlockEntity.this.progress[index];
                }
                if (index == 15) {
                    return ControllerBlockEntity.this.maxProgress[index - 15];
                }
                return 0;
            }

            public void set(int index, int value) {
                if (index < 15) {
                    ControllerBlockEntity.this.progress[index] = value;
                } else if (index == 15) {
                    ControllerBlockEntity.this.maxProgress[index - 15] = value;
                }
            }

            public int getCount() {
                return 16;
            }
        };
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.casting.controller");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new SmelterMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putIntArray("progress", this.progress);
        compoundTag.putIntArray("maxProgress", this.maxProgress);
        compoundTag.putInt("fuelTemp", this.fuelTemp);
        compoundTag.put("tank1", (Tag)this.TANK_1.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank2", (Tag)this.TANK_2.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank3", (Tag)this.TANK_3.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank4", (Tag)this.TANK_4.writeToNBT(provider, new CompoundTag()));
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getIntArray("progress");
        this.maxProgress = compoundTag.getIntArray("maxProgress");
        this.fuelTemp = compoundTag.getInt("fuelTemp");
        this.TANK_1.readFromNBT(provider, compoundTag.getCompound("tank1"));
        this.TANK_2.readFromNBT(provider, compoundTag.getCompound("tank2"));
        this.TANK_3.readFromNBT(provider, compoundTag.getCompound("tank3"));
        this.TANK_4.readFromNBT(provider, compoundTag.getCompound("tank4"));
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public void tick() {
        assert (this.level != null);
        if (this.level.isClientSide()) {
            return;
        }
        RecipeInput inventory = new RecipeInput(){

            public ItemStack getItem(int index) {
                return ControllerBlockEntity.this.itemHandler.getStackInSlot(index);
            }

            public int size() {
                return ControllerBlockEntity.this.itemHandler.getSlots();
            }
        };
        if (this.level.getGameTime() % 20L == 0L) {
            this.drainTanksIntoValidBlocks();
            this.fuelInformation(this.level.getBlockEntity(this.worldPosition));
        }
        boolean isPowered = false;
        boolean powerStateChanged = false;
        List recipes = this.level.getRecipeManager().getRecipesFor((RecipeType)MeltingRecipe.Type.INSTANCE, inventory, this.level);
        for (int i = 0; i < 15; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.isEmpty()) {
                this.resetProgress(i);
                continue;
            }
            RecipeHolder match = recipes.stream().filter(r -> ((MeltingRecipe)r.value()).input().test(stack)).findFirst().orElse(null);
            if (match == null) {
                this.resetProgress(i);
                continue;
            }
            FluidStack output = ((MeltingRecipe)match.value()).output();
            if (!this.canFitFluidInAnyTank(output) || !this.hasEnoughFuel(this.level.getBlockEntity(this.worldPosition), ((MeltingRecipe)match.value()).meltingTemp())) {
                this.resetProgress(i);
                continue;
            }
            isPowered = true;
            this.maxProgress[i] = this.setNewMaxProgress(this.fuelTemp, ((MeltingRecipe)match.value()).meltingTemp());
            int n = i;
            this.progress[n] = this.progress[n] + 1;
            if (this.progress[i] < this.maxProgress[i]) continue;
            int outputAmount = output.getAmount();
            if (stack.isDamageableItem()) {
                float modifier = (float)(stack.getMaxDamage() - stack.getDamageValue()) / (float)stack.getMaxDamage();
                outputAmount = Math.round((float)outputAmount * modifier);
            }
            stack.shrink(1);
            this.addFluidToTank(output, outputAmount);
            this.useFuel(this);
            this.resetProgress(i);
            this.setChanged();
            this.sync();
        }
        BlockState currentState = this.level.getBlockState(this.worldPosition);
        boolean currentPowered = (Boolean)currentState.getValue((Property)ControllerBlock.POWERED);
        if (currentPowered != isPowered) {
            this.level.setBlockAndUpdate(this.worldPosition, (BlockState)currentState.setValue((Property)ControllerBlock.POWERED, (Comparable)Boolean.valueOf(isPowered)));
            this.sync();
        }
    }

    private void drainTanksIntoValidBlocks() {
        BlockEntity entity;
        for (Direction direction : Direction.values()) {
            entity = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (!(entity instanceof SolidifierBlockEntity)) continue;
            SolidifierBlockEntity solidifierBlockEntity = (SolidifierBlockEntity)entity;
            this.transferFluidToTank((IFluidTank)this.TANK_1, (IFluidTank)solidifierBlockEntity.TANK);
            this.transferFluidToTank((IFluidTank)this.TANK_2, (IFluidTank)solidifierBlockEntity.TANK);
            this.transferFluidToTank((IFluidTank)this.TANK_3, (IFluidTank)solidifierBlockEntity.TANK);
            this.transferFluidToTank((IFluidTank)this.TANK_4, (IFluidTank)solidifierBlockEntity.TANK);
        }
        for (Direction direction : Direction.values()) {
            entity = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (!(entity instanceof EquipmentModifierBlockEntity)) continue;
            EquipmentModifierBlockEntity toolModifierBlockEntity = (EquipmentModifierBlockEntity)entity;
            this.transferFluidToTank((IFluidTank)this.TANK_1, (IFluidTank)toolModifierBlockEntity.TANK);
            this.transferFluidToTank((IFluidTank)this.TANK_2, (IFluidTank)toolModifierBlockEntity.TANK);
            this.transferFluidToTank((IFluidTank)this.TANK_3, (IFluidTank)toolModifierBlockEntity.TANK);
            this.transferFluidToTank((IFluidTank)this.TANK_4, (IFluidTank)toolModifierBlockEntity.TANK);
        }
        for (Direction direction : Direction.values()) {
            entity = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (!(entity instanceof MixerBlockEntity)) continue;
            MixerBlockEntity mixerBlockEntity = (MixerBlockEntity)entity;
            this.transferFluidToMixer((IFluidTank)this.TANK_1, mixerBlockEntity);
            this.transferFluidToMixer((IFluidTank)this.TANK_2, mixerBlockEntity);
            this.transferFluidToMixer((IFluidTank)this.TANK_3, mixerBlockEntity);
            this.transferFluidToMixer((IFluidTank)this.TANK_4, mixerBlockEntity);
        }
    }

    private void resetProgress(int slot) {
        this.progress[slot] = 0;
    }

    private void addFluidToTank(FluidStack output, int amount) {
        if (this.TANK_1.getFluid().getFluid() == output.getFluid() && this.TANK_1.getCapacity() - this.TANK_1.getFluidAmount() >= output.getAmount()) {
            this.TANK_1.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_2.getFluid().getFluid() == output.getFluid() && this.TANK_2.getCapacity() - this.TANK_2.getFluidAmount() >= output.getAmount()) {
            this.TANK_2.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_3.getFluid().getFluid() == output.getFluid() && this.TANK_3.getCapacity() - this.TANK_3.getFluidAmount() >= output.getAmount()) {
            this.TANK_3.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_4.getFluid().getFluid() == output.getFluid() && this.TANK_4.getCapacity() - this.TANK_4.getFluidAmount() >= output.getAmount()) {
            this.TANK_4.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_1.getFluid().isEmpty()) {
            this.TANK_1.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_2.getFluid().isEmpty()) {
            this.TANK_2.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_3.getFluid().isEmpty()) {
            this.TANK_3.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        } else if (this.TANK_4.getFluid().isEmpty()) {
            this.TANK_4.fill(new FluidStack(output.getFluid(), amount), IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean canFitFluidInAnyTank(FluidStack output) {
        boolean fluidAlreadyInTank;
        boolean bl = fluidAlreadyInTank = this.TANK_1.getFluid().getFluid() == output.getFluid() || this.TANK_2.getFluid().getFluid() == output.getFluid() || this.TANK_3.getFluid().getFluid() == output.getFluid() || this.TANK_4.getFluid().getFluid() == output.getFluid();
        if (fluidAlreadyInTank) {
            return this.TANK_1.getFluid().getFluid() == output.getFluid() && this.TANK_1.getCapacity() - this.TANK_1.getFluidAmount() >= output.getAmount() || this.TANK_2.getFluid().getFluid() == output.getFluid() && this.TANK_2.getCapacity() - this.TANK_2.getFluidAmount() >= output.getAmount() || this.TANK_3.getFluid().getFluid() == output.getFluid() && this.TANK_3.getCapacity() - this.TANK_3.getFluidAmount() >= output.getAmount() || this.TANK_4.getFluid().getFluid() == output.getFluid() && this.TANK_4.getCapacity() - this.TANK_4.getFluidAmount() >= output.getAmount();
        }
        return this.TANK_1.getFluid().isEmpty() || this.TANK_1.getFluid().getFluid() == output.getFluid() && this.TANK_1.getCapacity() - this.TANK_1.getFluidAmount() >= output.getAmount() || this.TANK_2.getFluid().isEmpty() || this.TANK_2.getFluid().getFluid() == output.getFluid() && this.TANK_2.getCapacity() - this.TANK_2.getFluidAmount() >= output.getAmount() || this.TANK_3.getFluid().isEmpty() || this.TANK_3.getFluid().getFluid() == output.getFluid() && this.TANK_3.getCapacity() - this.TANK_3.getFluidAmount() >= output.getAmount() || this.TANK_4.getFluid().isEmpty() || this.TANK_4.getFluid().getFluid() == output.getFluid() && this.TANK_4.getCapacity() - this.TANK_4.getFluidAmount() >= output.getAmount();
    }

    private void useFuel(BlockEntity entity) {
        if (entity == null) {
            return;
        }
        Level level = entity.getLevel();
        if (level != null) {
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.getBlockEntity(entity.getBlockPos().relative(direction));
                if (!(adjacentEntity instanceof TankBlockEntity)) continue;
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                List allFuels = level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
                for (RecipeHolder recipeHolder : allFuels) {
                    FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                    if (recipe.fluid().getFluid() != tankBlockEntity.FLUID_TANK.getFluid().getFluid() || tankBlockEntity.FLUID_TANK.getFluidAmount() < recipe.fluid().getAmount()) continue;
                    tankBlockEntity.FLUID_TANK.drain(recipe.fluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
                }
            }
        }
    }

    private boolean hasEnoughFuel(BlockEntity entity, int temp) {
        if (entity == null) {
            return false;
        }
        Level level = entity.getLevel();
        if (level != null) {
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.getBlockEntity(entity.getBlockPos().relative(direction));
                if (!(adjacentEntity instanceof TankBlockEntity)) continue;
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                List allFuels = level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
                for (RecipeHolder recipeHolder : allFuels) {
                    FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                    if (recipe.fluid().getFluid() != tankBlockEntity.FLUID_TANK.getFluid().getFluid() || recipe.temp() < temp) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void transferFluidToTank(IFluidTank sourceTank, IFluidTank targetTank) {
        if (sourceTank.getFluidAmount() > 0) {
            FluidStack fluidInSource = sourceTank.getFluid();
            if (targetTank.getFluidAmount() > 0 ? !FluidStack.isSameFluidSameComponents((FluidStack)targetTank.getFluid(), (FluidStack)fluidInSource) : !targetTank.isFluidValid(fluidInSource)) {
                return;
            }
            int drainAmount = sourceTank.getFluidAmount();
            FluidStack drained = sourceTank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            int filled = targetTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            sourceTank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private void transferFluidToMixer(IFluidTank sourceTank, MixerBlockEntity mixerBlockEntity) {
        if (sourceTank.getFluidAmount() > 0) {
            IFluidTank[] mixerTanks;
            FluidStack fluidInSource = sourceTank.getFluid();
            for (IFluidTank mixerTank : mixerTanks = new IFluidTank[]{mixerBlockEntity.TANK_1, mixerBlockEntity.TANK_2, mixerBlockEntity.TANK_3, mixerBlockEntity.TANK_4, mixerBlockEntity.TANK_5, mixerBlockEntity.TANK_6}) {
                if (!FluidStack.isSameFluidSameComponents((FluidStack)mixerTank.getFluid(), (FluidStack)fluidInSource)) continue;
                if (mixerTank.getCapacity() > mixerTank.getFluidAmount()) {
                    int spaceLeftInTank = mixerTank.getCapacity() - mixerTank.getFluidAmount();
                    int drainAmount = Math.min(sourceTank.getFluidAmount(), spaceLeftInTank);
                    FluidStack drained = sourceTank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                    if (FluidStack.isSameFluidSameComponents((FluidStack)drained, (FluidStack)fluidInSource)) {
                        int filled = mixerTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                        sourceTank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                    }
                }
                return;
            }
            for (IFluidTank mixerTank : mixerTanks) {
                if (mixerTank.getFluidAmount() != 0) continue;
                int drainAmount = Math.min(sourceTank.getFluidAmount(), mixerTank.getCapacity());
                FluidStack drained = sourceTank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
                if (FluidStack.isSameFluidSameComponents((FluidStack)drained, (FluidStack)fluidInSource)) {
                    int filled = mixerTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
                    sourceTank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
                }
                return;
            }
        }
    }

    private void fuelInformation(BlockEntity entity) {
        if (entity == null) {
            return;
        }
        Level level = entity.getLevel();
        if (level != null && !level.isClientSide()) {
            boolean foundFuel = false;
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.getBlockEntity(entity.getBlockPos().relative(direction));
                if (!(adjacentEntity instanceof TankBlockEntity)) continue;
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                List allFuels = level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
                for (RecipeHolder recipeHolder : allFuels) {
                    FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                    if (recipe.fluid().getFluid() != tankBlockEntity.FLUID_TANK.getFluid().getFluid()) continue;
                    this.fuelTemp = recipe.temp();
                    foundFuel = true;
                    break;
                }
                if (foundFuel) break;
            }
            if (!foundFuel) {
                this.fuelTemp = 0;
            }
        }
    }

    private int setNewMaxProgress(int fuelInTankTemp, int recipeTemp) {
        if (recipeTemp <= 0) {
            throw new IllegalArgumentException("recipeTemp must be greater than zero");
        }
        if (fuelInTankTemp < recipeTemp) {
            return 10000;
        }
        double temperatureRatio = (double)fuelInTankTemp / (double)recipeTemp;
        int newMaxProgress = (int)(240.0 / temperatureRatio);
        return Math.max(newMaxProgress, 1);
    }
}

