/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.multiblock;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockCoolantTankBlockEntity;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockFuelTankBlockEntity;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockMixerBlockEntity;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockSolidifierBlockEntity;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockValveBlockEntity;
import com.benbenlaw.casting.block.multiblock.MultiblockControllerBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockSolidifierBlock;
import com.benbenlaw.casting.config.CastingConfig;
import com.benbenlaw.casting.multiblock.CoreMultiblockDetector;
import com.benbenlaw.casting.multiblock.MultiblockData;
import com.benbenlaw.casting.recipe.FuelRecipe;
import com.benbenlaw.casting.recipe.MeltingRecipe;
import com.benbenlaw.casting.screen.multiblock.MultiblockControllerMenu;
import com.benbenlaw.casting.util.CastingTags;
import com.benbenlaw.casting.util.FilteredItemHandler;
import com.benbenlaw.casting.util.MultiFluidTankSharedCapacity;
import com.benbenlaw.casting.util.SingleFluidTank;
import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockControllerBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    public final Map<Integer, Item> allowedItems = new HashMap<Integer, Item>();
    public final FilteredItemHandler itemHandler = new FilteredItemHandler(60, this.allowedItems){

        protected void onContentsChanged(int slot) {
            MultiblockControllerBlockEntity.this.setChanged();
            MultiblockControllerBlockEntity.this.resetProgress(slot);
            MultiblockControllerBlockEntity.this.sync();
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            return 1;
        }
    };
    public int TOTAL_FLUID_TANK_CAPACITY = 1000000;
    public MultiFluidTankSharedCapacity fluidHandler = new MultiFluidTankSharedCapacity(this.TOTAL_FLUID_TANK_CAPACITY){

        @Override
        protected void onContentsChanged() {
            MultiblockControllerBlockEntity.this.setChanged();
        }
    };
    public final ContainerData data;
    public int[] progress = new int[60];
    public int[] maxProgress = new int[60];
    public int CONTROLLER_MAX_PROGRESS = 1000;
    public String errorMessage = "";
    public int enabledSlots;
    private int tickCounter = 0;
    private int fuelTemp = 0;
    public boolean structureValid;
    public boolean working;
    public MultiblockData cachedMultiblockData = null;
    public SingleFluidTank fuelTank;
    public SingleFluidTank coolantTank;
    private final IItemHandler controllerItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i < this.enabledSlots, i -> false);

    public void setAllowedItems(int slot, Item item) {
        if (item == null) {
            this.allowedItems.remove(slot);
        } else {
            this.allowedItems.put(slot, item);
        }
    }

    @Nullable
    public Item getAllowedItem(int slot) {
        return this.allowedItems.get(slot);
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.controllerItemHandler;
    }

    public void setHandler(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, itemStackHandler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public MultiblockControllerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.MULTIBLOCK_CONTROLLER_BLOCK_ENTITY.get(), pos, state);
        this.fuelTank = new SingleFluidTank(1000);
        this.coolantTank = new SingleFluidTank(1000);
        this.data = new ContainerData(){

            public int get(int index) {
                if (index < 60) {
                    return MultiblockControllerBlockEntity.this.progress[index];
                }
                if (index == 60) {
                    return MultiblockControllerBlockEntity.this.maxProgress[index - 60];
                }
                return 0;
            }

            public void set(int index, int value) {
                if (index < 60) {
                    MultiblockControllerBlockEntity.this.progress[index] = value;
                } else if (index == 60) {
                    MultiblockControllerBlockEntity.this.maxProgress[index - 60] = value;
                }
            }

            public int getCount() {
                return 61;
            }
        };
    }

    @NotNull
    public Component getDisplayName() {
        return ((Block)CastingBlocks.MULTIBLOCK_CONTROLLER.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MultiblockControllerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public boolean isSlotEnabled(int index) {
        return index < this.enabledSlots;
    }

    public void tick() {
        if (++this.tickCounter >= 20) {
            this.validateMultiblock();
            if (this.cachedMultiblockData != null) {
                this.findFuelTanks(this.cachedMultiblockData);
                this.findSolidifiers(this.cachedMultiblockData);
                this.findValves(this.cachedMultiblockData);
                this.findMixers(this.cachedMultiblockData);
                if (this.fluidHandler.getTankCapacity(1) != this.cachedMultiblockData.volume() * 1000) {
                    this.fluidHandler.setEnabledCapacity(this.cachedMultiblockData.volume() * 1000);
                }
            }
        }
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.getBlockState().getValue((Property)MultiblockSolidifierBlock.ENABLED)).booleanValue()) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockSolidifierBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                return;
            }
            this.updateWorkingState();
            this.sync();
            for (int i = 0; i < 60; ++i) {
                if (!this.isSlotEnabled(i)) {
                    this.handleItemDrop(i);
                    continue;
                }
                if (this.cachedMultiblockData == null) {
                    this.resetProgress(i);
                    this.errorMessage = "multiblock_not_found";
                    continue;
                }
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.isEmpty()) {
                    this.errorMessage = "";
                    this.resetProgress(i);
                    continue;
                }
                this.processRecipeForItem(i, stack);
            }
            if (++this.tickCounter >= 20) {
                if (this.cachedMultiblockData == null) {
                    this.structureValid = false;
                } else {
                    this.structureValid = true;
                    if (this.enabledSlots != this.cachedMultiblockData.volume()) {
                        this.enabledSlots = Math.min(this.cachedMultiblockData.volume(), 60);
                    }
                }
            }
        }
    }

    private void updateWorkingState() {
        this.working = false;
        for (int i = 0; i < this.enabledSlots; ++i) {
            if (this.progress[i] <= 0) continue;
            this.working = true;
            break;
        }
        assert (this.level != null);
        if (this.working) {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockControllerBlock.WORKING, (Comparable)Boolean.valueOf(true)), 3);
        } else {
            this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockControllerBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
        }
    }

    private void handleItemDrop(int slotIndex) {
        ItemStack stack = this.itemHandler.getStackInSlot(slotIndex);
        if (!stack.isEmpty()) {
            Direction facing = (Direction)this.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            BlockPos dropPos = this.worldPosition.relative(facing);
            assert (this.level != null);
            Containers.dropItemStack((Level)this.level, (double)((double)dropPos.getX() + 0.5), (double)((double)dropPos.getY() + 0.5), (double)((double)dropPos.getZ() + 0.5), (ItemStack)stack);
            this.resetProgress(slotIndex);
            this.itemHandler.setStackInSlot(slotIndex, ItemStack.EMPTY);
            this.sync();
        }
    }

    private void processRecipeForItem(int slotIndex, ItemStack stack) {
        assert (this.level != null);
        Optional<RecipeHolder> selectedRecipe = this.level.getRecipeManager().getAllRecipesFor((RecipeType)MeltingRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((MeltingRecipe)recipeHolder.value()).input().test(stack)).findFirst();
        if (selectedRecipe.isPresent()) {
            FluidStack fluidStack;
            int fillAmount = ((MeltingRecipe)selectedRecipe.get().value()).output().getAmount();
            if (((MeltingRecipe)selectedRecipe.get().value()).input().ingredient().getItems()[0].is(CastingTags.Items.MELTING_OUTPUT_AMOUNT_EFFECTED)) {
                fillAmount = (int)((double)fillAmount * (Double)CastingConfig.oreMultiplier.get());
            }
            if (this.fluidHandler.fill(fluidStack = new FluidStack(((MeltingRecipe)selectedRecipe.get().value()).output().getFluid(), fillAmount), IFluidHandler.FluidAction.SIMULATE) < fillAmount) {
                this.resetProgress(slotIndex);
                this.errorMessage = "not_enough_space";
                return;
            }
            if (this.hasEnoughFuel(((MeltingRecipe)selectedRecipe.get().value()).meltingTemp())) {
                this.maxProgress[slotIndex] = this.setNewMaxProgress();
                int n = slotIndex;
                this.progress[n] = this.progress[n] + 1;
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockControllerBlock.WORKING, (Comparable)Boolean.valueOf(true)), 3);
                this.errorMessage = "";
                if (this.progress[slotIndex] >= this.maxProgress[slotIndex]) {
                    this.resetProgress(slotIndex);
                    this.fluidHandler.fill(fluidStack, IFluidHandler.FluidAction.EXECUTE);
                    this.itemHandler.extractItem(slotIndex, 1, false);
                    this.useFuel();
                    this.setChanged();
                    this.sync();
                }
            }
        } else {
            this.resetProgress(slotIndex);
        }
    }

    private boolean hasEnoughFuel(int temp) {
        this.fuelTemp = 0;
        if (this.fuelTank == null) {
            System.out.println("Fuel tank is null");
            return false;
        }
        if (this.level != null) {
            List allFuels = this.level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
            for (RecipeHolder recipeHolder : allFuels) {
                FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                if (recipe.fluid().getFluid() == this.fuelTank.getFluid().getFluid()) {
                    if (recipe.temp() >= temp) {
                        this.fuelTemp = recipe.temp();
                        return true;
                    }
                    this.errorMessage = "not_hot_enough";
                    return false;
                }
                this.errorMessage = "no_fuel";
            }
        }
        return false;
    }

    private int setNewMaxProgress() {
        if (this.fuelTank == null) {
            System.out.println("Fuel tank is null");
            return this.CONTROLLER_MAX_PROGRESS;
        }
        if (this.level != null) {
            List allFuels = this.level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
            for (RecipeHolder recipeHolder : allFuels) {
                FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                if (recipe.fluid().getFluid() != this.fuelTank.getFluid().getFluid()) continue;
                return recipe.duration();
            }
        }
        return this.CONTROLLER_MAX_PROGRESS;
    }

    private void useFuel() {
        if (this.fuelTank == null) {
            System.out.println("Fuel tank is null");
            return;
        }
        if (this.level != null) {
            List allFuels = this.level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
            for (RecipeHolder recipeHolder : allFuels) {
                FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                if (recipe.fluid().getFluid() != this.fuelTank.getFluid().getFluid() || this.fuelTank.getFluidAmount() < recipe.fluid().getAmount()) continue;
                this.fuelTank.drain(recipe.fluid().getAmount(), IFluidHandler.FluidAction.EXECUTE);
            }
        }
    }

    private void identifyMultiblockExtraBlocks(MultiblockData data, Predicate<BlockState> filter, Consumer<BlockEntity> entityConsumer) {
        if (this.level == null) {
            return;
        }
        data.extraBlocks().forEach(pos -> {
            BlockEntity entity = this.level.getBlockEntity(pos);
            if (entity != null) {
                BlockState blockState = this.level.getBlockState(pos);
                if (filter.test(blockState)) {
                    entityConsumer.accept(entity);
                }
            } else {
                System.out.println("Block entity is null at: " + String.valueOf(pos));
            }
        });
    }

    public void findSolidifiers(MultiblockData cachedMultiblockData) {
        this.identifyMultiblockExtraBlocks(cachedMultiblockData, state -> state.is((Block)CastingBlocks.MULTIBLOCK_SOLIDIFIER.get()), entity -> {
            if (entity instanceof MultiblockSolidifierBlockEntity) {
                MultiblockSolidifierBlockEntity solidifier = (MultiblockSolidifierBlockEntity)((Object)entity);
                solidifier.setControllerBlockEntity(this);
                solidifier.setControllerPos(this.worldPosition);
                solidifier.setCoolantTank(this.coolantTank);
            }
        });
    }

    public void findValves(MultiblockData cachedMultiblockData) {
        this.identifyMultiblockExtraBlocks(cachedMultiblockData, state -> state.is((Block)CastingBlocks.MULTIBLOCK_VALVE.get()), entity -> {
            if (entity instanceof MultiblockValveBlockEntity) {
                MultiblockValveBlockEntity valve = (MultiblockValveBlockEntity)((Object)entity);
                valve.setControllerBlockEntity(this);
                valve.setControllerPos(this.worldPosition);
            }
        });
    }

    public void findMixers(MultiblockData cachedMultiblockData) {
        this.identifyMultiblockExtraBlocks(cachedMultiblockData, state -> state.is((Block)CastingBlocks.MULTIBLOCK_MIXER.get()), entity -> {
            if (entity instanceof MultiblockMixerBlockEntity) {
                MultiblockMixerBlockEntity mixer = (MultiblockMixerBlockEntity)((Object)entity);
                mixer.setControllerBlockEntity(this);
                mixer.setControllerPos(this.worldPosition);
            }
        });
    }

    public void findFuelTanks(MultiblockData cachedMultiblockData) {
        this.fuelTank = null;
        this.coolantTank = null;
        this.identifyMultiblockExtraBlocks(cachedMultiblockData, state -> true, entity -> {
            if (entity instanceof MultiblockFuelTankBlockEntity) {
                MultiblockFuelTankBlockEntity fuelTankEntity = (MultiblockFuelTankBlockEntity)((Object)entity);
                this.fuelTank = fuelTankEntity.fluidHandler;
            } else if (entity instanceof MultiblockCoolantTankBlockEntity) {
                MultiblockCoolantTankBlockEntity coolantTankEntity = (MultiblockCoolantTankBlockEntity)((Object)entity);
                this.coolantTank = coolantTankEntity.fluidHandler;
            }
        });
    }

    private void validateMultiblock() {
        assert (this.level != null);
        this.cachedMultiblockData = CoreMultiblockDetector.findMultiblock(this.level, this.worldPosition, this.getBlockState().getBlock(), wallState -> wallState.is(CastingTags.Blocks.CONTROLLER_WALLS), floorState -> floorState.is(CastingTags.Blocks.CONTROLLER_FLOORS), extraValidBlocks -> extraValidBlocks.is(CastingTags.Blocks.CONTROLLER_EXTRA_BLOCKS), true, true, 1024, 128, 64);
    }

    private void resetProgress(int slot) {
        this.progress[slot] = 0;
        this.maxProgress[slot] = 0;
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putIntArray("progress", this.progress);
        compoundTag.putIntArray("maxProgress", this.maxProgress);
        compoundTag.putBoolean("structureValid", this.structureValid);
        compoundTag.putInt("enabledSlots", this.enabledSlots);
        compoundTag.put("fluidTank", this.fluidHandler.writeToNBT(provider));
        compoundTag.putString("errorMessage", this.errorMessage);
        if (this.fuelTank != null) {
            compoundTag.put("fuelTank", (Tag)this.fuelTank.writeToNBT(provider, new CompoundTag()));
            compoundTag.putInt("fuelTemp", this.fuelTemp);
        }
        if (this.coolantTank != null) {
            compoundTag.put("coolantTank", (Tag)this.coolantTank.writeToNBT(provider, new CompoundTag()));
        }
        if (this.cachedMultiblockData != null) {
            compoundTag.put("multiblockData", this.cachedMultiblockData.serializeNBT(provider));
        }
        ListTag allowedItemsList = new ListTag();
        for (Map.Entry<Integer, Item> entry : this.allowedItems.entrySet()) {
            CompoundTag entryTag = new CompoundTag();
            entryTag.putInt("slot", entry.getKey().intValue());
            ResourceLocation itemID = BuiltInRegistries.ITEM.getKey((Object)entry.getValue());
            entryTag.putString("item", itemID.toString());
            allowedItemsList.add((Object)entryTag);
        }
        compoundTag.put("allowedItems", (Tag)allowedItemsList);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getIntArray("progress");
        this.maxProgress = compoundTag.getIntArray("maxProgress");
        this.structureValid = compoundTag.getBoolean("structureValid");
        this.enabledSlots = compoundTag.getInt("enabledSlots");
        this.fluidHandler.readFromNBT(provider, compoundTag.get("fluidTank"));
        this.errorMessage = compoundTag.getString("errorMessage");
        if (compoundTag.contains("fuelTank") && this.fuelTank != null) {
            this.fuelTank.readFromNBT(provider, compoundTag.getCompound("fuelTank"));
            this.fuelTemp = compoundTag.getInt("fuelTemp");
        }
        if (compoundTag.contains("coolantTank") && this.coolantTank != null) {
            this.coolantTank.readFromNBT(provider, compoundTag.getCompound("coolantTank"));
        }
        if (compoundTag.contains("multiblockData") && this.cachedMultiblockData != null) {
            this.cachedMultiblockData.deserializeNBT(provider, Objects.requireNonNull(compoundTag.get("multiblockData")));
        }
        this.allowedItems.clear();
        if (compoundTag.contains("allowedItems")) {
            ListTag allowedItemsList = compoundTag.getList("allowedItems", 10);
            for (int i = 0; i < allowedItemsList.size(); ++i) {
                CompoundTag entryTag = allowedItemsList.getCompound(i);
                int slot = entryTag.getInt("slot");
                ResourceLocation itemID = ResourceLocation.parse((String)entryTag.getString("item"));
                Item item = (Item)BuiltInRegistries.ITEM.get(itemID);
                this.allowedItems.put(slot, item);
            }
        }
        super.loadAdditional(compoundTag, provider);
    }
}

