/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.data;

import com.benbenlaw.casting.block.CastingBlockStateProperties;
import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.fluid.CastingFluids;
import com.benbenlaw.core.fluid.FluidDeferredRegister;
import com.benbenlaw.core.fluid.FluidRegistryObject;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockStateProvider;
import net.neoforged.neoforge.client.model.generators.ConfiguredModel;
import net.neoforged.neoforge.client.model.generators.ModelBuilder;
import net.neoforged.neoforge.client.model.generators.ModelFile;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.fluids.BaseFlowingFluid;
import net.neoforged.neoforge.registries.DeferredBlock;

public class CastingBlockStatesProvider
extends BlockStateProvider {
    public CastingBlockStatesProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "casting", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.addMultiFaceBlockWithPoweredState((Block)CastingBlocks.MULTIBLOCK_CONTROLLER.get());
        this.addMultiFaceBlockWithPoweredState((Block)CastingBlocks.MULTIBLOCK_SOLIDIFIER.get());
        this.addMultiFaceBlockWithPoweredState((Block)CastingBlocks.MULTIBLOCK_VALVE.get());
        this.addMultiFaceBlockWithPoweredState((Block)CastingBlocks.MULTIBLOCK_MIXER.get());
        this.addMultiFaceBlockController((Block)CastingBlocks.CONTROLLER.get());
        this.addMultiFaceBlock((Block)CastingBlocks.SOLIDIFIER.get());
        this.addMultiFaceBlock((Block)CastingBlocks.MIXER.get());
        this.addMultiFaceBlock((Block)CastingBlocks.EQUIPMENT_MODIFIER.get());
        this.blockWithItem(CastingBlocks.BLACK_BRICKS);
        this.blockWithItem(CastingBlocks.MIXER_WHISK);
        this.simpleBlockWithItem((Block)CastingBlocks.MULTIBLOCK_FUEL_TANK.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.blockTexture((Block)CastingBlocks.MULTIBLOCK_FUEL_TANK.get()).getPath(), this.blockTexture((Block)CastingBlocks.MULTIBLOCK_FUEL_TANK.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)CastingBlocks.MULTIBLOCK_COOLANT_TANK.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.blockTexture((Block)CastingBlocks.MULTIBLOCK_COOLANT_TANK.get()).getPath(), this.blockTexture((Block)CastingBlocks.MULTIBLOCK_COOLANT_TANK.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)CastingBlocks.TANK.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.blockTexture((Block)CastingBlocks.TANK.get()).getPath(), this.blockTexture((Block)CastingBlocks.TANK.get()))).renderType("cutout"));
        this.simpleBlockWithItem((Block)CastingBlocks.BLACK_BRICK_GLASS.get(), (ModelFile)((BlockModelBuilder)this.models().cubeAll(this.blockTexture((Block)CastingBlocks.BLACK_BRICK_GLASS.get()).getPath(), this.blockTexture((Block)CastingBlocks.BLACK_BRICK_GLASS.get()))).renderType("cutout"));
        for (Map.Entry<String, FluidRegistryObject<FluidDeferredRegister.CoreFluidTypes, BaseFlowingFluid.Source, BaseFlowingFluid.Flowing, LiquidBlock, BucketItem>> entry : CastingFluids.FLUIDS_MAP.entrySet()) {
            this.fluidBlocks(entry.getKey(), (Block)entry.getValue().getBlock());
        }
    }

    private void fluidBlocks(String name, Block block) {
        this.simpleBlock(block, (ModelFile)((BlockModelBuilder)this.models().getBuilder(name)).texture("particle", ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"block/molten_flow")));
    }

    private void blockWithItem(DeferredBlock<Block> blockRegistryObject) {
        this.simpleBlockWithItem((Block)blockRegistryObject.get(), this.cubeAll((Block)blockRegistryObject.get()));
    }

    private void addMultiFaceBlockWithPoweredState(Block block) {
        ResourceLocation textureRegistryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        ModelBuilder modelFileOff = this.models().orientable(textureRegistryName.getPath() + "_off", ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_side")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_front")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_top")));
        ModelBuilder modelFileOn = this.models().orientable(textureRegistryName.getPath() + "_on", ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_side")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_front_lit")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_top")));
        this.simpleBlockItem(block, (ModelFile)modelFileOff);
        this.getVariantBuilder(block).forAllStates(arg_0 -> CastingBlockStatesProvider.lambda$addMultiFaceBlockWithPoweredState$0((ModelFile)modelFileOn, (ModelFile)modelFileOff, arg_0));
    }

    private void addMultiFaceBlock(Block block) {
        ResourceLocation textureRegistryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        ModelBuilder modelFileOff = this.models().orientable(textureRegistryName.getPath() + "_off", ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_side")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_front")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_top")));
        ModelBuilder modelFileOn = this.models().orientable(textureRegistryName.getPath() + "_on", ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_side")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_front_lit")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_top")));
        this.simpleBlockItem(block, (ModelFile)modelFileOff);
        this.getVariantBuilder(block).forAllStates(arg_0 -> CastingBlockStatesProvider.lambda$addMultiFaceBlock$1((ModelFile)modelFileOff, arg_0));
    }

    private void addMultiFaceBlockController(Block block) {
        ResourceLocation textureRegistryName = BuiltInRegistries.BLOCK.getKey((Object)block);
        ModelBuilder modelFileOff = this.models().orientable(textureRegistryName.getPath() + "_off", ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_side")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_front")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_top")));
        ModelBuilder modelFileOn = this.models().orientable(textureRegistryName.getPath() + "_on", ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_side")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_front_lit")), ResourceLocation.parse((String)("casting:block/" + textureRegistryName.getPath() + "_top")));
        this.simpleBlockItem(block, (ModelFile)modelFileOff);
        this.getVariantBuilder(block).forAllStates(arg_0 -> CastingBlockStatesProvider.lambda$addMultiFaceBlockController$2((ModelFile)modelFileOn, (ModelFile)modelFileOff, arg_0));
    }

    public String getName() {
        return "casting Block States";
    }

    private static /* synthetic */ ConfiguredModel[] lambda$addMultiFaceBlockController$2(ModelFile modelFileOn, ModelFile modelFileOff, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return ConfiguredModel.builder().modelFile((Boolean)state.getValue((Property)BlockStateProperties.POWERED) != false ? modelFileOn : modelFileOff).rotationY((int)((facing.toYRot() + 180.0f) % 360.0f)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$addMultiFaceBlock$1(ModelFile modelFileOff, BlockState state) {
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return ConfiguredModel.builder().modelFile(modelFileOff).rotationY((int)((facing.toYRot() + 180.0f) % 360.0f)).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$addMultiFaceBlockWithPoweredState$0(ModelFile modelFileOn, ModelFile modelFileOff, BlockState state) {
        boolean working = (Boolean)state.getValue((Property)CastingBlockStateProperties.WORKING);
        Direction facing = (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
        return ConfiguredModel.builder().modelFile(working ? modelFileOn : modelFileOff).rotationY((int)((facing.toYRot() + 180.0f) % 360.0f)).build();
    }
}

