/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen.multiblock;

import com.benbenlaw.casting.block.entity.multiblock.MultiblockControllerBlockEntity;
import com.benbenlaw.casting.block.multiblock.MultiblockControllerBlock;
import com.benbenlaw.casting.network.payload.ControllerFilteredInventoryPayload;
import com.benbenlaw.casting.network.payload.OnOffButtonPayload;
import com.benbenlaw.casting.screen.multiblock.MultiblockControllerMenu;
import com.benbenlaw.casting.screen.util.FluidStackStackWidget;
import com.benbenlaw.casting.screen.util.MultiFluidStackWidget;
import com.benbenlaw.casting.util.ConditionalSlotItemHandler;
import com.benbenlaw.core.screen.util.CoreButtons;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.Nullable;

public class MultiblockControllerScreen
extends AbstractContainerScreen<MultiblockControllerMenu> {
    Level level;
    MultiblockControllerBlockEntity blockEntity;
    private boolean filteringEnabled = false;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/multiblock_controller_gui.png");
    private static final ResourceLocation SLOT = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/slot.png");
    private static final ResourceLocation SLOT_DISABLED = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/slot_disabled.png");

    public MultiblockControllerScreen(MultiblockControllerMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
        this.blockEntity = menu.blockEntity;
        this.imageHeight = 256;
        this.inventoryLabelY = 162;
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
        this.addMenuButtons();
    }

    public void containerTick() {
        this.clearWidgets();
        this.addFluidWidgets();
        this.addMenuButtons();
    }

    public void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new MultiFluidStackWidget((Screen)this, ((MultiblockControllerMenu)this.getMenu()).blockEntity.fluidHandler, this.leftPos + 134, this.topPos + 114, 34, 45));
        if (((MultiblockControllerMenu)this.getMenu()).blockEntity.fuelTank != null) {
            this.addRenderableOnly((Renderable)new FluidStackStackWidget((Screen)this, ((MultiblockControllerMenu)this.getMenu()).blockEntity.fuelTank, this.leftPos + 107, this.topPos + 114, 16, 45));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
        for (Slot slot : ((MultiblockControllerMenu)this.menu).slots) {
            ConditionalSlotItemHandler conditionalSlotItemHandler;
            if (!(slot instanceof ConditionalSlotItemHandler) || (conditionalSlotItemHandler = (ConditionalSlotItemHandler)slot).getContainerSlot() >= ((MultiblockControllerMenu)this.menu).blockEntity.enabledSlots) continue;
            guiGraphics.blit(SLOT, x + slot.x - 1, y + slot.y - 1, 0.0f, 0.0f, 18, 18, 18, 18);
        }
        if (!((MultiblockControllerMenu)this.menu).blockEntity.errorMessage.isEmpty()) {
            guiGraphics.blit(TEXTURE, x + 21, y - 17, 177, 18, 20, 18);
            this.renderErrorTooltip(guiGraphics, mouseX, mouseY, x, y);
        }
        if (((MultiblockControllerMenu)this.menu).blockEntity.errorMessage.isEmpty()) {
            guiGraphics.blit(TEXTURE, x + 21, y - 17, 177, 36, 20, 18);
            this.renderTickRate(guiGraphics, mouseX, mouseY, x, y);
        }
        guiGraphics.blit(TEXTURE, x + 41, y - 17, 177, 54, 20, 18);
        this.renderFilterTooltip(guiGraphics, mouseX, mouseY, x, y);
        this.renderProgressBars(guiGraphics, x, y);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        for (Slot slot : ((MultiblockControllerMenu)this.menu).slots) {
            if (!(slot instanceof ConditionalSlotItemHandler)) continue;
            ConditionalSlotItemHandler conditionalSlotItemHandler = (ConditionalSlotItemHandler)slot;
            if (conditionalSlotItemHandler.getContainerSlot() >= ((MultiblockControllerMenu)this.menu).blockEntity.enabledSlots) {
                guiGraphics.blit(SLOT_DISABLED, x + slot.x - 1, y + slot.y - 1, 18, 18, 18, 18);
            }
            this.renderFilterInfo(guiGraphics, x, y, slot.getContainerSlot());
        }
        if (((MultiblockControllerMenu)this.getMenu()).blockEntity.fuelTank == null) {
            this.renderNoTank(guiGraphics, mouseX, mouseY, x, y);
        }
        this.renderProgressBars(guiGraphics, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    private void renderProgressBars(GuiGraphics guiGraphics, int x, int y) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        for (Slot slot : ((MultiblockControllerMenu)this.menu).slots) {
            ConditionalSlotItemHandler conditionalSlotItemHandler;
            int containerSlot;
            int progress;
            if (!(slot instanceof ConditionalSlotItemHandler) || (progress = ((MultiblockControllerMenu)this.menu).getScaledProgress(containerSlot = (conditionalSlotItemHandler = (ConditionalSlotItemHandler)slot).getContainerSlot())) <= 0) continue;
            int slotX = slot.x;
            int slotY = slot.y;
            int fullHeight = 18;
            guiGraphics.blit(TEXTURE, x + slotX - 1, y + slotY + (fullHeight - progress) - 1, 176, fullHeight - progress, 18, progress);
        }
    }

    private void addMenuButtons() {
        int buttonX = this.leftPos;
        int buttonY = this.topPos - 17;
        if (((MultiblockControllerMenu)this.menu).blockEntity != null) {
            WidgetSprites buttonTexture = (Boolean)((MultiblockControllerMenu)this.menu).blockEntity.getBlockState().getValue((Property)MultiblockControllerBlock.ENABLED) != false ? CoreButtons.ON_BUTTONS : CoreButtons.OFF_BUTTONS;
            this.addRenderableWidget((GuiEventListener)new ImageButton(buttonX, buttonY, 20, 18, buttonTexture, pressed -> PacketDistributor.sendToServer((CustomPacketPayload)new OnOffButtonPayload(((MultiblockControllerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])));
        }
    }

    private void renderFilterInfo(GuiGraphics guiGraphics, int x, int y, int containerSlot) {
        Item filteredItem = ((MultiblockControllerMenu)this.menu).blockEntity.getAllowedItem(containerSlot);
        if (filteredItem != null) {
            ItemStack fakeStack = new ItemStack((ItemLike)filteredItem);
            for (Slot slot : ((MultiblockControllerMenu)this.menu).slots) {
                ConditionalSlotItemHandler cSlot;
                if (!slot.getItem().isEmpty() || !(slot instanceof ConditionalSlotItemHandler) || (cSlot = (ConditionalSlotItemHandler)slot).getContainerSlot() != containerSlot) continue;
                RenderSystem.setShaderColor((float)0.7f, (float)0.7f, (float)0.7f, (float)0.5f);
                guiGraphics.renderFakeItem(fakeStack, x + slot.x, y + slot.y);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                break;
            }
        }
    }

    @Nullable
    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)20, (int)-17, (int)19, (int)18)) {
            int[] progressArray = ((MultiblockControllerMenu)this.menu).blockEntity.progress;
            int[] maxProgressArray = ((MultiblockControllerMenu)this.menu).blockEntity.maxProgress;
            int maxIndex = -1;
            int highestMax = -1;
            for (int i = 0; i < maxProgressArray.length; ++i) {
                if (maxProgressArray[i] <= highestMax) continue;
                highestMax = maxProgressArray[i];
                maxIndex = i;
            }
            if (highestMax <= 0) {
                guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.buttons.waiting_for_recipe"), mouseX, mouseY);
            } else {
                int currentProgress = progressArray[maxIndex];
                guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)(currentProgress + " / " + highestMax)), mouseX, mouseY);
            }
        }
    }

    private int getSlotX(int slot) {
        switch (slot) {
            case 0: 
            case 5: 
            case 10: {
                return 12;
            }
            case 1: 
            case 6: 
            case 11: {
                return 31;
            }
            case 2: 
            case 7: 
            case 12: {
                return 50;
            }
            case 3: 
            case 8: 
            case 13: {
                return 69;
            }
            case 4: 
            case 9: 
            case 14: {
                return 88;
            }
        }
        return 0;
    }

    private int getSlotY(int slot) {
        if (slot >= 0 && slot <= 4) {
            return 20;
        }
        if (slot >= 5 && slot <= 9) {
            return 39;
        }
        if (slot >= 10 && slot <= 14) {
            return 58;
        }
        return 0;
    }

    private void renderNoTank(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)107, (int)114, (int)16, (int)45)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"gui.casting.multiblock_controller.no_fuel_tank").withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
    }

    private void renderErrorTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)20, (int)-17, (int)19, (int)18)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)("gui.casting.buttons." + ((MultiblockControllerMenu)this.menu).blockEntity.errorMessage)), mouseX, mouseY);
        }
    }

    private void renderFilterTooltip(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)40, (int)-17, (int)19, (int)18)) {
            ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
            if (this.filteringEnabled) {
                tooltipLines.add(Component.translatable((String)"gui.casting.buttons.filtering_enabled"));
                HashMap<Item, Integer> itemCounts = new HashMap<Item, Integer>();
                for (int slot = 0; slot < ((MultiblockControllerMenu)this.menu).blockEntity.enabledSlots; ++slot) {
                    Item filteredItem = ((MultiblockControllerMenu)this.menu).blockEntity.getAllowedItem(slot);
                    if (filteredItem == null || filteredItem == Items.AIR) continue;
                    int count = ((MultiblockControllerMenu)this.menu).blockEntity.itemHandler.getStackInSlot(slot).getCount();
                    itemCounts.put(filteredItem, itemCounts.getOrDefault(filteredItem, 0) + count);
                }
                for (Map.Entry entry : itemCounts.entrySet()) {
                    String itemName = ((Item)entry.getKey()).getName(new ItemStack((ItemLike)entry.getKey())).getString();
                    int totalCount = (Integer)entry.getValue();
                    tooltipLines.add(Component.literal((String)("- " + itemName + " \u00d7 " + totalCount)));
                }
            } else {
                tooltipLines.add(Component.translatable((String)"gui.casting.buttons.filtering_disabled"));
            }
            guiGraphics.renderTooltip(this.font, tooltipLines, Optional.empty(), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        if (MouseUtil.isMouseAboveArea((int)((int)mouseX), (int)((int)mouseY), (int)(this.leftPos + 41), (int)(this.topPos - 17), (int)0, (int)0, (int)19, (int)18)) {
            if (!this.filteringEnabled) {
                for (int slot = 0; slot < ((MultiblockControllerMenu)this.menu).blockEntity.enabledSlots; ++slot) {
                    ItemStack item = ((MultiblockControllerMenu)this.menu).blockEntity.itemHandler.getStackInSlot(slot);
                    if (item.isEmpty()) continue;
                    PacketDistributor.sendToServer((CustomPacketPayload)new ControllerFilteredInventoryPayload(slot, item, ((MultiblockControllerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.filteringEnabled = true;
            } else {
                for (int slot = 0; slot < ((MultiblockControllerMenu)this.menu).blockEntity.enabledSlots; ++slot) {
                    PacketDistributor.sendToServer((CustomPacketPayload)new ControllerFilteredInventoryPayload(slot, ItemStack.EMPTY, ((MultiblockControllerMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
                this.filteringEnabled = false;
            }
        }
        return handled;
    }
}

