/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.integration.jei;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.integration.jei.JEICastingPlugin;
import com.benbenlaw.casting.recipe.EquipmentModifierRecipe;
import java.util.Arrays;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquipmentModifierRecipeCategory
implements IRecipeCategory<EquipmentModifierRecipe> {
    public static final ResourceLocation UID = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"equipment_modifier");
    public static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/jei_equipment_modifier.png");
    public static final RecipeType<EquipmentModifierRecipe> RECIPE_TYPE = RecipeType.create((String)"casting", (String)"equipment_modifier", EquipmentModifierRecipe.class);
    private IDrawable background;
    private final IDrawable icon;
    private final IGuiHelper helper;

    @Nullable
    public ResourceLocation getRegistryName(EquipmentModifierRecipe recipe) {
        assert (Minecraft.getInstance().level != null);
        return Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor((net.minecraft.world.item.crafting.RecipeType)EquipmentModifierRecipe.Type.INSTANCE).stream().filter(recipeHolder -> ((EquipmentModifierRecipe)recipeHolder.value()).equals(recipe)).map(RecipeHolder::id).findFirst().orElse(null);
    }

    public EquipmentModifierRecipeCategory(IGuiHelper helper) {
        this.helper = helper;
        this.background = helper.createDrawable(TEXTURE, 0, 0, 95, 19);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)CastingBlocks.EQUIPMENT_MODIFIER.get()));
    }

    @NotNull
    public RecipeType<EquipmentModifierRecipe> getRecipeType() {
        return JEICastingPlugin.EQUIPMENT_MODIFIER_RECIPE;
    }

    @NotNull
    public Component getTitle() {
        return Component.literal((String)"Tool Modifier");
    }

    @NotNull
    public IDrawable getBackground() {
        return this.background;
    }

    @NotNull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EquipmentModifierRecipe recipe, IFocusGroup focusGroup) {
        ItemStack outputEffectAsItem = ((Item)BuiltInRegistries.ITEM.get(ResourceLocation.fromNamespaceAndPath((String)"casting", (String)recipe.effect()))).getDefaultInstance();
        builder.addSlot(RecipeIngredientRole.OUTPUT, 76, 2).addItemStack(outputEffectAsItem);
        if (Arrays.asList(recipe.upgradeItem().getItems()).isEmpty()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addFluidStack(recipe.upgradeFluid().getFluid())).addRichTooltipCallback((ingredient, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)(recipe.upgradeFluid().getAmount() + "mB")).withStyle(ChatFormatting.GOLD)));
        }
        if (recipe.upgradeFluid().isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addItemStacks(Arrays.asList(recipe.upgradeItem().getItems()));
        } else {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 4, 2).addFluidStack(recipe.upgradeFluid().getFluid())).addRichTooltipCallback((ingredient, tooltip) -> tooltip.add((FormattedText)Component.translatable((String)(recipe.upgradeFluid().getAmount() + "mB")).withStyle(ChatFormatting.GOLD)));
            builder.addSlot(RecipeIngredientRole.INPUT, 40, 2).addItemStacks(Arrays.asList(recipe.upgradeItem().getItems()));
        }
    }
}

