/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block;

import com.benbenlaw.casting.block.custom.ControllerBlock;
import com.benbenlaw.casting.block.custom.EquipmentlModifierBlock;
import com.benbenlaw.casting.block.custom.MixerBlock;
import com.benbenlaw.casting.block.custom.SolidifierBlock;
import com.benbenlaw.casting.block.custom.TankBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockControllerBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockCoolantTankBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockFuelTankBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockMixerBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockRegulatorBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockSolidifierBlock;
import com.benbenlaw.casting.block.multiblock.MultiblockValveBlock;
import com.benbenlaw.casting.item.CastingItems;
import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TransparentBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class CastingBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.createBlocks((String)"casting");
    public static final DeferredBlock<Block> MULTIBLOCK_CONTROLLER = CastingBlocks.registerBlock("multiblock_controller", () -> new MultiblockControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).lightLevel(CastingBlocks.litBlockEmission(15)).noOcclusion()));
    public static final DeferredBlock<Block> MULTIBLOCK_FUEL_TANK = CastingBlocks.registerBlock("multiblock_fuel_tank", () -> new MultiblockFuelTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).lightLevel(state -> (Integer)state.getValue((Property)MultiblockFuelTankBlock.LIGHT_LEVEL)).noOcclusion()));
    public static final DeferredBlock<Block> MULTIBLOCK_COOLANT_TANK = CastingBlocks.registerBlock("multiblock_coolant_tank", () -> new MultiblockCoolantTankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).lightLevel(state -> (Integer)state.getValue((Property)MultiblockCoolantTankBlock.LIGHT_LEVEL)).noOcclusion()));
    public static final DeferredBlock<Block> MULTIBLOCK_SOLIDIFIER = CastingBlocks.registerBlock("multiblock_solidifier", () -> new MultiblockSolidifierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE)));
    public static final DeferredBlock<Block> BLACK_BRICKS = CastingBlocks.registerBlock("black_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE)));
    public static final DeferredBlock<Block> BLACK_BRICK_GLASS = CastingBlocks.registerBlock("black_brick_glass", () -> new TransparentBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GLASS).sound(SoundType.GLASS).noOcclusion()));
    public static final DeferredBlock<Block> MULTIBLOCK_VALVE = CastingBlocks.registerBlock("multiblock_valve", () -> new MultiblockValveBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> MULTIBLOCK_MIXER = CastingBlocks.registerBlock("multiblock_mixer", () -> new MultiblockMixerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> MULTIBLOCK_REGULATOR = CastingBlocks.registerBlock("multiblock_regulator", () -> new MultiblockRegulatorBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.BRICKS).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> CONTROLLER = CastingBlocks.registerBlock("controller", () -> new ControllerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).lightLevel(CastingBlocks.litBlockEmissionOG(15)).noOcclusion()));
    public static final DeferredBlock<Block> SOLIDIFIER = CastingBlocks.registerBlock("solidifier", () -> new SolidifierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> TANK = CastingBlocks.registerBlock("tank", () -> new TankBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> MIXER = CastingBlocks.registerBlock("mixer", () -> new MixerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> MIXER_WHISK = CastingBlocks.registerBlock("mixer_whisk", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).noOcclusion()));
    public static final DeferredBlock<Block> EQUIPMENT_MODIFIER = CastingBlocks.registerBlock("equipment_modifier", () -> new EquipmentlModifierBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE).sound(SoundType.STONE).noOcclusion()));

    private static ToIntFunction<BlockState> litBlockEmission(int lightLevel) {
        return blockState -> (Boolean)blockState.getValue((Property)MultiblockControllerBlock.WORKING) != false ? lightLevel : 0;
    }

    private static ToIntFunction<BlockState> litBlockEmissionOG(int lightLevel) {
        return blockState -> (Boolean)blockState.getValue((Property)BlockStateProperties.POWERED) != false ? lightLevel : 0;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutBlockItem(String name, Supplier<T> block) {
        return (DeferredBlock)BLOCKS.register(name, block);
    }

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = (DeferredBlock)BLOCKS.register(name, block);
        CastingBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        CastingItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }
}

