/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.event;

import com.benbenlaw.casting.config.EquipmentModifierConfig;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.util.BeheadingHeadMap;
import com.benbenlaw.core.util.FakePlayerUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.WallTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import net.neoforged.neoforge.event.entity.living.LivingDropsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="casting")
public class ToolEvents {
    private static final Map<UUID, Direction> lastHitDirectionMap = new HashMap<UUID, Direction>();

    @SubscribeEvent
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getEntity();
        Level level = player.level();
        Direction face = event.getFace();
        if (level.isClientSide()) {
            return;
        }
        if (player.getMainHandItem().has(CastingDataComponents.EXCAVATION)) {
            lastHitDirectionMap.put(player.getUUID(), face);
            System.out.println("Direction: " + String.valueOf(face));
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        boolean requiresCastingOverrides;
        Player player = event.getPlayer();
        Direction face = lastHitDirectionMap.getOrDefault(player.getUUID(), Direction.DOWN);
        Level level = player.level();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        ItemStack tool = player.getMainHandItem();
        boolean isSilkTouch = tool.getComponents().keySet().contains(CastingDataComponents.SILK_TOUCH.get());
        boolean isFortune = tool.getComponents().keySet().contains(CastingDataComponents.FORTUNE.get());
        boolean isAutoSmelt = tool.getComponents().keySet().contains(CastingDataComponents.AUTO_SMELT.get());
        boolean isUnbreaking = tool.getComponents().keySet().contains(CastingDataComponents.UNBREAKING.get());
        boolean isExcavation = tool.getComponents().keySet().contains(CastingDataComponents.EXCAVATION.get());
        boolean bl = requiresCastingOverrides = isExcavation || isSilkTouch || isFortune || isAutoSmelt || isUnbreaking;
        if (!level.isClientSide() && requiresCastingOverrides) {
            event.setCanceled(true);
            if (!tool.isCorrectToolForDrops(state)) {
                ToolEvents.breakBlockWithCasting(level, player, pos, tool, isSilkTouch, isFortune, isAutoSmelt, isUnbreaking);
                return;
            }
            if (isExcavation && !player.isShiftKeyDown()) {
                int excavationLevel = (Integer)tool.getComponents().getOrDefault((DataComponentType)CastingDataComponents.EXCAVATION.get(), (Object)0);
                List<BlockPos> excavationPlane = ToolEvents.getExcavationPlane(pos, face, excavationLevel);
                for (BlockPos targetPos : excavationPlane) {
                    BlockState targetState;
                    if (!level.isLoaded(targetPos) || (targetState = level.getBlockState(targetPos)).isAir() || !(targetState.getDestroySpeed((BlockGetter)level, targetPos) >= 0.0f) || !tool.isCorrectToolForDrops(targetState)) continue;
                    ToolEvents.breakBlockWithCasting(level, player, targetPos, tool, isSilkTouch, isFortune, isAutoSmelt, isUnbreaking);
                }
                return;
            }
            ToolEvents.breakBlockWithCasting(level, player, pos, tool, isSilkTouch, isFortune, isAutoSmelt, isUnbreaking);
        }
    }

    public static void breakBlockWithCasting(Level level, Player player, BlockPos pos, ItemStack tool, boolean isSilkTouch, boolean isFortune, boolean isAutoSmelt, boolean isUnbreaking) {
        BlockState state = level.getBlockState(pos);
        BlockEntity blockEntity = level.getBlockEntity(pos);
        ItemStack fakeItemStack = tool.copy();
        List<Object> drops = new ArrayList();
        boolean shouldTakeDamage = true;
        if (isSilkTouch && !player.isShiftKeyDown()) {
            fakeItemStack.enchant(ToolEvents.toHolder(level, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), 1);
            drops = ToolEvents.getLootDrops(state, blockEntity, pos, player, fakeItemStack, level);
        } else if (isFortune) {
            int fortuneLevel = (Integer)tool.getComponents().getOrDefault((DataComponentType)CastingDataComponents.FORTUNE.get(), (Object)0);
            fakeItemStack.enchant(ToolEvents.toHolder(level, (ResourceKey<Enchantment>)Enchantments.FORTUNE), fortuneLevel);
            drops = ToolEvents.getLootDrops(state, blockEntity, pos, player, fakeItemStack, level);
        }
        if (drops.isEmpty()) {
            drops = ToolEvents.getLootDrops(state, blockEntity, pos, player, fakeItemStack, level);
        }
        if (isAutoSmelt && !player.isShiftKeyDown()) {
            ArrayList<ItemStack> smeltingDrops = new ArrayList<ItemStack>();
            for (ItemStack itemStack : drops) {
                SingleRecipeInput container = new SingleRecipeInput(itemStack);
                List smeltingRecipe = level.getRecipeManager().getRecipesFor(RecipeType.SMELTING, (RecipeInput)container, level);
                if (!smeltingRecipe.isEmpty()) {
                    ItemStack result = ((SmeltingRecipe)((RecipeHolder)smeltingRecipe.getFirst()).value()).getResultItem((HolderLookup.Provider)level.registryAccess());
                    ItemStack smeltedStack = result.copy();
                    smeltedStack.setCount(itemStack.getCount());
                    smeltingDrops.add(smeltedStack);
                    continue;
                }
                smeltingDrops.add(itemStack);
            }
            drops = smeltingDrops;
        }
        for (ItemStack itemStack : drops) {
            Block.popResource((Level)level, (BlockPos)pos, (ItemStack)itemStack);
        }
        if (drops.isEmpty() || ((ItemStack)drops.getFirst()).is(Items.AIR)) {
            state.getBlock().playerDestroy(level, player, pos, state, blockEntity, tool);
        }
        level.destroyBlock(pos, false, (Entity)player);
        if (isUnbreaking) {
            int unbreakingLevel = (Integer)tool.getOrDefault((DataComponentType)CastingDataComponents.UNBREAKING.get(), (Object)0);
            boolean bl = shouldTakeDamage = level.getRandom().nextFloat() >= (float)unbreakingLevel * 0.1f;
        }
        if (shouldTakeDamage) {
            tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        }
    }

    public static List<ItemStack> getLootDrops(BlockState state, BlockEntity entity, BlockPos pos, Player player, ItemStack tool, Level level) {
        LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)tool).withParameter(LootContextParams.BLOCK_ENTITY, (Object)entity).withParameter(LootContextParams.THIS_ENTITY, (Object)player).withParameter(LootContextParams.BLOCK_STATE, (Object)state);
        return state.getDrops(lootParams);
    }

    public static List<BlockPos> getExcavationPlane(BlockPos origin, Direction face, int level) {
        Direction.Axis axis1;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        Direction.Axis axis = face.getAxis();
        Direction.Axis axis2 = switch (axis) {
            case Direction.Axis.X -> {
                axis1 = Direction.Axis.Y;
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Y -> {
                axis1 = Direction.Axis.X;
                yield Direction.Axis.Z;
            }
            case Direction.Axis.Z -> {
                axis1 = Direction.Axis.X;
                yield Direction.Axis.Y;
            }
            default -> throw new IllegalStateException("Unexpected axis: " + String.valueOf(axis));
        };
        for (int i = -level; i <= level; ++i) {
            for (int j = -level; j <= level; ++j) {
                BlockPos offset = origin;
                offset = offset.relative(Direction.fromAxisAndDirection((Direction.Axis)axis1, (Direction.AxisDirection)(i >= 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)), Math.abs(i));
                offset = offset.relative(Direction.fromAxisAndDirection((Direction.Axis)axis2, (Direction.AxisDirection)(j >= 0 ? Direction.AxisDirection.POSITIVE : Direction.AxisDirection.NEGATIVE)), Math.abs(j));
                positions.add(offset);
            }
        }
        return positions;
    }

    public static void breakArea(BlockEvent.BreakEvent event, Player player, ItemStack tool, Level level, BlockPos origin, BlockState originalState, int excavationLevel) {
        int radius = excavationLevel;
        Vec3 lookVec = player.getLookAngle();
        Direction face = Direction.getNearest((double)lookVec.x, (double)lookVec.y, (double)lookVec.z);
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius; ++dy) {
                BlockPos targetPos = face.getAxis() == Direction.Axis.Y ? origin.offset(dx, 0, dy) : (face.getAxis() == Direction.Axis.X ? origin.offset(0, dx, dy) : origin.offset(dx, dy, 0));
                BlockEntity blockEntity = level.getBlockEntity(targetPos);
                BlockState targetState = level.getBlockState(targetPos);
                if (targetState.isAir() || targetState.getDestroySpeed((BlockGetter)level, targetPos) < 0.0f || !tool.isCorrectToolForDrops(targetState)) continue;
                ItemStack fakeItemStack = tool.copy();
                if (Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)CastingDataComponents.SILK_TOUCH.get()))) {
                    fakeItemStack.enchant(ToolEvents.toHolder(level, (ResourceKey<Enchantment>)Enchantments.SILK_TOUCH), 1);
                } else if (tool.getComponents().keySet().contains(CastingDataComponents.FORTUNE.get())) {
                    int fortuneLevel = (Integer)tool.getOrDefault((DataComponentType)CastingDataComponents.FORTUNE.get(), (Object)0);
                    fakeItemStack.enchant(ToolEvents.toHolder(level, (ResourceKey<Enchantment>)Enchantments.FORTUNE), fortuneLevel);
                }
                List<ItemStack> drops = ToolEvents.getLootDrops(targetState, blockEntity, targetPos, player, fakeItemStack, level);
                if (Boolean.TRUE.equals(tool.getComponents().get((DataComponentType)CastingDataComponents.AUTO_SMELT.get()))) {
                    ArrayList<ItemStack> smelted = new ArrayList<ItemStack>();
                    for (ItemStack drop : drops) {
                        SingleRecipeInput container = new SingleRecipeInput(drop);
                        List recipes = level.getRecipeManager().getRecipesFor(RecipeType.SMELTING, (RecipeInput)container, level);
                        if (!recipes.isEmpty()) {
                            ItemStack result = ((SmeltingRecipe)((RecipeHolder)recipes.getFirst()).value()).getResultItem((HolderLookup.Provider)level.registryAccess()).copy();
                            result.setCount(drop.getCount());
                            smelted.add(result);
                            continue;
                        }
                        smelted.add(drop);
                    }
                    drops = smelted;
                }
                for (ItemStack drop : drops) {
                    Block.popResource((Level)level, (BlockPos)targetPos, (ItemStack)drop);
                }
                if (drops.size() == 1 && drops.getFirst().is(Items.AIR)) {
                    targetState.getBlock().playerDestroy(level, player, targetPos, targetState, blockEntity, tool);
                }
                level.destroyBlock(targetPos, false, (Entity)player);
                boolean shouldTakeDamage = true;
                if (tool.getComponents().keySet().contains(CastingDataComponents.UNBREAKING.get())) {
                    int unbreakingLevel = (Integer)tool.getOrDefault((DataComponentType)CastingDataComponents.UNBREAKING.get(), (Object)0);
                    boolean bl = shouldTakeDamage = level.getRandom().nextFloat() >= (float)unbreakingLevel * 0.1f;
                }
                if (!shouldTakeDamage) continue;
                tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    @SubscribeEvent
    public static void onBreakingBlock(PlayerEvent.BreakSpeed event) {
        Integer efficiencyLevel;
        Player player = event.getEntity();
        Level level = player.level();
        BlockState state = level.getBlockState(event.getPosition().orElse(BlockPos.ZERO));
        ItemStack tool = player.getMainHandItem();
        if (tool.getComponents().keySet().contains(CastingDataComponents.EFFICIENCY.get()) && (efficiencyLevel = (Integer)tool.getComponents().get((DataComponentType)CastingDataComponents.EFFICIENCY.get())) != null && efficiencyLevel > 0 && tool.isCorrectToolForDrops(state)) {
            float baseSpeed = event.getOriginalSpeed();
            float bonus = efficiencyLevel * efficiencyLevel + 1;
            event.setNewSpeed(baseSpeed + bonus);
        }
    }

    @SubscribeEvent
    public static void onPreLivingDamage(LivingDamageEvent.Pre event) {
        boolean requiresCastingOverrides;
        Level level = event.getEntity().level();
        LivingEntity target = event.getEntity();
        Entity sourceEntity = event.getSource().getEntity();
        if (!(sourceEntity instanceof Player)) {
            return;
        }
        Player attacker = (Player)sourceEntity;
        ItemStack weapon = attacker.getMainHandItem();
        if (weapon.isEmpty()) {
            return;
        }
        boolean isSharpness = weapon.getComponents().keySet().contains(CastingDataComponents.SHARPNESS.get());
        boolean isLifesteal = weapon.getComponents().keySet().contains(CastingDataComponents.LIFESTEAL.get());
        boolean isKnockback = weapon.getComponents().keySet().contains(CastingDataComponents.KNOCKBACK.get());
        boolean isIgnite = weapon.getComponents().keySet().contains(CastingDataComponents.IGNITE.get());
        boolean bl = requiresCastingOverrides = isIgnite || isSharpness || isLifesteal || isKnockback;
        if (!level.isClientSide() && requiresCastingOverrides) {
            double dz;
            double dx;
            double distance;
            int knockbackLevel;
            if (isSharpness) {
                int sharpnessLevel = (Integer)weapon.getComponents().getOrDefault((DataComponentType)CastingDataComponents.SHARPNESS.get(), (Object)0);
                if (sharpnessLevel <= 0) {
                    return;
                }
                float bonusDamage = ((Float)EquipmentModifierConfig.additionalMultiplierForSharpness.get()).floatValue() * (float)sharpnessLevel + ((Float)EquipmentModifierConfig.additionalAdditionForSharpness.get()).floatValue();
                event.setNewDamage(event.getNewDamage() + bonusDamage);
            }
            if (isLifesteal) {
                if (target instanceof Player) {
                    return;
                }
                if (target.isInvulnerable()) {
                    return;
                }
                if (target instanceof Enemy) {
                    int lifestealLevel = (Integer)weapon.getComponents().getOrDefault((DataComponentType)CastingDataComponents.LIFESTEAL.get(), (Object)0);
                    int healingAmount = (int)(event.getNewDamage() * 0.1f * (float)lifestealLevel);
                    if (healingAmount > 0) {
                        attacker.heal((float)healingAmount);
                    }
                }
            }
            if (isKnockback && (knockbackLevel = ((Integer)weapon.getComponents().getOrDefault((DataComponentType)CastingDataComponents.KNOCKBACK.get(), (Object)0)).intValue()) > 0 && (distance = Math.sqrt((dx = target.getX() - attacker.getX()) * dx + (dz = target.getZ() - attacker.getZ()) * dz)) > 0.0) {
                target.setDeltaMovement(target.getDeltaMovement().add((dx /= distance) * (double)knockbackLevel, 0.1, (dz /= distance) * (double)knockbackLevel));
                target.hurtMarked = true;
            }
            if (isIgnite) {
                int igniteLevel = (Integer)weapon.getComponents().getOrDefault((DataComponentType)CastingDataComponents.IGNITE.get(), (Object)0);
                target.igniteForSeconds((float)(1 + igniteLevel));
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Inventory inventory = event.getEntity().getInventory();
        Player player = event.getEntity();
        Level level = player.level();
        if (level.isClientSide()) {
            return;
        }
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            int currentDamage;
            int repairingLevel;
            int repairTickTime;
            ItemStack stack = inventory.getItem(i);
            if (stack.isEmpty() || !stack.getComponents().keySet().contains(CastingDataComponents.REPAIRING.get()) || event.getEntity().tickCount % (repairTickTime = ToolEvents.getRepairTickTime(repairingLevel = ((Integer)stack.getComponents().getOrDefault((DataComponentType)CastingDataComponents.REPAIRING.get(), (Object)0)).intValue())) != 0 || (currentDamage = stack.getDamageValue()) <= 0) continue;
            int newDamage = Math.max(currentDamage - 1, 0);
            stack.setDamageValue(newDamage);
            inventory.setChanged();
        }
    }

    private static int getRepairTickTime(int repairingLevel) {
        int repairTickTime = 220;
        switch (repairingLevel) {
            case 1: {
                repairTickTime = 200;
                break;
            }
            case 2: {
                repairTickTime = 180;
                break;
            }
            case 3: {
                repairTickTime = 160;
                break;
            }
            case 4: {
                repairTickTime = 140;
                break;
            }
            case 5: {
                repairTickTime = 120;
                break;
            }
            case 6: {
                repairTickTime = 100;
                break;
            }
            case 7: {
                repairTickTime = 80;
                break;
            }
            case 8: {
                repairTickTime = 60;
                break;
            }
            case 9: {
                repairTickTime = 40;
                break;
            }
            case 10: {
                repairTickTime = 20;
            }
        }
        return repairTickTime;
    }

    @SubscribeEvent
    public static void onRightClickItem(PlayerInteractEvent.RightClickItem event) {
        boolean isTeleporting;
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        ItemStack tool = player.getItemInHand(hand);
        boolean requiresCastingOverrides = isTeleporting = tool.getComponents().keySet().contains(CastingDataComponents.TELEPORTING.get());
        if (!level.isClientSide() && requiresCastingOverrides && isTeleporting) {
            ToolEvents.doTeleportation(tool, player, level);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        boolean isTorchPlacing;
        Level level = event.getLevel();
        Player player = event.getEntity();
        BlockPos pos = event.getPos();
        InteractionHand hand = event.getHand();
        ItemStack tool = player.getItemInHand(hand);
        boolean requiresCastingOverrides = isTorchPlacing = tool.getComponents().keySet().contains(CastingDataComponents.TORCH_PLACING.get());
        if (!level.isClientSide() && requiresCastingOverrides && isTorchPlacing) {
            Direction face = event.getFace();
            assert (face != null);
            BlockPos placePos = pos.relative(face);
            if (!level.getBlockState(placePos).canBeReplaced()) {
                return;
            }
            if (face == Direction.UP) {
                if (level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
                    level.setBlockAndUpdate(placePos, Blocks.TORCH.defaultBlockState());
                    tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
                }
            } else if (face.getAxis().isHorizontal() && level.getBlockState(pos).isFaceSturdy((BlockGetter)level, pos, face)) {
                BlockState wallTorch = (BlockState)Blocks.WALL_TORCH.defaultBlockState().setValue((Property)WallTorchBlock.FACING, (Comparable)face);
                level.setBlockAndUpdate(placePos, wallTorch);
                tool.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDrops(LivingDropsEvent event) {
        Level level = event.getEntity().level();
        LivingEntity deadEntity = event.getEntity();
        DamageSource damageSource = event.getSource();
        LivingEntity killer = event.getEntity().getKillCredit();
        if (killer instanceof Player) {
            boolean requiresCastingOverrides;
            ItemStack stack = killer.getWeaponItem();
            if (stack.isEmpty()) {
                return;
            }
            List<Object> loot = new ArrayList();
            boolean isLooting = stack.getComponents().keySet().contains(CastingDataComponents.LOOTING.get());
            boolean isBeheading = stack.getComponents().keySet().contains(CastingDataComponents.BEHEADING.get());
            boolean bl = requiresCastingOverrides = isLooting || isBeheading;
            if (!level.isClientSide() && requiresCastingOverrides) {
                if (isLooting) {
                    event.setCanceled(true);
                    LootTable lootTable = Objects.requireNonNull(level.getServer()).reloadableRegistries().getLootTable(deadEntity.getLootTable());
                    int lootingLevel = (Integer)stack.getComponents().getOrDefault((DataComponentType)CastingDataComponents.LOOTING.get(), (Object)0);
                    ItemStack fakeItemStack = stack.copy();
                    fakeItemStack.enchant(ToolEvents.toHolder(level, (ResourceKey<Enchantment>)Enchantments.LOOTING), lootingLevel);
                    loot = ToolEvents.getMobLootDrops((Entity)deadEntity, (Player)killer, damageSource, fakeItemStack, lootTable, level);
                }
                if (isBeheading) {
                    Optional<ItemStack> customHead = BeheadingHeadMap.getHeadForEntity((Entity)deadEntity);
                    customHead.ifPresent(loot::add);
                }
                for (ItemStack itemStack : loot) {
                    ToolEvents.popOutTheItem(level, deadEntity.blockPosition(), itemStack);
                }
            }
        }
    }

    public static void doTeleportation(ItemStack tool, Player player, Level level) {
        Vec3 end;
        int ADDITIONAL_BLOCKS_PER_LEVEL = (Integer)EquipmentModifierConfig.blocksPerLevelForTeleporting.get();
        int range = (Integer)tool.getComponents().getOrDefault((DataComponentType)CastingDataComponents.TELEPORTING.get(), (Object)0) * ADDITIONAL_BLOCKS_PER_LEVEL;
        Vec3 lookVec = player.getLookAngle();
        Vec3 start = player.getEyePosition();
        BlockHitResult hit = level.clip(new ClipContext(start, end = start.add(lookVec.scale((double)range)), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.getType() == HitResult.Type.BLOCK) {
            Vec3 targetPos;
            BlockPos hitPos = hit.getBlockPos();
            Direction hitDir = hit.getDirection();
            if (hitDir == Direction.UP) {
                targetPos = Vec3.atCenterOf((Vec3i)hitPos.above()).subtract(0.0, 0.5, 0.0);
            } else if (hitDir == Direction.DOWN) {
                targetPos = Vec3.atCenterOf((Vec3i)hitPos.below()).subtract(0.0, 0.5, 0.0);
            } else {
                Vec3 faceOffset = Vec3.atLowerCornerOf((Vec3i)hitDir.getNormal()).scale(1.0);
                targetPos = Vec3.atCenterOf((Vec3i)hitPos).add(faceOffset).subtract(0.0, 1.5, 0.0);
            }
            BlockPos teleportPos = BlockPos.containing((Position)targetPos);
            Vec3 preTeleportPos = player.position();
            if (level.getBlockState(teleportPos).isAir() && level.getBlockState(teleportPos.above()).isAir()) {
                player.teleportTo(targetPos.x, targetPos.y, targetPos.z);
                level.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
                player.getCooldowns().addCooldown(tool.getItem(), ((Integer)EquipmentModifierConfig.cooldownForTeleporting.get()).intValue());
                tool.hurtAndBreak(5, (LivingEntity)player, EquipmentSlot.MAINHAND);
                for (int i = 0; i < 32; ++i) {
                    double offsetX = level.random.nextDouble() - 0.5;
                    double offsetY = level.random.nextDouble() * 2.0;
                    double offsetZ = level.random.nextDouble() - 0.5;
                    if (!(level instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, player.getX() + offsetX, player.getY() + offsetY, player.getZ() + offsetZ, 8, 0.0, 0.5, 0.0, 0.0);
                    serverLevel.sendParticles((ParticleOptions)ParticleTypes.SMOKE, preTeleportPos.x + offsetX, preTeleportPos.y + offsetY, preTeleportPos.z + offsetZ, 8, 0.0, 0.5, 0.0, 0.0);
                }
            }
        }
    }

    public static List<ItemStack> getMobLootDrops(Entity deadEntity, Player player, DamageSource damageSource, ItemStack stack, LootTable lootTable, Level level) {
        FakePlayer fakePlayer = FakePlayerUtil.createFakePlayer((ServerLevel)((ServerLevel)level), (String)"FakePlayerForLooting");
        fakePlayer.setItemInHand(InteractionHand.MAIN_HAND, stack);
        LootParams.Builder lootParams = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.THIS_ENTITY, (Object)deadEntity).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)deadEntity.getOnPos())).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)damageSource).withParameter(LootContextParams.ATTACKING_ENTITY, (Object)fakePlayer);
        LootParams lootParamsFinal = lootParams.create(LootContextParamSets.ENTITY);
        return lootTable.getRandomItems(lootParamsFinal);
    }

    public static void popOutTheItem(Level level, BlockPos blockPos, ItemStack itemStack) {
        Vec3 vec3 = Vec3.atLowerCornerWithOffset((Vec3i)blockPos, (double)0.5, (double)1.1, (double)0.5).offsetRandom(level.random, 0.7f);
        ItemStack itemstack1 = itemStack.copy();
        ItemEntity itementity = new ItemEntity(level, vec3.x(), vec3.y(), vec3.z(), itemstack1);
        itementity.setDefaultPickUpDelay();
        level.addFreshEntity((Entity)itementity);
    }

    public static Holder<Enchantment> toHolder(Level level, ResourceKey<Enchantment> enchantment) {
        return level.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantment);
    }
}

