/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.item;

import com.benbenlaw.casting.util.CastingTags;
import com.benbenlaw.casting.util.ValidToolTypesForToolModifiers;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.fml.ModList;

public class EquipmentModifierItem
extends Item {
    private final String tooltip;
    private final int maxLevel;

    public EquipmentModifierItem(Item.Properties properties, String tooltip, int maxLevel) {
        super(properties);
        this.tooltip = tooltip;
        this.maxLevel = maxLevel;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> components, TooltipFlag flag) {
        boolean requireShiftToDisableTooltip = stack.is(CastingTags.Items.CAN_BE_DISABLED_WITH_SHIFT);
        if (Screen.hasShiftDown()) {
            components.add((Component)Component.translatable((String)this.tooltip, (Object[])new Object[]{this.maxLevel}).withStyle(ChatFormatting.YELLOW));
            if (requireShiftToDisableTooltip) {
                components.add((Component)Component.translatable((String)"tooltips.casting.information.shift_to_disable").withStyle(ChatFormatting.RED));
            }
            components.add((Component)Component.translatable((String)"tooltips.casting.information.valid_tool_types").withStyle(ChatFormatting.GOLD));
            String effect = BuiltInRegistries.ITEM.getKey((Object)this).getPath();
            List<String> validToolTypes = ValidToolTypesForToolModifiers.VALID_MODIFIERS.entrySet().stream().filter(entry -> {
                String key = (String)entry.getKey();
                if (key.equals("all_modifiers")) {
                    return false;
                }
                if (key.equals("paxel_modifiers") && !ModList.get().isLoaded("mekanismtools")) {
                    return false;
                }
                return ((List)entry.getValue()).contains(effect);
            }).map(Map.Entry::getKey).toList();
            for (String toolType : validToolTypes) {
                components.add((Component)Component.translatable((String)("tooltips.casting." + toolType)).withStyle(ChatFormatting.BLUE));
            }
        } else {
            components.add((Component)Component.translatable((String)"tooltips.bblcore.shift").withStyle(ChatFormatting.YELLOW));
        }
    }
}

