/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.network.packet;

import com.benbenlaw.casting.block.entity.ControllerBlockEntity;
import com.benbenlaw.casting.block.entity.EquipmentModifierBlockEntity;
import com.benbenlaw.casting.block.entity.MixerBlockEntity;
import com.benbenlaw.casting.block.entity.SolidifierBlockEntity;
import com.benbenlaw.casting.item.CastingDataComponents;
import com.benbenlaw.casting.network.payload.FluidMoverPayload;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@Deprecated(since="2.0.0")
public record FluidMoverPacket() {
    public static final FluidMoverPacket INSTANCE = new FluidMoverPacket();

    public static FluidMoverPacket get() {
        return INSTANCE;
    }

    public void handle(FluidMoverPayload payload, IPayloadContext context) {
        boolean isOutputTank;
        FluidTank selectedTank;
        Player player = context.player();
        Level level = player.level();
        BlockPos blockPos = payload.blockPos();
        BlockState blockState = level.getBlockState(blockPos);
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        int tankNumber = payload.tankID();
        ItemStack carriedItem = player.containerMenu.getCarried();
        int maxItemFluidCap = 8000;
        if (blockEntity instanceof MixerBlockEntity) {
            MixerBlockEntity mixerBlockEntity = (MixerBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = false;
            switch (tankNumber) {
                case 1: {
                    selectedTank = mixerBlockEntity.TANK_1;
                    break;
                }
                case 2: {
                    selectedTank = mixerBlockEntity.TANK_2;
                    break;
                }
                case 3: {
                    selectedTank = mixerBlockEntity.TANK_3;
                    break;
                }
                case 4: {
                    selectedTank = mixerBlockEntity.TANK_4;
                    break;
                }
                case 5: {
                    selectedTank = mixerBlockEntity.TANK_5;
                    break;
                }
                case 6: {
                    selectedTank = mixerBlockEntity.TANK_6;
                    break;
                }
                case 7: {
                    selectedTank = mixerBlockEntity.OUTPUT_TANK;
                    isOutputTank = true;
                    break;
                }
                default: {
                    player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                    return;
                }
            }
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
        }
        if (blockEntity instanceof ControllerBlockEntity) {
            ControllerBlockEntity controllerBlockEntity = (ControllerBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = true;
            switch (tankNumber) {
                case 1: {
                    selectedTank = controllerBlockEntity.TANK_1;
                    break;
                }
                case 2: {
                    selectedTank = controllerBlockEntity.TANK_2;
                    break;
                }
                case 3: {
                    selectedTank = controllerBlockEntity.TANK_3;
                    break;
                }
                case 4: {
                    selectedTank = controllerBlockEntity.TANK_4;
                    break;
                }
                default: {
                    player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                    return;
                }
            }
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
        }
        if (blockEntity instanceof SolidifierBlockEntity) {
            SolidifierBlockEntity solidifierBlockEntity = (SolidifierBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = false;
            if (tankNumber != 1) {
                player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                return;
            }
            selectedTank = solidifierBlockEntity.TANK;
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
        }
        if (blockEntity instanceof EquipmentModifierBlockEntity) {
            EquipmentModifierBlockEntity equipmentModifierBlockEntity = (EquipmentModifierBlockEntity)blockEntity;
            selectedTank = null;
            isOutputTank = false;
            if (tankNumber != 1) {
                player.sendSystemMessage((Component)Component.literal((String)"Invalid tank number!"));
                return;
            }
            selectedTank = equipmentModifierBlockEntity.TANK;
            this.transferFluidBetweenTankAndItem(selectedTank, carriedItem, player, isOutputTank);
        }
    }

    private void transferFluidBetweenTankAndItem(FluidTank tank, ItemStack carriedItem, Player player, boolean isOutputTank) {
        int itemMaxCapacity = 8000;
        if (carriedItem.get(CastingDataComponents.FLUID_TYPE) != null) {
            String fluidAsString = (String)carriedItem.get(CastingDataComponents.FLUID_TYPE);
            assert (fluidAsString != null);
            Fluid carriedFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString));
            int carriedAmount = (Integer)carriedItem.get(CastingDataComponents.FLUID_AMOUNT);
            if (!isOutputTank) {
                if (tank.isEmpty() || tank.getFluid().getFluid().equals(carriedFluid)) {
                    int availableTankSpace = tank.getCapacity() - tank.getFluidAmount();
                    int amountToTransfer = Math.min(carriedAmount, availableTankSpace);
                    if (amountToTransfer > 0) {
                        tank.fill(new FluidStack(carriedFluid, amountToTransfer), IFluidHandler.FluidAction.EXECUTE);
                        carriedItem.set(CastingDataComponents.FLUID_AMOUNT, (Object)(carriedAmount - amountToTransfer));
                        if ((Integer)carriedItem.get(CastingDataComponents.FLUID_AMOUNT) <= 0) {
                            carriedItem.remove(CastingDataComponents.FLUID_TYPE);
                            carriedItem.remove(CastingDataComponents.FLUID_AMOUNT);
                        }
                        return;
                    }
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Fluid types don't match!"));
                }
            } else {
                player.sendSystemMessage((Component)Component.literal((String)"Cannot add fluids to the output tank!"));
            }
        }
        if (!tank.isEmpty()) {
            FluidStack currentFluidInTank = tank.getFluid();
            if (carriedItem.get(CastingDataComponents.FLUID_TYPE) == null) {
                int transferAmount = Math.min(currentFluidInTank.getAmount(), itemMaxCapacity);
                carriedItem.set(CastingDataComponents.FLUID_TYPE, (Object)currentFluidInTank.getFluid().getFluidType().toString());
                carriedItem.set(CastingDataComponents.FLUID_AMOUNT, (Object)transferAmount);
                tank.setFluid(new FluidStack(currentFluidInTank.getFluid(), currentFluidInTank.getAmount() - transferAmount));
            } else if (carriedItem.get(CastingDataComponents.FLUID_TYPE) != null) {
                String fluidAsString = (String)carriedItem.get(CastingDataComponents.FLUID_TYPE);
                assert (fluidAsString != null);
                Fluid carriedFluid = (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.tryParse((String)fluidAsString));
                int carriedAmount = (Integer)carriedItem.get(CastingDataComponents.FLUID_AMOUNT);
                if (carriedFluid.equals(currentFluidInTank.getFluid())) {
                    int remainingCapacity = itemMaxCapacity - carriedAmount;
                    int currentTankAmount = currentFluidInTank.getAmount();
                    int amountToTransfer = Math.min(currentTankAmount, remainingCapacity);
                    if (amountToTransfer > 0) {
                        carriedItem.set(CastingDataComponents.FLUID_AMOUNT, (Object)(carriedAmount + amountToTransfer));
                        tank.setFluid(new FluidStack(currentFluidInTank.getFluid(), currentTankAmount - amountToTransfer));
                    }
                } else {
                    player.sendSystemMessage((Component)Component.literal((String)"Fluid types don't match!"));
                }
            }
        }
    }
}

