/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.screen;

import com.benbenlaw.casting.block.entity.TankBlockEntity;
import com.benbenlaw.casting.item.CastingItems;
import com.benbenlaw.casting.network.payload.ClearTankPayload;
import com.benbenlaw.casting.network.payload.FluidMoverPayload;
import com.benbenlaw.casting.network.payload.LockSolidifierPayload;
import com.benbenlaw.casting.screen.SolidifierMenu;
import com.benbenlaw.casting.screen.util.FluidStackWidgetBigTank;
import com.benbenlaw.casting.screen.util.FuelTankFluidStackWidget;
import com.benbenlaw.core.util.MouseUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.network.PacketDistributor;

public class SolidifierScreen
extends AbstractContainerScreen<SolidifierMenu> {
    private Level level;
    private BlockEntity fuelTankEntity;
    private static final ResourceLocation TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"casting", (String)"textures/gui/solidifier_gui.png");

    public SolidifierScreen(SolidifierMenu menu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)menu, inventory, component);
        this.level = menu.level;
        for (Direction direction : Direction.values()) {
            BlockEntity adjacentEntity = this.level.getBlockEntity(menu.blockEntity.getBlockPos().relative(direction));
            if (adjacentEntity instanceof TankBlockEntity) {
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                this.fuelTankEntity = this.level.getBlockEntity(tankBlockEntity.getBlockPos());
                break;
            }
            this.fuelTankEntity = null;
        }
    }

    protected void init() {
        super.init();
        this.addFluidWidgets();
    }

    private void addFluidWidgets() {
        this.addRenderableOnly((Renderable)new FluidStackWidgetBigTank((Screen)this, ((SolidifierMenu)this.getMenu()).blockEntity.TANK, this.leftPos + 27, this.topPos + 15, 14, 56));
        FluidTank fuelTank = new FluidTank(0);
        BlockEntity blockEntity = this.fuelTankEntity;
        if (blockEntity instanceof TankBlockEntity) {
            TankBlockEntity tankBlockEntity = (TankBlockEntity)blockEntity;
            fuelTank = tankBlockEntity.FLUID_TANK;
        }
        if (fuelTank.getCapacity() != 0 && fuelTank.getFluidAmount() != 0) {
            this.addRenderableOnly((Renderable)new FuelTankFluidStackWidget((Screen)this, fuelTank, ((SolidifierMenu)this.menu).blockEntity, this.leftPos + 107, this.topPos + 55, 16, 16));
        }
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        this.renderProgressBars(guiGraphics);
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x, y, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderProgressBars(guiGraphics);
        FluidTank fuelTank = new FluidTank(0);
        BlockEntity blockEntity = this.fuelTankEntity;
        if (blockEntity instanceof TankBlockEntity) {
            TankBlockEntity tankBlockEntity = (TankBlockEntity)blockEntity;
            fuelTank = tankBlockEntity.FLUID_TANK;
        }
        if (fuelTank.getCapacity() == 0) {
            this.renderNoTank(guiGraphics, mouseX, mouseY, x, y);
        } else if (fuelTank.getFluidAmount() == 0) {
            this.renderEmptyTank(guiGraphics, mouseX, mouseY, x, y);
        }
        this.renderWarning(guiGraphics, mouseX, mouseY);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderFilteredFluid(guiGraphics, mouseX, mouseY);
    }

    private void renderProgressBars(GuiGraphics guiGraphics) {
        int x = this.leftPos;
        int y = this.topPos;
        guiGraphics.blit(TEXTURE, x + 104, y + 34, 176, 30, ((SolidifierMenu)this.menu).getScaledProgress(), 16);
    }

    private void renderTickRate(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)80, (int)36, (int)90, (int)16)) {
            guiGraphics.drawString(this.font, ((SolidifierMenu)this.menu).blockEntity.maxProgress + " ticks", this.leftPos + 120, this.topPos + 68, 0x3F3F3F, false);
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        boolean handled = super.mouseClicked(mouseX, mouseY, mouseButton);
        ItemStack heldItem = ((SolidifierMenu)this.menu).getCarried();
        boolean isHoldingBucket = heldItem.is(CastingItems.FLUID_MOVER);
        int tankX = this.leftPos + 27;
        int tankY = this.topPos + 15;
        int tankWidth = 14;
        int tankHeight = 56;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX, (int)tankY, (int)tankWidth, (int)tankHeight)) {
            int tank = ((SolidifierMenu)this.menu).blockEntity.TANK.getTanks();
            boolean hasShiftDown = SolidifierScreen.hasShiftDown();
            if (isHoldingBucket) {
                PacketDistributor.sendToServer((CustomPacketPayload)new FluidMoverPayload(((SolidifierMenu)this.menu).blockEntity.getBlockPos(), tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            } else {
                PacketDistributor.sendToServer((CustomPacketPayload)new ClearTankPayload(((SolidifierMenu)this.menu).blockEntity.getBlockPos(), hasShiftDown, tank), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)(this.leftPos + 6), (int)(this.topPos + 36), (int)16, (int)16)) {
            PacketDistributor.sendToServer((CustomPacketPayload)new LockSolidifierPayload(((SolidifierMenu)this.menu).blockEntity.getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        return handled;
    }

    private void renderWarning(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int tankX = this.leftPos + 27;
        int tankY = this.topPos + 15;
        int tankWidth = 14;
        int tankHeight = 56;
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)tankX, (int)tankY, (int)tankWidth, (int)tankHeight) && SolidifierScreen.hasShiftDown()) {
            guiGraphics.renderTooltip(this.font, (Component)Component.translatable((String)"screen.casting.warning").withStyle(ChatFormatting.RED), mouseX, mouseY - 14);
        }
    }

    private void renderFilteredFluid(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        if (MouseUtil.isMouseOver((double)mouseX, (double)mouseY, (int)(this.leftPos + 6), (int)(this.topPos + 36), (int)16, (int)16)) {
            boolean limitMode = ((SolidifierMenu)this.menu).blockEntity.getLimitMode();
            if (limitMode) {
                guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Locking in 100mb of Fluid! Click to toggle").withStyle(ChatFormatting.GREEN), mouseX, mouseY);
            } else {
                guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Not Filtering Fluid! Click to toggle").withStyle(ChatFormatting.RED), mouseX, mouseY);
            }
        }
    }

    private void renderNoTank(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)107, (int)55, (int)16, (int)16)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Place a Tank adjacent to the Solidifier to increase speed!").withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
    }

    private void renderEmptyTank(GuiGraphics guiGraphics, int mouseX, int mouseY, int x, int y) {
        if (MouseUtil.isMouseAboveArea((int)mouseX, (int)mouseY, (int)x, (int)y, (int)107, (int)55, (int)16, (int)16)) {
            guiGraphics.renderTooltip(this.font, (Component)Component.literal((String)"Use cooler fuels in tank to speed up the Solidifier!").withStyle(ChatFormatting.RED), mouseX, mouseY);
        }
    }
}

