/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.EquipmentModifierBlockEntity;
import com.benbenlaw.casting.block.entity.SolidifierBlockEntity;
import com.benbenlaw.casting.block.entity.TankBlockEntity;
import com.benbenlaw.casting.recipe.FuelRecipe;
import com.benbenlaw.casting.recipe.MixingRecipe;
import com.benbenlaw.casting.screen.MixerMenu;
import com.benbenlaw.core.recipe.NoInventoryRecipe;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.fluids.FluidActionResult;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MixerBlockEntity
extends BlockEntity
implements MenuProvider {
    public final FluidTank TANK_1 = new FluidTank(8000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_2 = new FluidTank(8000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_3 = new FluidTank(8000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_4 = new FluidTank(8000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_5 = new FluidTank(8000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank TANK_6 = new FluidTank(8000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank OUTPUT_TANK = new FluidTank(16000){

        protected void onContentsChanged() {
            MixerBlockEntity.this.setChanged();
            MixerBlockEntity.this.sync();
        }
    };
    public final FluidTank[] tanks = new FluidTank[]{this.TANK_1, this.TANK_2, this.TANK_3, this.TANK_4, this.TANK_5, this.TANK_6};
    public final IFluidHandler fluidHandler = new IFluidHandler(){

        public int getTanks() {
            return 7;
        }

        public FluidStack getFluidInTank(int tank) {
            return switch (tank) {
                case 0 -> MixerBlockEntity.this.TANK_1.getFluid();
                case 1 -> MixerBlockEntity.this.TANK_2.getFluid();
                case 2 -> MixerBlockEntity.this.TANK_3.getFluid();
                case 3 -> MixerBlockEntity.this.TANK_4.getFluid();
                case 4 -> MixerBlockEntity.this.TANK_5.getFluid();
                case 5 -> MixerBlockEntity.this.TANK_6.getFluid();
                case 6 -> MixerBlockEntity.this.OUTPUT_TANK.getFluid();
                default -> FluidStack.EMPTY;
            };
        }

        public int getTankCapacity(int tank) {
            return switch (tank) {
                case 0 -> MixerBlockEntity.this.TANK_1.getCapacity();
                case 1 -> MixerBlockEntity.this.TANK_2.getCapacity();
                case 2 -> MixerBlockEntity.this.TANK_3.getCapacity();
                case 3 -> MixerBlockEntity.this.TANK_4.getCapacity();
                case 4 -> MixerBlockEntity.this.TANK_5.getCapacity();
                case 5 -> MixerBlockEntity.this.TANK_6.getCapacity();
                case 6 -> MixerBlockEntity.this.OUTPUT_TANK.getCapacity();
                default -> 0;
            };
        }

        public boolean isFluidValid(int tank, FluidStack stack) {
            return switch (tank) {
                case 0 -> MixerBlockEntity.this.TANK_1.isFluidValid(stack);
                case 1 -> MixerBlockEntity.this.TANK_2.isFluidValid(stack);
                case 2 -> MixerBlockEntity.this.TANK_3.isFluidValid(stack);
                case 3 -> MixerBlockEntity.this.TANK_4.isFluidValid(stack);
                case 4 -> MixerBlockEntity.this.TANK_5.isFluidValid(stack);
                case 5 -> MixerBlockEntity.this.TANK_6.isFluidValid(stack);
                case 6 -> MixerBlockEntity.this.OUTPUT_TANK.isFluidValid(stack);
                default -> false;
            };
        }

        public int fill(@NotNull FluidStack resource, @NotNull IFluidHandler.FluidAction action) {
            for (FluidTank tank : new FluidTank[]{MixerBlockEntity.this.TANK_1, MixerBlockEntity.this.TANK_2, MixerBlockEntity.this.TANK_3, MixerBlockEntity.this.TANK_4, MixerBlockEntity.this.TANK_5, MixerBlockEntity.this.TANK_6}) {
                if (tank.getFluid().isEmpty() || !tank.getFluid().getFluid().isSame(resource.getFluid())) continue;
                int spaceLeft = tank.getCapacity() - tank.getFluidAmount();
                int amountToFill = Math.min(resource.getAmount(), spaceLeft);
                if (amountToFill > 0) {
                    FluidStack resourceToFill = resource.copy();
                    resourceToFill.setAmount(amountToFill);
                    return tank.fill(resourceToFill, action);
                }
                return 0;
            }
            for (FluidTank tank : new FluidTank[]{MixerBlockEntity.this.TANK_1, MixerBlockEntity.this.TANK_2, MixerBlockEntity.this.TANK_3, MixerBlockEntity.this.TANK_4, MixerBlockEntity.this.TANK_5, MixerBlockEntity.this.TANK_6}) {
                int amountToFill;
                if (!tank.isFluidValid(resource) || !tank.getFluid().isEmpty() || (amountToFill = Math.min(resource.getAmount(), tank.getCapacity())) <= 0) continue;
                FluidStack resourceToFill = resource.copy();
                resourceToFill.setAmount(amountToFill);
                return tank.fill(resourceToFill, action);
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (resource.getFluid().isSame(MixerBlockEntity.this.OUTPUT_TANK.getFluid().getFluid())) {
                return MixerBlockEntity.this.OUTPUT_TANK.drain(resource.getAmount(), action);
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            FluidStack drained = MixerBlockEntity.this.OUTPUT_TANK.drain(maxDrain, action);
            if (!drained.isEmpty()) {
                return drained;
            }
            return FluidStack.EMPTY;
        }
    };
    public final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> MixerBlockEntity.this.progress;
                case 1 -> MixerBlockEntity.this.maxProgress;
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    MixerBlockEntity.this.progress = value;
                    break;
                }
                case 1: {
                    MixerBlockEntity.this.maxProgress = value;
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };
    public int progress = 0;
    public int maxProgress = 220;
    public int fuelTemp = 0;
    public int totalWhisksAbove = 0;

    public boolean onPlayerUse(Player player, InteractionHand hand) {
        ItemStack filledContainer;
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.isEmpty()) {
            return false;
        }
        FluidActionResult result = FluidUtil.tryFillContainer((ItemStack)heldItem, (IFluidHandler)this.OUTPUT_TANK, (int)1000, null, (boolean)true);
        if (result.isSuccess() && !ItemStack.matches((ItemStack)heldItem, (ItemStack)(filledContainer = result.getResult()))) {
            player.setItemInHand(hand, filledContainer);
            return true;
        }
        FluidTank[] inputTanks = new FluidTank[]{this.TANK_1, this.TANK_2, this.TANK_3, this.TANK_4, this.TANK_5, this.TANK_6};
        if (FluidUtil.getFluidContained((ItemStack)heldItem).isPresent()) {
            FluidStack fluidInBucket = (FluidStack)FluidUtil.getFluidContained((ItemStack)heldItem).get();
            FluidTank[] fluidTankArray = inputTanks;
            int n = fluidTankArray.length;
            for (int i = 0; i < n; ++i) {
                FluidTank tank = fluidTankArray[i];
                if (!FluidStack.isSameFluidSameComponents((FluidStack)tank.getFluid(), (FluidStack)fluidInBucket) || tank.getFluidAmount() < tank.getCapacity()) continue;
                return false;
            }
        }
        for (FluidTank tank : inputTanks) {
            if (!FluidUtil.interactWithFluidHandler((Player)player, (InteractionHand)hand, (IFluidHandler)tank)) continue;
            return true;
        }
        return false;
    }

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return this.fluidHandler;
    }

    public void sync() {
        ServerLevel serverLevel;
        LevelChunk chunk;
        ChunkSource chunkSource;
        Level level = this.level;
        if (level instanceof ServerLevel && (chunkSource = Objects.requireNonNull((chunk = (serverLevel = (ServerLevel)level).getChunkAt(this.getBlockPos())).getLevel()).getChunkSource()) instanceof ServerChunkCache) {
            ServerChunkCache chunkCache = (ServerChunkCache)chunkSource;
            chunkCache.chunkMap.getPlayers(chunk.getPos(), false).forEach(this::syncContents);
        }
    }

    public void syncContents(ServerPlayer player) {
        player.connection.send(Objects.requireNonNull(this.getUpdatePacket()));
    }

    public void setFluid1(FluidStack stack) {
        this.TANK_1.setFluid(stack);
    }

    public void getFluid1(FluidStack stack) {
        this.TANK_1.setFluid(stack);
    }

    public FluidStack getFluidStack1() {
        return this.TANK_1.getFluid();
    }

    public void setFluid2(FluidStack stack) {
        this.TANK_2.setFluid(stack);
    }

    public void getFluid2(FluidStack stack) {
        this.TANK_2.setFluid(stack);
    }

    public FluidStack getFluidStack2() {
        return this.TANK_2.getFluid();
    }

    public void setFluid3(FluidStack stack) {
        this.TANK_3.setFluid(stack);
    }

    public void getFluid3(FluidStack stack) {
        this.TANK_3.setFluid(stack);
    }

    public FluidStack getFluidStack3() {
        return this.TANK_3.getFluid();
    }

    public void setFluid4(FluidStack stack) {
        this.TANK_4.setFluid(stack);
    }

    public void getFluid4(FluidStack stack) {
        this.TANK_4.setFluid(stack);
    }

    public FluidStack getFluidStack4() {
        return this.TANK_4.getFluid();
    }

    public void setFluid5(FluidStack stack) {
        this.TANK_5.setFluid(stack);
    }

    public void getFluid5(FluidStack stack) {
        this.TANK_5.setFluid(stack);
    }

    public FluidStack getFluidStack5() {
        return this.TANK_5.getFluid();
    }

    public void setFluid6(FluidStack stack) {
        this.TANK_6.setFluid(stack);
    }

    public void getFluid6(FluidStack stack) {
        this.TANK_6.setFluid(stack);
    }

    public FluidStack getFluidStack6() {
        return this.TANK_6.getFluid();
    }

    public void setOutputFluid(FluidStack stack) {
        this.OUTPUT_TANK.setFluid(stack);
    }

    public void getOutputFluid(FluidStack stack) {
        this.OUTPUT_TANK.setFluid(stack);
    }

    public FluidStack getOutputFluid() {
        return this.OUTPUT_TANK.getFluid();
    }

    public MixerBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.MIXER_BLOCK_ENTITY.get(), pos, state);
    }

    public Component getDisplayName() {
        return Component.translatable((String)"block.casting.mixer");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MixerMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void onLoad() {
        super.onLoad();
        this.setChanged();
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void handleUpdateTag(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.loadAdditional(compoundTag, provider);
    }

    @NotNull
    public CompoundTag getUpdateTag(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        CompoundTag compoundTag = new CompoundTag();
        this.saveAdditional(compoundTag, provider);
        return compoundTag;
    }

    public void onDataPacket(@NotNull Connection connection, @NotNull ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.onDataPacket(connection, clientboundBlockEntityDataPacket, provider);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        compoundTag.putInt("totalWhisksAbove", this.totalWhisksAbove);
        compoundTag.put("tank1", (Tag)this.TANK_1.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank2", (Tag)this.TANK_2.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank3", (Tag)this.TANK_3.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank4", (Tag)this.TANK_4.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank5", (Tag)this.TANK_5.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("tank6", (Tag)this.TANK_6.writeToNBT(provider, new CompoundTag()));
        compoundTag.put("output_tank", (Tag)this.OUTPUT_TANK.writeToNBT(provider, new CompoundTag()));
        compoundTag.putInt("fuelTemp", this.fuelTemp);
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.totalWhisksAbove = compoundTag.getInt("totalWhisksAbove");
        this.TANK_1.readFromNBT(provider, compoundTag.getCompound("tank1"));
        this.TANK_2.readFromNBT(provider, compoundTag.getCompound("tank2"));
        this.TANK_3.readFromNBT(provider, compoundTag.getCompound("tank3"));
        this.TANK_4.readFromNBT(provider, compoundTag.getCompound("tank4"));
        this.TANK_5.readFromNBT(provider, compoundTag.getCompound("tank5"));
        this.TANK_6.readFromNBT(provider, compoundTag.getCompound("tank6"));
        this.OUTPUT_TANK.readFromNBT(provider, compoundTag.getCompound("output_tank"));
        this.fuelTemp = compoundTag.getInt("fuelTemp");
        super.loadAdditional(compoundTag, provider);
    }

    public void drops() {
    }

    public void tick() {
        assert (this.level != null);
        if (!this.level.isClientSide()) {
            BlockEntity entity;
            for (Direction direction : Direction.values()) {
                entity = this.level.getBlockEntity(this.worldPosition.relative(direction));
                if (!(entity instanceof SolidifierBlockEntity)) continue;
                SolidifierBlockEntity solidifierBlockEntity = (SolidifierBlockEntity)entity;
                this.transferFluid((IFluidTank)this.OUTPUT_TANK, (IFluidTank)solidifierBlockEntity.TANK);
            }
            for (Direction direction : Direction.values()) {
                entity = this.level.getBlockEntity(this.worldPosition.relative(direction));
                if (!(entity instanceof EquipmentModifierBlockEntity)) continue;
                EquipmentModifierBlockEntity toolModifierBlockEntity = (EquipmentModifierBlockEntity)entity;
                this.transferFluid((IFluidTank)this.OUTPUT_TANK, (IFluidTank)toolModifierBlockEntity.TANK);
            }
            this.whiskCheck();
            this.drainTanksIntoValidBlocks();
            this.fuelInformation(this.level.getBlockEntity(this.worldPosition));
            this.sync();
            for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)MixingRecipe.Type.INSTANCE, (RecipeInput)NoInventoryRecipe.INSTANCE, this.level)) {
                MixingRecipe recipe = (MixingRecipe)recipeHolder.value();
                List<FluidStack> requiredFluids = recipe.getAllFluids();
                requiredFluids.removeIf(FluidStack::isEmpty);
                Map<FluidStack, Integer> matchedTanks = this.checkFluidCombinations(requiredFluids);
                if (matchedTanks == null || !this.hasOutputSpaceMaking(this, recipe)) continue;
                ++this.progress;
                if (this.progress < this.maxProgress) continue;
                this.addOutputFluid(recipe.outputFluid());
                this.removeTankFluids(matchedTanks);
                this.setChanged();
                this.resetProgress();
                this.sync();
            }
        }
    }

    public void whiskCheck() {
        this.maxProgress = 220;
        int whiskEffectAmount = 40;
        BlockPos aboveMixer = this.getBlockPos().above();
        this.totalWhisksAbove = 0;
        while (true) {
            assert (this.level != null);
            if (!this.level.getBlockState(aboveMixer).is((Block)CastingBlocks.MIXER_WHISK.get())) break;
            ++this.totalWhisksAbove;
            aboveMixer = aboveMixer.above();
        }
        this.maxProgress -= this.totalWhisksAbove * whiskEffectAmount;
        if (this.maxProgress < 20) {
            this.maxProgress = 20;
        }
    }

    private void drainTanksIntoValidBlocks() {
        for (Direction direction : Direction.values()) {
            BlockEntity entity = this.level.getBlockEntity(this.worldPosition.relative(direction));
            if (!(entity instanceof SolidifierBlockEntity)) continue;
            SolidifierBlockEntity solidifierBlockEntity = (SolidifierBlockEntity)entity;
            this.transferFluid((IFluidTank)this.OUTPUT_TANK, (IFluidTank)solidifierBlockEntity.TANK);
        }
    }

    private void removeTankFluids(Map<FluidStack, Integer> matchedTanks) {
        for (Map.Entry<FluidStack, Integer> entry : matchedTanks.entrySet()) {
            FluidStack requiredFluid = entry.getKey();
            int tankIndex = entry.getValue();
            FluidStack tankFluid = this.tanks[tankIndex].getFluid();
            tankFluid.shrink(requiredFluid.getAmount());
            this.tanks[tankIndex].setFluid(tankFluid);
        }
    }

    private Map<FluidStack, Integer> checkFluidCombinations(List<FluidStack> requiredFluids) {
        List<List<Integer>> combinations = this.generateCombinations(6);
        for (List<Integer> combination : combinations) {
            Map<FluidStack, Integer> matchedTanks = this.checkFluidsInCombination(requiredFluids, combination);
            if (matchedTanks == null) continue;
            return matchedTanks;
        }
        return null;
    }

    private List<List<Integer>> generateCombinations(int n) {
        ArrayList<List<Integer>> combinations = new ArrayList<List<Integer>>();
        int[] currentCombination = new int[n];
        this.generateCombinationsHelper(combinations, currentCombination, 0, 0, n);
        return combinations;
    }

    private void generateCombinationsHelper(List<List<Integer>> combinations, int[] currentCombination, int index, int start, int n) {
        if (index == n) {
            ArrayList<Integer> combination = new ArrayList<Integer>();
            for (int i = 0; i < n; ++i) {
                combination.add(currentCombination[i]);
            }
            combinations.add(combination);
            return;
        }
        for (int i = start; i < 6; ++i) {
            currentCombination[index] = i;
            this.generateCombinationsHelper(combinations, currentCombination, index + 1, i + 1, n);
        }
    }

    private Map<FluidStack, Integer> checkFluidsInCombination(List<FluidStack> requiredFluids, List<Integer> combination) {
        HashMap<FluidStack, Integer> matchedTanks = new HashMap<FluidStack, Integer>();
        for (FluidStack fluid : requiredFluids) {
            boolean fluidFound = false;
            for (int tankIndex : combination) {
                FluidStack tankFluid = this.tanks[tankIndex].getFluid();
                int tankAmount = this.tanks[tankIndex].getFluidAmount();
                if (!fluid.getFluid().isSame(tankFluid.getFluid()) || fluid.getAmount() > tankAmount) continue;
                matchedTanks.put(fluid, tankIndex);
                fluidFound = true;
                break;
            }
            if (fluidFound) continue;
            return null;
        }
        return matchedTanks;
    }

    private void addOutputFluid(FluidStack output) {
        this.OUTPUT_TANK.fill(output, IFluidHandler.FluidAction.EXECUTE);
    }

    private boolean hasOutputSpaceMaking(MixerBlockEntity entity, MixingRecipe recipe) {
        FluidStack output = recipe.outputFluid();
        FluidTank outputTank = entity.OUTPUT_TANK;
        return outputTank.getFluid().isEmpty() || outputTank.getFluid().getFluid().isSame(output.getFluid()) && outputTank.getFluidAmount() + output.getAmount() <= outputTank.getCapacity();
    }

    private void resetProgress() {
        this.progress = 0;
    }

    private void transferFluid(IFluidTank sourceTank, IFluidTank targetTank) {
        if (sourceTank.getFluidAmount() > 0) {
            int drainAmount = sourceTank.getFluidAmount();
            FluidStack drained = sourceTank.drain(drainAmount, IFluidHandler.FluidAction.SIMULATE);
            int filled = targetTank.fill(drained, IFluidHandler.FluidAction.EXECUTE);
            sourceTank.drain(filled, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    private boolean fuelInformation(BlockEntity entity) {
        if (entity == null) {
            return false;
        }
        Level level = entity.getLevel();
        if (level != null) {
            for (Direction direction : Direction.values()) {
                BlockEntity adjacentEntity = level.getBlockEntity(entity.getBlockPos().relative(direction));
                if (!(adjacentEntity instanceof TankBlockEntity)) continue;
                TankBlockEntity tankBlockEntity = (TankBlockEntity)adjacentEntity;
                List allFuels = level.getRecipeManager().getAllRecipesFor((RecipeType)FuelRecipe.Type.INSTANCE);
                for (RecipeHolder recipeHolder : allFuels) {
                    FuelRecipe recipe = (FuelRecipe)recipeHolder.value();
                    if (recipe.fluid().getFluid() != tankBlockEntity.FLUID_TANK.getFluid().getFluid()) continue;
                    this.fuelTemp = recipe.temp();
                }
            }
        }
        return false;
    }
}

