/*
 * Decompiled with CFR 0.152.
 */
package com.benbenlaw.casting.block.entity.multiblock;

import com.benbenlaw.casting.block.CastingBlocks;
import com.benbenlaw.casting.block.entity.CastingBlockEntities;
import com.benbenlaw.casting.block.entity.multiblock.MultiblockControllerBlockEntity;
import com.benbenlaw.casting.block.multiblock.MultiblockSolidifierBlock;
import com.benbenlaw.casting.recipe.CoolantRecipe;
import com.benbenlaw.casting.recipe.SolidifierRecipe;
import com.benbenlaw.casting.screen.multiblock.MultiblockSolidifierMenu;
import com.benbenlaw.casting.util.CastingTags;
import com.benbenlaw.casting.util.SingleFluidTank;
import com.benbenlaw.core.block.entity.SyncableBlockEntity;
import com.benbenlaw.core.block.entity.handler.IInventoryHandlingBlockEntity;
import com.benbenlaw.core.block.entity.handler.InputOutputItemHandler;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MultiblockSolidifierBlockEntity
extends SyncableBlockEntity
implements MenuProvider,
IInventoryHandlingBlockEntity {
    private final ItemStackHandler itemHandler = new ItemStackHandler(2){

        protected void onContentsChanged(int slot) {
            MultiblockSolidifierBlockEntity.this.setChanged();
            MultiblockSolidifierBlockEntity.this.sync();
        }

        protected int getStackLimit(int slot, ItemStack stack) {
            if (slot == 0 && stack.is(CastingTags.Items.MOLDS)) {
                return 1;
            }
            return 64;
        }

        public int getSlotLimit(int slot) {
            if (slot == 0 && MultiblockSolidifierBlockEntity.this.itemHandler.getStackInSlot(slot).is(CastingTags.Items.MOLDS)) {
                return 1;
            }
            return 64;
        }
    };
    public final ContainerData data;
    public int progress = 0;
    public int maxProgress;
    public int SOLIDIFIER_MAX_PROGRESS = 300;
    public String selectedFluidString;
    public SingleFluidTank coolantTank;
    public MultiblockControllerBlockEntity controller;
    public BlockPos controllerPos;
    public FluidStack coolantFluidStack = FluidStack.EMPTY;
    private final IItemHandler solidifierItemHandler = new InputOutputItemHandler((IItemHandlerModifiable)this.itemHandler, (i, stack) -> i == 0, i -> i == 1);

    public IFluidHandler getFluidHandlerCapability(Direction side) {
        return null;
    }

    @Nullable
    public IItemHandler getItemHandlerCapability(@Nullable Direction side) {
        return this.solidifierItemHandler;
    }

    public void setHandler(ItemStackHandler handler) {
        for (int i = 0; i < handler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, handler.getStackInSlot(i));
        }
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemHandler;
    }

    public MultiblockSolidifierBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CastingBlockEntities.MULTIBLOCK_SOLIDIFIER_BLOCK_ENTITY.get(), pos, state);
        this.data = new ContainerData(){

            public int get(int index) {
                return switch (index) {
                    case 0 -> MultiblockSolidifierBlockEntity.this.progress;
                    case 1 -> MultiblockSolidifierBlockEntity.this.maxProgress;
                    default -> 0;
                };
            }

            public void set(int index, int value) {
                switch (index) {
                    case 0: {
                        MultiblockSolidifierBlockEntity.this.progress = value;
                        break;
                    }
                    case 1: {
                        MultiblockSolidifierBlockEntity.this.maxProgress = value;
                    }
                }
            }

            public int getCount() {
                return 2;
            }
        };
    }

    public Component getDisplayName() {
        return ((Block)CastingBlocks.MULTIBLOCK_SOLIDIFIER.get()).getName();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int container, @NotNull Inventory inventory, @NotNull Player player) {
        return new MultiblockSolidifierMenu(container, inventory, this.getBlockPos(), this.data);
    }

    public void tick() {
        assert (this.level != null);
        if (this.controller != null && this.controller.isRemoved()) {
            this.controller.fluidHandler = null;
            this.controller = null;
        }
        if (!this.level.isClientSide()) {
            if (!((Boolean)this.getBlockState().getValue((Property)MultiblockSolidifierBlock.ENABLED)).booleanValue()) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockSolidifierBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                return;
            }
            if (this.controller == null) {
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockSolidifierBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                this.resetProgress();
                return;
            }
            RecipeInput inventory = new RecipeInput(){

                @NotNull
                public ItemStack getItem(int index) {
                    return MultiblockSolidifierBlockEntity.this.itemHandler.getStackInSlot(index);
                }

                public int size() {
                    return MultiblockSolidifierBlockEntity.this.itemHandler.getSlots();
                }
            };
            this.sync();
            if (this.itemHandler.getStackInSlot(0).isEmpty()) {
                this.resetProgress();
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockSolidifierBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
                return;
            }
            boolean foundMatch = false;
            for (RecipeHolder recipeHolder : this.level.getRecipeManager().getRecipesFor((RecipeType)SolidifierRecipe.Type.INSTANCE, inventory, this.level)) {
                SolidifierRecipe recipe = (SolidifierRecipe)recipeHolder.value();
                Fluid recipeFluid = recipe.fluid().getFluid();
                boolean filterMatches = this.selectedFluidString.equals("minecraft:empty") || this.getSelectedFluid().isSame(recipeFluid);
                if (!filterMatches || !recipe.mold().test(this.itemHandler.getStackInSlot(0)) || !this.hasEnoughFluid(recipe.fluid()) || !this.hasCorrectInputAmount(recipe.mold())) continue;
                FluidStack output = recipe.fluid();
                this.updateSpeed();
                if (!this.hasOutputSpaceMaking(this, recipe)) continue;
                ++this.progress;
                this.level.setBlock(this.worldPosition, (BlockState)this.getBlockState().setValue((Property)MultiblockSolidifierBlock.WORKING, (Comparable)Boolean.valueOf(true)), 3);
                if (this.progress >= this.maxProgress) {
                    this.extractFluid(output, output.getAmount());
                    if (!this.itemHandler.getStackInSlot(0).is(CastingTags.Items.MOLDS)) {
                        this.itemHandler.getStackInSlot(0).shrink(recipe.mold().count());
                    }
                    this.itemHandler.setStackInSlot(1, new ItemStack((ItemLike)recipe.output().getItems()[0].getItem(), recipe.output().count() + this.itemHandler.getStackInSlot(1).getCount()));
                    this.setChanged();
                    this.resetProgress();
                }
                foundMatch = true;
                break;
            }
            if (!foundMatch) {
                this.resetProgress();
            }
        }
    }

    public void setCoolantTank(SingleFluidTank coolantTank) {
        this.coolantTank = coolantTank;
    }

    public Fluid getSelectedFluid() {
        return (Fluid)BuiltInRegistries.FLUID.get(ResourceLocation.parse((String)this.selectedFluidString));
    }

    public void setSelectedFluid(String fluid) {
        this.selectedFluidString = fluid;
        this.sync();
    }

    private boolean hasCorrectInputAmount(SizedIngredient mold) {
        return this.itemHandler.getStackInSlot(0).getCount() >= mold.count();
    }

    private void updateSpeed() {
        this.maxProgress = this.SOLIDIFIER_MAX_PROGRESS;
        assert (this.level != null);
        if (this.coolantTank == null) {
            return;
        }
        List allFuels = this.level.getRecipeManager().getAllRecipesFor((RecipeType)CoolantRecipe.Type.INSTANCE);
        for (RecipeHolder recipeHolder : allFuels) {
            CoolantRecipe recipe = (CoolantRecipe)recipeHolder.value();
            if (recipe.fluid().getFluid() != this.coolantTank.getFluid().getFluid()) continue;
            this.maxProgress = Math.max(recipe.duration(), 10);
            this.coolantFluidStack = recipe.fluid();
        }
    }

    private void resetProgress() {
        this.progress = 0;
    }

    public void setControllerBlockEntity(MultiblockControllerBlockEntity entity) {
        this.controller = entity;
    }

    public void setControllerPos(BlockPos controllerPos) {
        this.controllerPos = controllerPos;
    }

    private void extractFluid(FluidStack output, int amount) {
        Fluid recipeFluid = output.getFluid();
        if (this.coolantTank != null && this.maxProgress <= this.SOLIDIFIER_MAX_PROGRESS && !this.coolantFluidStack.isEmpty()) {
            this.coolantTank.drain(this.coolantFluidStack, IFluidHandler.FluidAction.EXECUTE);
        }
        List<FluidStack> fluids = this.controller.fluidHandler.getFluids();
        for (FluidStack fluid : fluids) {
            if (fluid.isEmpty() || fluid.getFluid() != recipeFluid || fluid.getAmount() < amount) continue;
            this.controller.fluidHandler.drain(new FluidStack(recipeFluid, amount), IFluidHandler.FluidAction.EXECUTE);
            return;
        }
    }

    private boolean hasEnoughFluid(FluidStack required) {
        if (this.controller == null) {
            return false;
        }
        List<FluidStack> fluids = this.controller.fluidHandler.getFluids();
        for (FluidStack fluid : fluids) {
            if (fluid.isEmpty() || fluid.getFluid() != required.getFluid()) continue;
            return fluid.getAmount() >= required.getAmount();
        }
        return false;
    }

    private boolean tankIsValidForSlot(FluidStack stack, int slot) {
        Fluid selected = this.getSelectedFluid();
        return selected != null && stack.getFluid() == selected;
    }

    private boolean hasOutputSpaceMaking(MultiblockSolidifierBlockEntity entity, SolidifierRecipe recipe) {
        ItemStack outputSlotStack = entity.itemHandler.getStackInSlot(1);
        SizedIngredient resultStack = recipe.output();
        if (outputSlotStack.isEmpty()) {
            return recipe.output().count() <= resultStack.getItems()[0].getItem().getDefaultMaxStackSize();
        }
        if (outputSlotStack.getItem() == resultStack.getItems()[0].getItem()) {
            return outputSlotStack.getCount() + recipe.output().count() <= outputSlotStack.getMaxStackSize();
        }
        return false;
    }

    public void drops() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        assert (this.level != null);
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    protected void saveAdditional(@NotNull CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        super.saveAdditional(compoundTag, provider);
        compoundTag.put("inventory", (Tag)this.itemHandler.serializeNBT(provider));
        compoundTag.putInt("progress", this.progress);
        compoundTag.putInt("maxProgress", this.maxProgress);
        if (this.selectedFluidString == null) {
            this.selectedFluidString = "minecraft:empty";
        } else {
            compoundTag.putString("selectedFluidString", this.selectedFluidString);
        }
        if (this.coolantTank != null) {
            compoundTag.put("coolantTank", (Tag)this.coolantTank.writeToNBT(provider, new CompoundTag()));
        }
        if (this.controllerPos != null) {
            compoundTag.putInt("controllerPosX", this.controllerPos.getX());
            compoundTag.putInt("controllerPosY", this.controllerPos.getY());
            compoundTag.putInt("controllerPosZ", this.controllerPos.getZ());
        }
    }

    protected void loadAdditional(CompoundTag compoundTag, // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull HolderLookup.Provider provider) {
        this.itemHandler.deserializeNBT(provider, compoundTag.getCompound("inventory"));
        this.progress = compoundTag.getInt("progress");
        this.maxProgress = compoundTag.getInt("maxProgress");
        this.selectedFluidString = compoundTag.contains("selectedFluidString") ? compoundTag.getString("selectedFluidString") : "minecraft:empty";
        if (compoundTag.contains("coolantTank") && this.coolantTank != null) {
            this.coolantTank.readFromNBT(provider, compoundTag.getCompound("coolantTank"));
        }
        this.controllerPos = compoundTag.contains("controllerPosX") && compoundTag.contains("controllerPosY") && compoundTag.contains("controllerPosZ") ? new BlockPos(compoundTag.getInt("controllerPosX"), compoundTag.getInt("controllerPosY"), compoundTag.getInt("controllerPosZ")) : null;
    }
}

